<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GET_SHEET_DIFFERENCES_REQUEST StructType
 * @subpackage Structs
 */
class GET_SHEET_DIFFERENCES_REQUEST extends AbstractStructBase
{
    /**
     * The ISBUREAU
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ISBUREAU;
    /**
     * The RFC
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: RFC | VENDOR_NUMBER
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 13
     * - minLength: 12
     * - whiteSpace: collapse
     * @var string
     */
    public $RFC;
    /**
     * The VENDOR_NUMBER
     * Meta information extracted from the WSDL
     * - choice: RFC | VENDOR_NUMBER
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var int
     */
    public $VENDOR_NUMBER;
    /**
     * The PURCHASE_ORDER
     * @var int
     */
    public $PURCHASE_ORDER;
    /**
     * The RECEIPT_NUMBER
     * @var int
     */
    public $RECEIPT_NUMBER;
    /**
     * The login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The pass
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pass;
    /**
     * Constructor method for GET_SHEET_DIFFERENCES_REQUEST
     * @uses GET_SHEET_DIFFERENCES_REQUEST::setISBUREAU()
     * @uses GET_SHEET_DIFFERENCES_REQUEST::setRFC()
     * @uses GET_SHEET_DIFFERENCES_REQUEST::setVENDOR_NUMBER()
     * @uses GET_SHEET_DIFFERENCES_REQUEST::setPURCHASE_ORDER()
     * @uses GET_SHEET_DIFFERENCES_REQUEST::setRECEIPT_NUMBER()
     * @uses GET_SHEET_DIFFERENCES_REQUEST::setLogin()
     * @uses GET_SHEET_DIFFERENCES_REQUEST::setPass()
     * @param int $iSBUREAU
     * @param string $rFC
     * @param int $vENDOR_NUMBER
     * @param int $pURCHASE_ORDER
     * @param int $rECEIPT_NUMBER
     * @param string $login
     * @param string $pass
     */
    public function __construct($iSBUREAU = null, $rFC = null, $vENDOR_NUMBER = null, $pURCHASE_ORDER = null, $rECEIPT_NUMBER = null, $login = null, $pass = null)
    {
        $this
            ->setISBUREAU($iSBUREAU)
            ->setRFC($rFC)
            ->setVENDOR_NUMBER($vENDOR_NUMBER)
            ->setPURCHASE_ORDER($pURCHASE_ORDER)
            ->setRECEIPT_NUMBER($rECEIPT_NUMBER)
            ->setLogin($login)
            ->setPass($pass);
    }
    /**
     * Get ISBUREAU value
     * @return int|null
     */
    public function getISBUREAU()
    {
        return $this->ISBUREAU;
    }
    /**
     * Set ISBUREAU value
     * @param int $iSBUREAU
     * @return \StructType\GET_SHEET_DIFFERENCES_REQUEST
     */
    public function setISBUREAU($iSBUREAU = null)
    {
        // validation for constraint: int
        if (!is_null($iSBUREAU) && !(is_int($iSBUREAU) || ctype_digit($iSBUREAU))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iSBUREAU, true), gettype($iSBUREAU)), __LINE__);
        }
        $this->ISBUREAU = $iSBUREAU;
        return $this;
    }
    /**
     * Get RFC value
     * @return string|null
     */
    public function getRFC()
    {
        return isset($this->RFC) ? $this->RFC : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRFC method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRFC method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRFCForChoiceConstraintsFromSetRFC($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'VENDOR_NUMBER',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RFC can\'t be set as the property %s is already set. Only one property must be set among these properties: RFC, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RFC value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $rFC
     * @return \StructType\GET_SHEET_DIFFERENCES_REQUEST
     */
    public function setRFC($rFC = null)
    {
        // validation for constraint: string
        if (!is_null($rFC) && !is_string($rFC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFC, true), gettype($rFC)), __LINE__);
        }
        // validation for constraint: choice(RFC, VENDOR_NUMBER)
        if ('' !== ($rFCChoiceErrorMessage = self::validateRFCForChoiceConstraintsFromSetRFC($rFC))) {
            throw new \InvalidArgumentException($rFCChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(13)
        if (!is_null($rFC) && mb_strlen($rFC) > 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 13', mb_strlen($rFC)), __LINE__);
        }
        // validation for constraint: minLength(12)
        if (!is_null($rFC) && mb_strlen($rFC) < 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 12', mb_strlen($rFC)), __LINE__);
        }
        if (is_null($rFC) || (is_array($rFC) && empty($rFC))) {
            unset($this->RFC);
        } else {
            $this->RFC = $rFC;
        }
        return $this;
    }
    /**
     * Get VENDOR_NUMBER value
     * @return int|null
     */
    public function getVENDOR_NUMBER()
    {
        return isset($this->VENDOR_NUMBER) ? $this->VENDOR_NUMBER : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVENDOR_NUMBER method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVENDOR_NUMBER method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVENDOR_NUMBERForChoiceConstraintsFromSetVENDOR_NUMBER($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'RFC',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VENDOR_NUMBER can\'t be set as the property %s is already set. Only one property must be set among these properties: VENDOR_NUMBER, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set VENDOR_NUMBER value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $vENDOR_NUMBER
     * @return \StructType\GET_SHEET_DIFFERENCES_REQUEST
     */
    public function setVENDOR_NUMBER($vENDOR_NUMBER = null)
    {
        // validation for constraint: int
        if (!is_null($vENDOR_NUMBER) && !(is_int($vENDOR_NUMBER) || ctype_digit($vENDOR_NUMBER))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vENDOR_NUMBER, true), gettype($vENDOR_NUMBER)), __LINE__);
        }
        // validation for constraint: choice(RFC, VENDOR_NUMBER)
        if ('' !== ($vENDOR_NUMBERChoiceErrorMessage = self::validateVENDOR_NUMBERForChoiceConstraintsFromSetVENDOR_NUMBER($vENDOR_NUMBER))) {
            throw new \InvalidArgumentException($vENDOR_NUMBERChoiceErrorMessage, __LINE__);
        }
        if (is_null($vENDOR_NUMBER) || (is_array($vENDOR_NUMBER) && empty($vENDOR_NUMBER))) {
            unset($this->VENDOR_NUMBER);
        } else {
            $this->VENDOR_NUMBER = $vENDOR_NUMBER;
        }
        return $this;
    }
    /**
     * Get PURCHASE_ORDER value
     * @return int|null
     */
    public function getPURCHASE_ORDER()
    {
        return $this->PURCHASE_ORDER;
    }
    /**
     * Set PURCHASE_ORDER value
     * @param int $pURCHASE_ORDER
     * @return \StructType\GET_SHEET_DIFFERENCES_REQUEST
     */
    public function setPURCHASE_ORDER($pURCHASE_ORDER = null)
    {
        // validation for constraint: int
        if (!is_null($pURCHASE_ORDER) && !(is_int($pURCHASE_ORDER) || ctype_digit($pURCHASE_ORDER))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pURCHASE_ORDER, true), gettype($pURCHASE_ORDER)), __LINE__);
        }
        $this->PURCHASE_ORDER = $pURCHASE_ORDER;
        return $this;
    }
    /**
     * Get RECEIPT_NUMBER value
     * @return int|null
     */
    public function getRECEIPT_NUMBER()
    {
        return $this->RECEIPT_NUMBER;
    }
    /**
     * Set RECEIPT_NUMBER value
     * @param int $rECEIPT_NUMBER
     * @return \StructType\GET_SHEET_DIFFERENCES_REQUEST
     */
    public function setRECEIPT_NUMBER($rECEIPT_NUMBER = null)
    {
        // validation for constraint: int
        if (!is_null($rECEIPT_NUMBER) && !(is_int($rECEIPT_NUMBER) || ctype_digit($rECEIPT_NUMBER))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rECEIPT_NUMBER, true), gettype($rECEIPT_NUMBER)), __LINE__);
        }
        $this->RECEIPT_NUMBER = $rECEIPT_NUMBER;
        return $this;
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\GET_SHEET_DIFFERENCES_REQUEST
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get pass value
     * @return string|null
     */
    public function getPass()
    {
        return $this->pass;
    }
    /**
     * Set pass value
     * @param string $pass
     * @return \StructType\GET_SHEET_DIFFERENCES_REQUEST
     */
    public function setPass($pass = null)
    {
        // validation for constraint: string
        if (!is_null($pass) && !is_string($pass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pass, true), gettype($pass)), __LINE__);
        }
        $this->pass = $pass;
        return $this;
    }
}
