<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for extendedAttributes StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional que especifica la información adicional de lote del producto facturado
 * @subpackage Structs
 */
class ExtendedAttributes extends AbstractStructBase
{
    /**
     * The lotNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * @var \StructType\LotNumber[]
     */
    public $lotNumber;
    /**
     * Constructor method for extendedAttributes
     * @uses ExtendedAttributes::setLotNumber()
     * @param \StructType\LotNumber[] $lotNumber
     */
    public function __construct(array $lotNumber = array())
    {
        $this
            ->setLotNumber($lotNumber);
    }
    /**
     * Get lotNumber value
     * @return \StructType\LotNumber[]|null
     */
    public function getLotNumber()
    {
        return $this->lotNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setLotNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLotNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLotNumberForArrayConstraintsFromSetLotNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $extendedAttributesLotNumberItem) {
            // validation for constraint: itemType
            if (!$extendedAttributesLotNumberItem instanceof \StructType\LotNumber) {
                $invalidValues[] = is_object($extendedAttributesLotNumberItem) ? get_class($extendedAttributesLotNumberItem) : sprintf('%s(%s)', gettype($extendedAttributesLotNumberItem), var_export($extendedAttributesLotNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lotNumber property can only contain items of type \StructType\LotNumber, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lotNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\LotNumber[] $lotNumber
     * @return \StructType\ExtendedAttributes
     */
    public function setLotNumber(array $lotNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($lotNumberArrayErrorMessage = self::validateLotNumberForArrayConstraintsFromSetLotNumber($lotNumber))) {
            throw new \InvalidArgumentException($lotNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($lotNumber) && count($lotNumber) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($lotNumber)), __LINE__);
        }
        $this->lotNumber = $lotNumber;
        return $this;
    }
    /**
     * Add item to lotNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\LotNumber $item
     * @return \StructType\ExtendedAttributes
     */
    public function addToLotNumber(\StructType\LotNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LotNumber) {
            throw new \InvalidArgumentException(sprintf('The lotNumber property can only contain items of type \StructType\LotNumber, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->lotNumber) && count($this->lotNumber) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->lotNumber)), __LINE__);
        }
        $this->lotNumber[] = $item;
        return $this;
    }
}
