<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for errorDescription StructType
 * @subpackage Structs
 */
class ErrorDescription extends AbstractStructBase
{
    /**
     * The text
     * Meta information extracted from the WSDL
     * - documentation: Nodo requerido que especifica información de texto que aplica a todo el mensaje de la factura. La información estará en función al código del tema de texto | Contacto de Nodo requerido que especifica el contacto de compras |
     * SG4FTX 4451
     * - base: xsd:string
     * - form: qualified
     * - maxLength: 200
     * - minLength: 1
     * @var string
     */
    public $text;
    /**
     * Constructor method for errorDescription
     * @uses ErrorDescription::setText()
     * @param string $text
     */
    public function __construct($text = null)
    {
        $this
            ->setText($text);
    }
    /**
     * Get text value
     * @return string|null
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \StructType\ErrorDescription
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($text) && mb_strlen($text) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($text)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($text) && mb_strlen($text) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
}
