<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Emisor StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo requerido para expresar la información del contribuyente emisor del comprobante.
 * @subpackage Structs
 */
class Emisor extends AbstractStructBase
{
    /**
     * The RegimenFiscal
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para incorporar la clave del régimen del contribuyente emisor al que aplicará el efecto fiscal de este comprobante.
     * - use: required
     * @var string
     */
    public $RegimenFiscal;
    /**
     * The Rfc
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para registrar la Clave del Registro Federal de Contribuyentes correspondiente al contribuyente emisor del comprobante. | Tipo definido para expresar claves del Registro Federal de Contribuyentes
     * - base: xs:string
     * - maxLength: 13
     * - minLength: 12
     * - pattern: [A-Z&Ñ]{3,4}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $Rfc;
    /**
     * The Nombre
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 254
     * - minLength: 1
     * - pattern: [^|]{1,254}
     * - whiteSpace: collapse
     * @var string
     */
    public $Nombre;
    /**
     * Constructor method for Emisor
     * @uses Emisor::setRegimenFiscal()
     * @uses Emisor::setRfc()
     * @uses Emisor::setNombre()
     * @param string $regimenFiscal
     * @param string $rfc
     * @param string $nombre
     */
    public function __construct($regimenFiscal = null, $rfc = null, $nombre = null)
    {
        $this
            ->setRegimenFiscal($regimenFiscal)
            ->setRfc($rfc)
            ->setNombre($nombre);
    }
    /**
     * Get RegimenFiscal value
     * @return string
     */
    public function getRegimenFiscal()
    {
        return $this->RegimenFiscal;
    }
    /**
     * Set RegimenFiscal value
     * @uses \EnumType\C_RegimenFiscal::valueIsValid()
     * @uses \EnumType\C_RegimenFiscal::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $regimenFiscal
     * @return \StructType\Emisor
     */
    public function setRegimenFiscal($regimenFiscal = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\C_RegimenFiscal::valueIsValid($regimenFiscal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\C_RegimenFiscal', is_array($regimenFiscal) ? implode(', ', $regimenFiscal) : var_export($regimenFiscal, true), implode(', ', \EnumType\C_RegimenFiscal::getValidValues())), __LINE__);
        }
        $this->RegimenFiscal = $regimenFiscal;
        return $this;
    }
    /**
     * Get Rfc value
     * @return string
     */
    public function getRfc()
    {
        return $this->Rfc;
    }
    /**
     * Set Rfc value
     * @param string $rfc
     * @return \StructType\Emisor
     */
    public function setRfc($rfc = null)
    {
        // validation for constraint: string
        if (!is_null($rfc) && !is_string($rfc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rfc, true), gettype($rfc)), __LINE__);
        }
        // validation for constraint: maxLength(13)
        if (!is_null($rfc) && mb_strlen($rfc) > 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 13', mb_strlen($rfc)), __LINE__);
        }
        // validation for constraint: minLength(12)
        if (!is_null($rfc) && mb_strlen($rfc) < 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 12', mb_strlen($rfc)), __LINE__);
        }
        // validation for constraint: pattern([A-Z&Ñ]{3,4}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A])
        if (!is_null($rfc) && !preg_match('/[A-Z&Ñ]{3,4}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]/', $rfc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z&Ñ]{3,4}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]', var_export($rfc, true)), __LINE__);
        }
        $this->Rfc = $rfc;
        return $this;
    }
    /**
     * Get Nombre value
     * @return string|null
     */
    public function getNombre()
    {
        return $this->Nombre;
    }
    /**
     * Set Nombre value
     * @param string $nombre
     * @return \StructType\Emisor
     */
    public function setNombre($nombre = null)
    {
        // validation for constraint: string
        if (!is_null($nombre) && !is_string($nombre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombre, true), gettype($nombre)), __LINE__);
        }
        // validation for constraint: maxLength(254)
        if (!is_null($nombre) && mb_strlen($nombre) > 254) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 254', mb_strlen($nombre)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nombre) && mb_strlen($nombre) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nombre)), __LINE__);
        }
        // validation for constraint: pattern([^|]{1,254})
        if (!is_null($nombre) && !preg_match('/[^|]{1,254}/', $nombre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^|]{1,254}', var_export($nombre, true)), __LINE__);
        }
        $this->Nombre = $nombre;
        return $this;
    }
}
