<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoctoRelacionado StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo condicional para expresar la lista de documentos relacionados con los pagos diferentes de anticipos. Por cada documento que se relacione se debe generar un nodo DoctoRelacionado.
 * @subpackage Structs
 */
class DoctoRelacionado extends AbstractStructBase
{
    /**
     * The IdDocumento
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 36
     * - minLength: 16
     * - pattern: ([a-f0-9A-F]{8}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{12})|([0-9]{3}-[0-9]{2}-[0-9]{9})
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $IdDocumento;
    /**
     * The MetodoDePagoDR
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para expresar la clave del método de pago que se registró en el documento relacionado.
     * - use: required
     * @var string
     */
    public $MetodoDePagoDR;
    /**
     * The MonedaDR
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para identificar la clave de la moneda utilizada en los importes del documento relacionado, cuando se usa moneda nacional o el documento relacionado no especifica la moneda se registra MXN. Los importes registrados
     * en los atributos “ImpSaldoAnt”, “ImpPagado” e “ImpSaldoInsoluto” de éste nodo, deben corresponder a esta moneda. Conforme con la especificación ISO 4217.
     * - base: xs:string
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $MonedaDR;
    /**
     * The Folio
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 40
     * - minLength: 1
     * - pattern: [^|]{1,40}
     * - whiteSpace: collapse
     * @var string
     */
    public $Folio;
    /**
     * The ImpPagado
     * Meta information extracted from the WSDL
     * - documentation: Atributo condicional para expresar el importe pagado para el documento relacionado. Es obligatorio cuando exista más de un documento relacionado o cuando existe un documento relacionado y el TipoCambioDR tiene un valor. | Tipo
     * definido para expresar importes numéricos con fracción hasta seis decimales. El valor se redondea de acuerdo con el número de decimales que soporta la moneda. No se permiten valores negativos. | Tipo definido para expresar importes numéricos con
     * fracción hasta seis decimales
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.0
     * - pattern: [0-9]{1,18}(.[0-9]{1,6})?
     * - whiteSpace: collapse
     * @var float
     */
    public $ImpPagado;
    /**
     * The ImpSaldoAnt
     * Meta information extracted from the WSDL
     * - documentation: Atributo condicional para expresar el monto del saldo insoluto de la parcialidad anterior. Es requerido cuando MetodoDePagoDR contiene: “PPD” Pago en parcialidades o diferido.En el caso de que sea la primer parcialidad este campo
     * debe contener el importe total del documento relacionado. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales. El valor se redondea de acuerdo con el número de decimales que soporta la moneda. No se permiten valores
     * negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.0
     * - pattern: [0-9]{1,18}(.[0-9]{1,6})?
     * - whiteSpace: collapse
     * @var float
     */
    public $ImpSaldoAnt;
    /**
     * The ImpSaldoInsoluto
     * Meta information extracted from the WSDL
     * - documentation: Atributo condicional para expresar la diferencia entre el importe del saldo anterior y el monto del pago. Es requerido cuando MetodoDePagoDR contiene: “PPD” Pago en parcialidades o diferido. | Tipo definido para expresar importes
     * numéricos con fracción hasta seis decimales. El valor se redondea de acuerdo con el número de decimales que soporta la moneda. No se permiten valores negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.0
     * - pattern: [0-9]{1,18}(.[0-9]{1,6})?
     * - whiteSpace: collapse
     * @var float
     */
    public $ImpSaldoInsoluto;
    /**
     * The NumParcialidad
     * Meta information extracted from the WSDL
     * - base: xs:integer
     * - pattern: [1-9][0-9]{0,2}
     * - whiteSpace: collapse
     * @var int
     */
    public $NumParcialidad;
    /**
     * The Serie
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [^|]{1,25}
     * - whiteSpace: collapse
     * @var string
     */
    public $Serie;
    /**
     * The TipoCambioDR
     * Meta information extracted from the WSDL
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.000001
     * - whiteSpace: collapse
     * @var float
     */
    public $TipoCambioDR;
    /**
     * Constructor method for DoctoRelacionado
     * @uses DoctoRelacionado::setIdDocumento()
     * @uses DoctoRelacionado::setMetodoDePagoDR()
     * @uses DoctoRelacionado::setMonedaDR()
     * @uses DoctoRelacionado::setFolio()
     * @uses DoctoRelacionado::setImpPagado()
     * @uses DoctoRelacionado::setImpSaldoAnt()
     * @uses DoctoRelacionado::setImpSaldoInsoluto()
     * @uses DoctoRelacionado::setNumParcialidad()
     * @uses DoctoRelacionado::setSerie()
     * @uses DoctoRelacionado::setTipoCambioDR()
     * @param string $idDocumento
     * @param string $metodoDePagoDR
     * @param string $monedaDR
     * @param string $folio
     * @param float $impPagado
     * @param float $impSaldoAnt
     * @param float $impSaldoInsoluto
     * @param int $numParcialidad
     * @param string $serie
     * @param float $tipoCambioDR
     */
    public function __construct($idDocumento = null, $metodoDePagoDR = null, $monedaDR = null, $folio = null, $impPagado = null, $impSaldoAnt = null, $impSaldoInsoluto = null, $numParcialidad = null, $serie = null, $tipoCambioDR = null)
    {
        $this
            ->setIdDocumento($idDocumento)
            ->setMetodoDePagoDR($metodoDePagoDR)
            ->setMonedaDR($monedaDR)
            ->setFolio($folio)
            ->setImpPagado($impPagado)
            ->setImpSaldoAnt($impSaldoAnt)
            ->setImpSaldoInsoluto($impSaldoInsoluto)
            ->setNumParcialidad($numParcialidad)
            ->setSerie($serie)
            ->setTipoCambioDR($tipoCambioDR);
    }
    /**
     * Get IdDocumento value
     * @return string
     */
    public function getIdDocumento()
    {
        return $this->IdDocumento;
    }
    /**
     * Set IdDocumento value
     * @param string $idDocumento
     * @return \StructType\DoctoRelacionado
     */
    public function setIdDocumento($idDocumento = null)
    {
        // validation for constraint: string
        if (!is_null($idDocumento) && !is_string($idDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idDocumento, true), gettype($idDocumento)), __LINE__);
        }
        // validation for constraint: maxLength(36)
        if (!is_null($idDocumento) && mb_strlen($idDocumento) > 36) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 36', mb_strlen($idDocumento)), __LINE__);
        }
        // validation for constraint: minLength(16)
        if (!is_null($idDocumento) && mb_strlen($idDocumento) < 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 16', mb_strlen($idDocumento)), __LINE__);
        }
        // validation for constraint: pattern(([a-f0-9A-F]{8}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{12})|([0-9]{3}-[0-9]{2}-[0-9]{9}))
        if (!is_null($idDocumento) && !preg_match('/([a-f0-9A-F]{8}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{12})|([0-9]{3}-[0-9]{2}-[0-9]{9})/', $idDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([a-f0-9A-F]{8}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{12})|([0-9]{3}-[0-9]{2}-[0-9]{9})', var_export($idDocumento, true)), __LINE__);
        }
        $this->IdDocumento = $idDocumento;
        return $this;
    }
    /**
     * Get MetodoDePagoDR value
     * @return string
     */
    public function getMetodoDePagoDR()
    {
        return $this->MetodoDePagoDR;
    }
    /**
     * Set MetodoDePagoDR value
     * @uses \EnumType\C_MetodoPago::valueIsValid()
     * @uses \EnumType\C_MetodoPago::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $metodoDePagoDR
     * @return \StructType\DoctoRelacionado
     */
    public function setMetodoDePagoDR($metodoDePagoDR = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\C_MetodoPago::valueIsValid($metodoDePagoDR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\C_MetodoPago', is_array($metodoDePagoDR) ? implode(', ', $metodoDePagoDR) : var_export($metodoDePagoDR, true), implode(', ', \EnumType\C_MetodoPago::getValidValues())), __LINE__);
        }
        $this->MetodoDePagoDR = $metodoDePagoDR;
        return $this;
    }
    /**
     * Get MonedaDR value
     * @return string
     */
    public function getMonedaDR()
    {
        return $this->MonedaDR;
    }
    /**
     * Set MonedaDR value
     * @param string $monedaDR
     * @return \StructType\DoctoRelacionado
     */
    public function setMonedaDR($monedaDR = null)
    {
        // validation for constraint: string
        if (!is_null($monedaDR) && !is_string($monedaDR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monedaDR, true), gettype($monedaDR)), __LINE__);
        }
        $this->MonedaDR = $monedaDR;
        return $this;
    }
    /**
     * Get Folio value
     * @return string|null
     */
    public function getFolio()
    {
        return $this->Folio;
    }
    /**
     * Set Folio value
     * @param string $folio
     * @return \StructType\DoctoRelacionado
     */
    public function setFolio($folio = null)
    {
        // validation for constraint: string
        if (!is_null($folio) && !is_string($folio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($folio, true), gettype($folio)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($folio) && mb_strlen($folio) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($folio)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($folio) && mb_strlen($folio) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($folio)), __LINE__);
        }
        // validation for constraint: pattern([^|]{1,40})
        if (!is_null($folio) && !preg_match('/[^|]{1,40}/', $folio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^|]{1,40}', var_export($folio, true)), __LINE__);
        }
        $this->Folio = $folio;
        return $this;
    }
    /**
     * Get ImpPagado value
     * @return float|null
     */
    public function getImpPagado()
    {
        return $this->ImpPagado;
    }
    /**
     * Set ImpPagado value
     * @param float $impPagado
     * @return \StructType\DoctoRelacionado
     */
    public function setImpPagado($impPagado = null)
    {
        // validation for constraint: float
        if (!is_null($impPagado) && !(is_float($impPagado) || is_numeric($impPagado))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($impPagado, true), gettype($impPagado)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($impPagado) && mb_strlen(mb_substr($impPagado, false !== mb_strpos($impPagado, '.') ? mb_strpos($impPagado, '.') + 1 : mb_strlen($impPagado))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($impPagado, true), mb_strlen(mb_substr($impPagado, mb_strpos($impPagado, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($impPagado) && $impPagado < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($impPagado, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,18}(.[0-9]{1,6})?)
        if (!is_null($impPagado) && !preg_match('/[0-9]{1,18}(.[0-9]{1,6})?/', $impPagado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,18}(.[0-9]{1,6})?', var_export($impPagado, true)), __LINE__);
        }
        $this->ImpPagado = $impPagado;
        return $this;
    }
    /**
     * Get ImpSaldoAnt value
     * @return float|null
     */
    public function getImpSaldoAnt()
    {
        return $this->ImpSaldoAnt;
    }
    /**
     * Set ImpSaldoAnt value
     * @param float $impSaldoAnt
     * @return \StructType\DoctoRelacionado
     */
    public function setImpSaldoAnt($impSaldoAnt = null)
    {
        // validation for constraint: float
        if (!is_null($impSaldoAnt) && !(is_float($impSaldoAnt) || is_numeric($impSaldoAnt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($impSaldoAnt, true), gettype($impSaldoAnt)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($impSaldoAnt) && mb_strlen(mb_substr($impSaldoAnt, false !== mb_strpos($impSaldoAnt, '.') ? mb_strpos($impSaldoAnt, '.') + 1 : mb_strlen($impSaldoAnt))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($impSaldoAnt, true), mb_strlen(mb_substr($impSaldoAnt, mb_strpos($impSaldoAnt, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($impSaldoAnt) && $impSaldoAnt < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($impSaldoAnt, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,18}(.[0-9]{1,6})?)
        if (!is_null($impSaldoAnt) && !preg_match('/[0-9]{1,18}(.[0-9]{1,6})?/', $impSaldoAnt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,18}(.[0-9]{1,6})?', var_export($impSaldoAnt, true)), __LINE__);
        }
        $this->ImpSaldoAnt = $impSaldoAnt;
        return $this;
    }
    /**
     * Get ImpSaldoInsoluto value
     * @return float|null
     */
    public function getImpSaldoInsoluto()
    {
        return $this->ImpSaldoInsoluto;
    }
    /**
     * Set ImpSaldoInsoluto value
     * @param float $impSaldoInsoluto
     * @return \StructType\DoctoRelacionado
     */
    public function setImpSaldoInsoluto($impSaldoInsoluto = null)
    {
        // validation for constraint: float
        if (!is_null($impSaldoInsoluto) && !(is_float($impSaldoInsoluto) || is_numeric($impSaldoInsoluto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($impSaldoInsoluto, true), gettype($impSaldoInsoluto)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($impSaldoInsoluto) && mb_strlen(mb_substr($impSaldoInsoluto, false !== mb_strpos($impSaldoInsoluto, '.') ? mb_strpos($impSaldoInsoluto, '.') + 1 : mb_strlen($impSaldoInsoluto))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($impSaldoInsoluto, true), mb_strlen(mb_substr($impSaldoInsoluto, mb_strpos($impSaldoInsoluto, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($impSaldoInsoluto) && $impSaldoInsoluto < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($impSaldoInsoluto, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,18}(.[0-9]{1,6})?)
        if (!is_null($impSaldoInsoluto) && !preg_match('/[0-9]{1,18}(.[0-9]{1,6})?/', $impSaldoInsoluto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,18}(.[0-9]{1,6})?', var_export($impSaldoInsoluto, true)), __LINE__);
        }
        $this->ImpSaldoInsoluto = $impSaldoInsoluto;
        return $this;
    }
    /**
     * Get NumParcialidad value
     * @return int|null
     */
    public function getNumParcialidad()
    {
        return $this->NumParcialidad;
    }
    /**
     * Set NumParcialidad value
     * @param int $numParcialidad
     * @return \StructType\DoctoRelacionado
     */
    public function setNumParcialidad($numParcialidad = null)
    {
        // validation for constraint: int
        if (!is_null($numParcialidad) && !(is_int($numParcialidad) || ctype_digit($numParcialidad))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numParcialidad, true), gettype($numParcialidad)), __LINE__);
        }
        // validation for constraint: pattern([1-9][0-9]{0,2})
        if (!is_null($numParcialidad) && !preg_match('/[1-9][0-9]{0,2}/', $numParcialidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9][0-9]{0,2}', var_export($numParcialidad, true)), __LINE__);
        }
        $this->NumParcialidad = $numParcialidad;
        return $this;
    }
    /**
     * Get Serie value
     * @return string|null
     */
    public function getSerie()
    {
        return $this->Serie;
    }
    /**
     * Set Serie value
     * @param string $serie
     * @return \StructType\DoctoRelacionado
     */
    public function setSerie($serie = null)
    {
        // validation for constraint: string
        if (!is_null($serie) && !is_string($serie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serie, true), gettype($serie)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($serie) && mb_strlen($serie) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($serie)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($serie) && mb_strlen($serie) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($serie)), __LINE__);
        }
        // validation for constraint: pattern([^|]{1,25})
        if (!is_null($serie) && !preg_match('/[^|]{1,25}/', $serie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^|]{1,25}', var_export($serie, true)), __LINE__);
        }
        $this->Serie = $serie;
        return $this;
    }
    /**
     * Get TipoCambioDR value
     * @return float|null
     */
    public function getTipoCambioDR()
    {
        return $this->TipoCambioDR;
    }
    /**
     * Set TipoCambioDR value
     * @param float $tipoCambioDR
     * @return \StructType\DoctoRelacionado
     */
    public function setTipoCambioDR($tipoCambioDR = null)
    {
        // validation for constraint: float
        if (!is_null($tipoCambioDR) && !(is_float($tipoCambioDR) || is_numeric($tipoCambioDR))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tipoCambioDR, true), gettype($tipoCambioDR)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($tipoCambioDR) && mb_strlen(mb_substr($tipoCambioDR, false !== mb_strpos($tipoCambioDR, '.') ? mb_strpos($tipoCambioDR, '.') + 1 : mb_strlen($tipoCambioDR))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($tipoCambioDR, true), mb_strlen(mb_substr($tipoCambioDR, mb_strpos($tipoCambioDR, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.000001)
        if (!is_null($tipoCambioDR) && $tipoCambioDR < 0.000001) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.000001', var_export($tipoCambioDR, true)), __LINE__);
        }
        $this->TipoCambioDR = $tipoCambioDR;
        return $this;
    }
}
