<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for discountPayment StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional que especifica los descuentos por pago
 * @subpackage Structs
 */
class DiscountPayment extends AbstractStructBase
{
    /**
     * The discountType
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $discountType;
    /**
     * The percentage
     * Meta information extracted from the WSDL
     * - documentation: Nodo requerido que especifica el valor de los porcentajes que serán descontados o cargados si la factura no se paga dentro del término. El porcentaje será en base al valor de la factura
     * - base: xs:string
     * - maxLength: 5
     * - minLength: 1
     * @var string
     */
    public $percentage;
    /**
     * Constructor method for discountPayment
     * @uses DiscountPayment::setDiscountType()
     * @uses DiscountPayment::setPercentage()
     * @param string $discountType
     * @param string $percentage
     */
    public function __construct($discountType = null, $percentage = null)
    {
        $this
            ->setDiscountType($discountType)
            ->setPercentage($percentage);
    }
    /**
     * Get discountType value
     * @return string
     */
    public function getDiscountType()
    {
        return $this->discountType;
    }
    /**
     * Set discountType value
     * @param string $discountType
     * @return \StructType\DiscountPayment
     */
    public function setDiscountType($discountType = null)
    {
        // validation for constraint: string
        if (!is_null($discountType) && !is_string($discountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountType, true), gettype($discountType)), __LINE__);
        }
        $this->discountType = $discountType;
        return $this;
    }
    /**
     * Get percentage value
     * @return string|null
     */
    public function getPercentage()
    {
        return $this->percentage;
    }
    /**
     * Set percentage value
     * @param string $percentage
     * @return \StructType\DiscountPayment
     */
    public function setPercentage($percentage = null)
    {
        // validation for constraint: string
        if (!is_null($percentage) && !is_string($percentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($percentage, true), gettype($percentage)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($percentage) && mb_strlen($percentage) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($percentage)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($percentage) && mb_strlen($percentage) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($percentage)), __LINE__);
        }
        $this->percentage = $percentage;
        return $this;
    }
}
