<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for detallista StructType
 * Meta information extracted from the WSDL
 * - documentation: Complemento requerido para la emision y recepcion de comprobantes fiscales digitales en el sector Retail
 * @subpackage Structs
 */
class Detallista extends AbstractStructBase
{
    /**
     * The documentStatus
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $documentStatus;
    /**
     * The documentStructureVersion
     * Meta information extracted from the WSDL
     * - documentation: Versión de la estructura del documento generado "AMC8.1"
     * - use: required
     * @var string
     */
    public $documentStructureVersion;
    /**
     * The requestForPaymentIdentification
     * @var \StructType\RequestForPaymentIdentification
     */
    public $requestForPaymentIdentification;
    /**
     * The specialInstruction
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \StructType\SpecialInstruction[]
     */
    public $specialInstruction;
    /**
     * The orderIdentification
     * @var \StructType\OrderIdentification
     */
    public $orderIdentification;
    /**
     * The AdditionalInformation
     * @var \StructType\AdditionalInformation
     */
    public $AdditionalInformation;
    /**
     * The DeliveryNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeliveryNote
     */
    public $DeliveryNote;
    /**
     * The buyer
     * @var \StructType\Buyer
     */
    public $buyer;
    /**
     * The seller
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Seller
     */
    public $seller;
    /**
     * The shipTo
     * @var \StructType\ShipTo
     */
    public $shipTo;
    /**
     * The InvoiceCreator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InvoiceCreator
     */
    public $InvoiceCreator;
    /**
     * The Customs
     * Meta information extracted from the WSDL
     * - maxOccurs: 999999
     * - minOccurs: 0
     * @var \StructType\Customs[]
     */
    public $Customs;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\Currency[]
     */
    public $currency;
    /**
     * The paymentTerms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentTerms
     */
    public $paymentTerms;
    /**
     * The shipmentDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShipmentDetail
     */
    public $shipmentDetail;
    /**
     * The allowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\AllowanceCharge[]
     */
    public $allowanceCharge;
    /**
     * The lineItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 9999999
     * @var \StructType\LineItem[]
     */
    public $lineItem;
    /**
     * The totalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TotalAmount
     */
    public $totalAmount;
    /**
     * The TotalAllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: 999999
     * - minOccurs: 0
     * @var \StructType\TotalAllowanceCharge[]
     */
    public $TotalAllowanceCharge;
    /**
     * The contentVersion
     * Meta information extracted from the WSDL
     * - documentation: Versión del estandar XML utilizado para la elaboración de la guia del sector detallista
     * - default: 1.3.1
     * @var string
     */
    public $contentVersion;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - documentation: Tipo de transacción bajo estandar del sector detallista
     * - default: SimpleInvoiceType
     * @var string
     */
    public $type;
    /**
     * Constructor method for detallista
     * @uses Detallista::setDocumentStatus()
     * @uses Detallista::setDocumentStructureVersion()
     * @uses Detallista::setRequestForPaymentIdentification()
     * @uses Detallista::setSpecialInstruction()
     * @uses Detallista::setOrderIdentification()
     * @uses Detallista::setAdditionalInformation()
     * @uses Detallista::setDeliveryNote()
     * @uses Detallista::setBuyer()
     * @uses Detallista::setSeller()
     * @uses Detallista::setShipTo()
     * @uses Detallista::setInvoiceCreator()
     * @uses Detallista::setCustoms()
     * @uses Detallista::setCurrency()
     * @uses Detallista::setPaymentTerms()
     * @uses Detallista::setShipmentDetail()
     * @uses Detallista::setAllowanceCharge()
     * @uses Detallista::setLineItem()
     * @uses Detallista::setTotalAmount()
     * @uses Detallista::setTotalAllowanceCharge()
     * @uses Detallista::setContentVersion()
     * @uses Detallista::setType()
     * @param string $documentStatus
     * @param string $documentStructureVersion
     * @param \StructType\RequestForPaymentIdentification $requestForPaymentIdentification
     * @param \StructType\SpecialInstruction[] $specialInstruction
     * @param \StructType\OrderIdentification $orderIdentification
     * @param \StructType\AdditionalInformation $additionalInformation
     * @param \StructType\DeliveryNote $deliveryNote
     * @param \StructType\Buyer $buyer
     * @param \StructType\Seller $seller
     * @param \StructType\ShipTo $shipTo
     * @param \StructType\InvoiceCreator $invoiceCreator
     * @param \StructType\Customs[] $customs
     * @param \StructType\Currency[] $currency
     * @param \StructType\PaymentTerms $paymentTerms
     * @param \StructType\ShipmentDetail $shipmentDetail
     * @param \StructType\AllowanceCharge[] $allowanceCharge
     * @param \StructType\LineItem[] $lineItem
     * @param \StructType\TotalAmount $totalAmount
     * @param \StructType\TotalAllowanceCharge[] $totalAllowanceCharge
     * @param string $contentVersion
     * @param string $type
     */
    public function __construct($documentStatus = null, $documentStructureVersion = null, \StructType\RequestForPaymentIdentification $requestForPaymentIdentification = null, array $specialInstruction = array(), \StructType\OrderIdentification $orderIdentification = null, \StructType\AdditionalInformation $additionalInformation = null, \StructType\DeliveryNote $deliveryNote = null, \StructType\Buyer $buyer = null, \StructType\Seller $seller = null, \StructType\ShipTo $shipTo = null, \StructType\InvoiceCreator $invoiceCreator = null, array $customs = array(), array $currency = array(), \StructType\PaymentTerms $paymentTerms = null, \StructType\ShipmentDetail $shipmentDetail = null, array $allowanceCharge = array(), array $lineItem = array(), \StructType\TotalAmount $totalAmount = null, array $totalAllowanceCharge = array(), $contentVersion = '1.3.1', $type = 'SimpleInvoiceType')
    {
        $this
            ->setDocumentStatus($documentStatus)
            ->setDocumentStructureVersion($documentStructureVersion)
            ->setRequestForPaymentIdentification($requestForPaymentIdentification)
            ->setSpecialInstruction($specialInstruction)
            ->setOrderIdentification($orderIdentification)
            ->setAdditionalInformation($additionalInformation)
            ->setDeliveryNote($deliveryNote)
            ->setBuyer($buyer)
            ->setSeller($seller)
            ->setShipTo($shipTo)
            ->setInvoiceCreator($invoiceCreator)
            ->setCustoms($customs)
            ->setCurrency($currency)
            ->setPaymentTerms($paymentTerms)
            ->setShipmentDetail($shipmentDetail)
            ->setAllowanceCharge($allowanceCharge)
            ->setLineItem($lineItem)
            ->setTotalAmount($totalAmount)
            ->setTotalAllowanceCharge($totalAllowanceCharge)
            ->setContentVersion($contentVersion)
            ->setType($type);
    }
    /**
     * Get documentStatus value
     * @return string
     */
    public function getDocumentStatus()
    {
        return $this->documentStatus;
    }
    /**
     * Set documentStatus value
     * @param string $documentStatus
     * @return \StructType\Detallista
     */
    public function setDocumentStatus($documentStatus = null)
    {
        // validation for constraint: string
        if (!is_null($documentStatus) && !is_string($documentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentStatus, true), gettype($documentStatus)), __LINE__);
        }
        $this->documentStatus = $documentStatus;
        return $this;
    }
    /**
     * Get documentStructureVersion value
     * @return string
     */
    public function getDocumentStructureVersion()
    {
        return $this->documentStructureVersion;
    }
    /**
     * Set documentStructureVersion value
     * @param string $documentStructureVersion
     * @return \StructType\Detallista
     */
    public function setDocumentStructureVersion($documentStructureVersion = null)
    {
        // validation for constraint: string
        if (!is_null($documentStructureVersion) && !is_string($documentStructureVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentStructureVersion, true), gettype($documentStructureVersion)), __LINE__);
        }
        $this->documentStructureVersion = $documentStructureVersion;
        return $this;
    }
    /**
     * Get requestForPaymentIdentification value
     * @return \StructType\RequestForPaymentIdentification|null
     */
    public function getRequestForPaymentIdentification()
    {
        return $this->requestForPaymentIdentification;
    }
    /**
     * Set requestForPaymentIdentification value
     * @param \StructType\RequestForPaymentIdentification $requestForPaymentIdentification
     * @return \StructType\Detallista
     */
    public function setRequestForPaymentIdentification(\StructType\RequestForPaymentIdentification $requestForPaymentIdentification = null)
    {
        $this->requestForPaymentIdentification = $requestForPaymentIdentification;
        return $this;
    }
    /**
     * Get specialInstruction value
     * @return \StructType\SpecialInstruction[]|null
     */
    public function getSpecialInstruction()
    {
        return $this->specialInstruction;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialInstruction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialInstruction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialInstructionForArrayConstraintsFromSetSpecialInstruction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detallistaSpecialInstructionItem) {
            // validation for constraint: itemType
            if (!$detallistaSpecialInstructionItem instanceof \StructType\SpecialInstruction) {
                $invalidValues[] = is_object($detallistaSpecialInstructionItem) ? get_class($detallistaSpecialInstructionItem) : sprintf('%s(%s)', gettype($detallistaSpecialInstructionItem), var_export($detallistaSpecialInstructionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The specialInstruction property can only contain items of type \StructType\SpecialInstruction, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set specialInstruction value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialInstruction[] $specialInstruction
     * @return \StructType\Detallista
     */
    public function setSpecialInstruction(array $specialInstruction = array())
    {
        // validation for constraint: array
        if ('' !== ($specialInstructionArrayErrorMessage = self::validateSpecialInstructionForArrayConstraintsFromSetSpecialInstruction($specialInstruction))) {
            throw new \InvalidArgumentException($specialInstructionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($specialInstruction) && count($specialInstruction) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($specialInstruction)), __LINE__);
        }
        $this->specialInstruction = $specialInstruction;
        return $this;
    }
    /**
     * Add item to specialInstruction value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialInstruction $item
     * @return \StructType\Detallista
     */
    public function addToSpecialInstruction(\StructType\SpecialInstruction $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecialInstruction) {
            throw new \InvalidArgumentException(sprintf('The specialInstruction property can only contain items of type \StructType\SpecialInstruction, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->specialInstruction) && count($this->specialInstruction) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->specialInstruction)), __LINE__);
        }
        $this->specialInstruction[] = $item;
        return $this;
    }
    /**
     * Get orderIdentification value
     * @return \StructType\OrderIdentification|null
     */
    public function getOrderIdentification()
    {
        return $this->orderIdentification;
    }
    /**
     * Set orderIdentification value
     * @param \StructType\OrderIdentification $orderIdentification
     * @return \StructType\Detallista
     */
    public function setOrderIdentification(\StructType\OrderIdentification $orderIdentification = null)
    {
        $this->orderIdentification = $orderIdentification;
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * @return \StructType\AdditionalInformation|null
     */
    public function getAdditionalInformation()
    {
        return $this->AdditionalInformation;
    }
    /**
     * Set AdditionalInformation value
     * @param \StructType\AdditionalInformation $additionalInformation
     * @return \StructType\Detallista
     */
    public function setAdditionalInformation(\StructType\AdditionalInformation $additionalInformation = null)
    {
        $this->AdditionalInformation = $additionalInformation;
        return $this;
    }
    /**
     * Get DeliveryNote value
     * @return \StructType\DeliveryNote|null
     */
    public function getDeliveryNote()
    {
        return $this->DeliveryNote;
    }
    /**
     * Set DeliveryNote value
     * @param \StructType\DeliveryNote $deliveryNote
     * @return \StructType\Detallista
     */
    public function setDeliveryNote(\StructType\DeliveryNote $deliveryNote = null)
    {
        $this->DeliveryNote = $deliveryNote;
        return $this;
    }
    /**
     * Get buyer value
     * @return \StructType\Buyer|null
     */
    public function getBuyer()
    {
        return $this->buyer;
    }
    /**
     * Set buyer value
     * @param \StructType\Buyer $buyer
     * @return \StructType\Detallista
     */
    public function setBuyer(\StructType\Buyer $buyer = null)
    {
        $this->buyer = $buyer;
        return $this;
    }
    /**
     * Get seller value
     * @return \StructType\Seller|null
     */
    public function getSeller()
    {
        return $this->seller;
    }
    /**
     * Set seller value
     * @param \StructType\Seller $seller
     * @return \StructType\Detallista
     */
    public function setSeller(\StructType\Seller $seller = null)
    {
        $this->seller = $seller;
        return $this;
    }
    /**
     * Get shipTo value
     * @return \StructType\ShipTo|null
     */
    public function getShipTo()
    {
        return $this->shipTo;
    }
    /**
     * Set shipTo value
     * @param \StructType\ShipTo $shipTo
     * @return \StructType\Detallista
     */
    public function setShipTo(\StructType\ShipTo $shipTo = null)
    {
        $this->shipTo = $shipTo;
        return $this;
    }
    /**
     * Get InvoiceCreator value
     * @return \StructType\InvoiceCreator|null
     */
    public function getInvoiceCreator()
    {
        return $this->InvoiceCreator;
    }
    /**
     * Set InvoiceCreator value
     * @param \StructType\InvoiceCreator $invoiceCreator
     * @return \StructType\Detallista
     */
    public function setInvoiceCreator(\StructType\InvoiceCreator $invoiceCreator = null)
    {
        $this->InvoiceCreator = $invoiceCreator;
        return $this;
    }
    /**
     * Get Customs value
     * @return \StructType\Customs[]|null
     */
    public function getCustoms()
    {
        return $this->Customs;
    }
    /**
     * This method is responsible for validating the values passed to the setCustoms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustoms method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomsForArrayConstraintsFromSetCustoms(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detallistaCustomsItem) {
            // validation for constraint: itemType
            if (!$detallistaCustomsItem instanceof \StructType\Customs) {
                $invalidValues[] = is_object($detallistaCustomsItem) ? get_class($detallistaCustomsItem) : sprintf('%s(%s)', gettype($detallistaCustomsItem), var_export($detallistaCustomsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Customs property can only contain items of type \StructType\Customs, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Customs value
     * @throws \InvalidArgumentException
     * @param \StructType\Customs[] $customs
     * @return \StructType\Detallista
     */
    public function setCustoms(array $customs = array())
    {
        // validation for constraint: array
        if ('' !== ($customsArrayErrorMessage = self::validateCustomsForArrayConstraintsFromSetCustoms($customs))) {
            throw new \InvalidArgumentException($customsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(999999)
        if (is_array($customs) && count($customs) > 999999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 999999', count($customs)), __LINE__);
        }
        $this->Customs = $customs;
        return $this;
    }
    /**
     * Add item to Customs value
     * @throws \InvalidArgumentException
     * @param \StructType\Customs $item
     * @return \StructType\Detallista
     */
    public function addToCustoms(\StructType\Customs $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Customs) {
            throw new \InvalidArgumentException(sprintf('The Customs property can only contain items of type \StructType\Customs, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(999999)
        if (is_array($this->Customs) && count($this->Customs) >= 999999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 999999', count($this->Customs)), __LINE__);
        }
        $this->Customs[] = $item;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\Currency[]|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrencyForArrayConstraintsFromSetCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detallistaCurrencyItem) {
            // validation for constraint: itemType
            if (!$detallistaCurrencyItem instanceof \StructType\Currency) {
                $invalidValues[] = is_object($detallistaCurrencyItem) ? get_class($detallistaCurrencyItem) : sprintf('%s(%s)', gettype($detallistaCurrencyItem), var_export($detallistaCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The currency property can only contain items of type \StructType\Currency, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set currency value
     * @throws \InvalidArgumentException
     * @param \StructType\Currency[] $currency
     * @return \StructType\Detallista
     */
    public function setCurrency(array $currency = array())
    {
        // validation for constraint: array
        if ('' !== ($currencyArrayErrorMessage = self::validateCurrencyForArrayConstraintsFromSetCurrency($currency))) {
            throw new \InvalidArgumentException($currencyArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($currency) && count($currency) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Add item to currency value
     * @throws \InvalidArgumentException
     * @param \StructType\Currency $item
     * @return \StructType\Detallista
     */
    public function addToCurrency(\StructType\Currency $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Currency) {
            throw new \InvalidArgumentException(sprintf('The currency property can only contain items of type \StructType\Currency, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->currency) && count($this->currency) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->currency)), __LINE__);
        }
        $this->currency[] = $item;
        return $this;
    }
    /**
     * Get paymentTerms value
     * @return \StructType\PaymentTerms|null
     */
    public function getPaymentTerms()
    {
        return $this->paymentTerms;
    }
    /**
     * Set paymentTerms value
     * @param \StructType\PaymentTerms $paymentTerms
     * @return \StructType\Detallista
     */
    public function setPaymentTerms(\StructType\PaymentTerms $paymentTerms = null)
    {
        $this->paymentTerms = $paymentTerms;
        return $this;
    }
    /**
     * Get shipmentDetail value
     * @return \StructType\ShipmentDetail|null
     */
    public function getShipmentDetail()
    {
        return $this->shipmentDetail;
    }
    /**
     * Set shipmentDetail value
     * @param \StructType\ShipmentDetail $shipmentDetail
     * @return \StructType\Detallista
     */
    public function setShipmentDetail(\StructType\ShipmentDetail $shipmentDetail = null)
    {
        $this->shipmentDetail = $shipmentDetail;
        return $this;
    }
    /**
     * Get allowanceCharge value
     * @return \StructType\AllowanceCharge[]|null
     */
    public function getAllowanceCharge()
    {
        return $this->allowanceCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setAllowanceCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllowanceCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detallistaAllowanceChargeItem) {
            // validation for constraint: itemType
            if (!$detallistaAllowanceChargeItem instanceof \StructType\AllowanceCharge) {
                $invalidValues[] = is_object($detallistaAllowanceChargeItem) ? get_class($detallistaAllowanceChargeItem) : sprintf('%s(%s)', gettype($detallistaAllowanceChargeItem), var_export($detallistaAllowanceChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The allowanceCharge property can only contain items of type \StructType\AllowanceCharge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set allowanceCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\AllowanceCharge[] $allowanceCharge
     * @return \StructType\Detallista
     */
    public function setAllowanceCharge(array $allowanceCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($allowanceChargeArrayErrorMessage = self::validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge($allowanceCharge))) {
            throw new \InvalidArgumentException($allowanceChargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($allowanceCharge) && count($allowanceCharge) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($allowanceCharge)), __LINE__);
        }
        $this->allowanceCharge = $allowanceCharge;
        return $this;
    }
    /**
     * Add item to allowanceCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\AllowanceCharge $item
     * @return \StructType\Detallista
     */
    public function addToAllowanceCharge(\StructType\AllowanceCharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AllowanceCharge) {
            throw new \InvalidArgumentException(sprintf('The allowanceCharge property can only contain items of type \StructType\AllowanceCharge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->allowanceCharge) && count($this->allowanceCharge) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->allowanceCharge)), __LINE__);
        }
        $this->allowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get lineItem value
     * @return \StructType\LineItem[]|null
     */
    public function getLineItem()
    {
        return $this->lineItem;
    }
    /**
     * This method is responsible for validating the values passed to the setLineItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLineItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLineItemForArrayConstraintsFromSetLineItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detallistaLineItemItem) {
            // validation for constraint: itemType
            if (!$detallistaLineItemItem instanceof \StructType\LineItem) {
                $invalidValues[] = is_object($detallistaLineItemItem) ? get_class($detallistaLineItemItem) : sprintf('%s(%s)', gettype($detallistaLineItemItem), var_export($detallistaLineItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lineItem property can only contain items of type \StructType\LineItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lineItem value
     * @throws \InvalidArgumentException
     * @param \StructType\LineItem[] $lineItem
     * @return \StructType\Detallista
     */
    public function setLineItem(array $lineItem = array())
    {
        // validation for constraint: array
        if ('' !== ($lineItemArrayErrorMessage = self::validateLineItemForArrayConstraintsFromSetLineItem($lineItem))) {
            throw new \InvalidArgumentException($lineItemArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9999999)
        if (is_array($lineItem) && count($lineItem) > 9999999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9999999', count($lineItem)), __LINE__);
        }
        $this->lineItem = $lineItem;
        return $this;
    }
    /**
     * Add item to lineItem value
     * @throws \InvalidArgumentException
     * @param \StructType\LineItem $item
     * @return \StructType\Detallista
     */
    public function addToLineItem(\StructType\LineItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LineItem) {
            throw new \InvalidArgumentException(sprintf('The lineItem property can only contain items of type \StructType\LineItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9999999)
        if (is_array($this->lineItem) && count($this->lineItem) >= 9999999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9999999', count($this->lineItem)), __LINE__);
        }
        $this->lineItem[] = $item;
        return $this;
    }
    /**
     * Get totalAmount value
     * @return \StructType\TotalAmount|null
     */
    public function getTotalAmount()
    {
        return $this->totalAmount;
    }
    /**
     * Set totalAmount value
     * @param \StructType\TotalAmount $totalAmount
     * @return \StructType\Detallista
     */
    public function setTotalAmount(\StructType\TotalAmount $totalAmount = null)
    {
        $this->totalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get TotalAllowanceCharge value
     * @return \StructType\TotalAllowanceCharge[]|null
     */
    public function getTotalAllowanceCharge()
    {
        return $this->TotalAllowanceCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setTotalAllowanceCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTotalAllowanceCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTotalAllowanceChargeForArrayConstraintsFromSetTotalAllowanceCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detallistaTotalAllowanceChargeItem) {
            // validation for constraint: itemType
            if (!$detallistaTotalAllowanceChargeItem instanceof \StructType\TotalAllowanceCharge) {
                $invalidValues[] = is_object($detallistaTotalAllowanceChargeItem) ? get_class($detallistaTotalAllowanceChargeItem) : sprintf('%s(%s)', gettype($detallistaTotalAllowanceChargeItem), var_export($detallistaTotalAllowanceChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TotalAllowanceCharge property can only contain items of type \StructType\TotalAllowanceCharge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TotalAllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\TotalAllowanceCharge[] $totalAllowanceCharge
     * @return \StructType\Detallista
     */
    public function setTotalAllowanceCharge(array $totalAllowanceCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($totalAllowanceChargeArrayErrorMessage = self::validateTotalAllowanceChargeForArrayConstraintsFromSetTotalAllowanceCharge($totalAllowanceCharge))) {
            throw new \InvalidArgumentException($totalAllowanceChargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(999999)
        if (is_array($totalAllowanceCharge) && count($totalAllowanceCharge) > 999999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 999999', count($totalAllowanceCharge)), __LINE__);
        }
        $this->TotalAllowanceCharge = $totalAllowanceCharge;
        return $this;
    }
    /**
     * Add item to TotalAllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\TotalAllowanceCharge $item
     * @return \StructType\Detallista
     */
    public function addToTotalAllowanceCharge(\StructType\TotalAllowanceCharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TotalAllowanceCharge) {
            throw new \InvalidArgumentException(sprintf('The TotalAllowanceCharge property can only contain items of type \StructType\TotalAllowanceCharge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(999999)
        if (is_array($this->TotalAllowanceCharge) && count($this->TotalAllowanceCharge) >= 999999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 999999', count($this->TotalAllowanceCharge)), __LINE__);
        }
        $this->TotalAllowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get contentVersion value
     * @return string|null
     */
    public function getContentVersion()
    {
        return $this->contentVersion;
    }
    /**
     * Set contentVersion value
     * @param string $contentVersion
     * @return \StructType\Detallista
     */
    public function setContentVersion($contentVersion = '1.3.1')
    {
        // validation for constraint: string
        if (!is_null($contentVersion) && !is_string($contentVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentVersion, true), gettype($contentVersion)), __LINE__);
        }
        $this->contentVersion = $contentVersion;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\Detallista
     */
    public function setType($type = 'SimpleInvoiceType')
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
