<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for despatchAdviceNumber StructType
 * @subpackage Structs
 */
class DespatchAdviceNumber extends AbstractStructBase
{
    /**
     * The referenceIdentification
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - form: qualified
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $referenceIdentification;
    /**
     * Constructor method for despatchAdviceNumber
     * @uses DespatchAdviceNumber::setReferenceIdentification()
     * @param string $referenceIdentification
     */
    public function __construct($referenceIdentification = null)
    {
        $this
            ->setReferenceIdentification($referenceIdentification);
    }
    /**
     * Get referenceIdentification value
     * @return string|null
     */
    public function getReferenceIdentification()
    {
        return $this->referenceIdentification;
    }
    /**
     * Set referenceIdentification value
     * @param string $referenceIdentification
     * @return \StructType\DespatchAdviceNumber
     */
    public function setReferenceIdentification($referenceIdentification = null)
    {
        // validation for constraint: string
        if (!is_null($referenceIdentification) && !is_string($referenceIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceIdentification, true), gettype($referenceIdentification)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($referenceIdentification) && mb_strlen($referenceIdentification) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($referenceIdentification)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($referenceIdentification) && mb_strlen($referenceIdentification) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($referenceIdentification)), __LINE__);
        }
        $this->referenceIdentification = $referenceIdentification;
        return $this;
    }
}
