<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryNote StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional donde se especifica información de recepción de mercancia.Información emitida por el comprador cuando recibe la mercancía que es facturada
 * @subpackage Structs
 */
class DeliveryNote extends AbstractStructBase
{
    /**
     * The referenceIdentification
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 35
     * - maxOccurs: 30
     * - minLength: 1
     * @var string[]
     */
    public $referenceIdentification;
    /**
     * The ReferenceDate
     * Meta information extracted from the WSDL
     * - documentation: Nodo opcional que especifica la fecha en que fue asignado el no. de folio de recibo
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceDate;
    /**
     * Constructor method for DeliveryNote
     * @uses DeliveryNote::setReferenceIdentification()
     * @uses DeliveryNote::setReferenceDate()
     * @param string[] $referenceIdentification
     * @param string $referenceDate
     */
    public function __construct(array $referenceIdentification = array(), $referenceDate = null)
    {
        $this
            ->setReferenceIdentification($referenceIdentification)
            ->setReferenceDate($referenceDate);
    }
    /**
     * Get referenceIdentification value
     * @return string[]|null
     */
    public function getReferenceIdentification()
    {
        return $this->referenceIdentification;
    }
    /**
     * This method is responsible for validating the values passed to the setReferenceIdentification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenceIdentification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceIdentificationForArrayConstraintsFromSetReferenceIdentification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deliveryNoteReferenceIdentificationItem) {
            // validation for constraint: itemType
            if (!is_string($deliveryNoteReferenceIdentificationItem)) {
                $invalidValues[] = is_object($deliveryNoteReferenceIdentificationItem) ? get_class($deliveryNoteReferenceIdentificationItem) : sprintf('%s(%s)', gettype($deliveryNoteReferenceIdentificationItem), var_export($deliveryNoteReferenceIdentificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The referenceIdentification property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setReferenceIdentification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenceIdentification method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceIdentificationForMaxLengthConstraintFromSetReferenceIdentification($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deliveryNoteReferenceIdentificationItem) {
            // validation for constraint: maxLength(35)
            if (mb_strlen($deliveryNoteReferenceIdentificationItem) > 35) {
                $invalidValues[] = var_export($deliveryNoteReferenceIdentificationItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 35', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setReferenceIdentification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenceIdentification method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceIdentificationForMinLengthConstraintFromSetReferenceIdentification($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deliveryNoteReferenceIdentificationItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($deliveryNoteReferenceIdentificationItem) < 1) {
                $invalidValues[] = var_export($deliveryNoteReferenceIdentificationItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set referenceIdentification value
     * @throws \InvalidArgumentException
     * @param string[] $referenceIdentification
     * @return \StructType\DeliveryNote
     */
    public function setReferenceIdentification(array $referenceIdentification = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceIdentificationArrayErrorMessage = self::validateReferenceIdentificationForArrayConstraintsFromSetReferenceIdentification($referenceIdentification))) {
            throw new \InvalidArgumentException($referenceIdentificationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(35)
        if ('' !== ($referenceIdentificationMaxLengthErrorMessage = self::validateReferenceIdentificationForMaxLengthConstraintFromSetReferenceIdentification($referenceIdentification))) {
            throw new \InvalidArgumentException($referenceIdentificationMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($referenceIdentification) && count($referenceIdentification) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($referenceIdentification)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($referenceIdentificationMinLengthErrorMessage = self::validateReferenceIdentificationForMinLengthConstraintFromSetReferenceIdentification($referenceIdentification))) {
            throw new \InvalidArgumentException($referenceIdentificationMinLengthErrorMessage, __LINE__);
        }
        $this->referenceIdentification = $referenceIdentification;
        return $this;
    }
    /**
     * Add item to referenceIdentification value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DeliveryNote
     */
    public function addToReferenceIdentification($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The referenceIdentification property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (mb_strlen($item) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->referenceIdentification) && count($this->referenceIdentification) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->referenceIdentification)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->referenceIdentification[] = $item;
        return $this;
    }
    /**
     * Get ReferenceDate value
     * @return string|null
     */
    public function getReferenceDate()
    {
        return $this->ReferenceDate;
    }
    /**
     * Set ReferenceDate value
     * @param string $referenceDate
     * @return \StructType\DeliveryNote
     */
    public function setReferenceDate($referenceDate = null)
    {
        // validation for constraint: string
        if (!is_null($referenceDate) && !is_string($referenceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceDate, true), gettype($referenceDate)), __LINE__);
        }
        $this->ReferenceDate = $referenceDate;
        return $this;
    }
}
