<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DETAIL StructType
 * @subpackage Structs
 */
class DETAIL extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $ID;
    /**
     * The PRODUCT_ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PRODUCT_ID;
    /**
     * The BAR_CODE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BAR_CODE;
    /**
     * The DEPARTMENT_ARTICLE_ID
     * @var int
     */
    public $DEPARTMENT_ARTICLE_ID;
    /**
     * The DEPARTMENT_ARTICLE_DESC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DEPARTMENT_ARTICLE_DESC;
    /**
     * The ARTICLE_DESC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ARTICLE_DESC;
    /**
     * The RECEIPT_QUANTITY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RECEIPT_QUANTITY;
    /**
     * The MEASUREMENT_UNIT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MEASUREMENT_UNIT;
    /**
     * The ORDERED_QUANTITY
     * @var int
     */
    public $ORDERED_QUANTITY;
    /**
     * The DIFFERENCES
     * @var int
     */
    public $DIFFERENCES;
    /**
     * The BILLED_QUANTITY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BILLED_QUANTITY;
    /**
     * The UNLIKE_UNITS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UNLIKE_UNITS;
    /**
     * The AUTHORIZED_PRICE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUTHORIZED_PRICE;
    /**
     * The BILLED_PRICE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BILLED_PRICE;
    /**
     * The PRICE_DIFFERENCE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PRICE_DIFFERENCE;
    /**
     * The DISCOUNT_RATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DISCOUNT_RATE;
    /**
     * The IVA_RATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $IVA_RATE;
    /**
     * The IEPS25
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $IEPS25;
    /**
     * The IEPS30
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $IEPS30;
    /**
     * The IEPS53
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $IEPS53;
    /**
     * The GROSS_AMOUNT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $GROSS_AMOUNT;
    /**
     * The ENTIRE_AMOUNT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ENTIRE_AMOUNT;
    /**
     * The IVA_AMOUNT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $IVA_AMOUNT;
    /**
     * The IEPS_AMOUNT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $IEPS_AMOUNT;
    /**
     * The TOTAL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TOTAL;
    /**
     * The DISCOUNTS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DISCOUNTS;
    /**
     * The DIFFERENCE_KEY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DIFFERENCE_KEY;
    /**
     * The DIFFERENCE_KEY_DESC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DIFFERENCE_KEY_DESC;
    /**
     * The AMOUNT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AMOUNT;
    /**
     * Constructor method for DETAIL
     * @uses DETAIL::setID()
     * @uses DETAIL::setPRODUCT_ID()
     * @uses DETAIL::setBAR_CODE()
     * @uses DETAIL::setDEPARTMENT_ARTICLE_ID()
     * @uses DETAIL::setDEPARTMENT_ARTICLE_DESC()
     * @uses DETAIL::setARTICLE_DESC()
     * @uses DETAIL::setRECEIPT_QUANTITY()
     * @uses DETAIL::setMEASUREMENT_UNIT()
     * @uses DETAIL::setORDERED_QUANTITY()
     * @uses DETAIL::setDIFFERENCES()
     * @uses DETAIL::setBILLED_QUANTITY()
     * @uses DETAIL::setUNLIKE_UNITS()
     * @uses DETAIL::setAUTHORIZED_PRICE()
     * @uses DETAIL::setBILLED_PRICE()
     * @uses DETAIL::setPRICE_DIFFERENCE()
     * @uses DETAIL::setDISCOUNT_RATE()
     * @uses DETAIL::setIVA_RATE()
     * @uses DETAIL::setIEPS25()
     * @uses DETAIL::setIEPS30()
     * @uses DETAIL::setIEPS53()
     * @uses DETAIL::setGROSS_AMOUNT()
     * @uses DETAIL::setENTIRE_AMOUNT()
     * @uses DETAIL::setIVA_AMOUNT()
     * @uses DETAIL::setIEPS_AMOUNT()
     * @uses DETAIL::setTOTAL()
     * @uses DETAIL::setDISCOUNTS()
     * @uses DETAIL::setDIFFERENCE_KEY()
     * @uses DETAIL::setDIFFERENCE_KEY_DESC()
     * @uses DETAIL::setAMOUNT()
     * @param int $iD
     * @param int $pRODUCT_ID
     * @param string $bAR_CODE
     * @param int $dEPARTMENT_ARTICLE_ID
     * @param string $dEPARTMENT_ARTICLE_DESC
     * @param string $aRTICLE_DESC
     * @param int $rECEIPT_QUANTITY
     * @param string $mEASUREMENT_UNIT
     * @param int $oRDERED_QUANTITY
     * @param int $dIFFERENCES
     * @param int $bILLED_QUANTITY
     * @param int $uNLIKE_UNITS
     * @param float $aUTHORIZED_PRICE
     * @param float $bILLED_PRICE
     * @param float $pRICE_DIFFERENCE
     * @param float $dISCOUNT_RATE
     * @param float $iVA_RATE
     * @param float $iEPS25
     * @param float $iEPS30
     * @param float $iEPS53
     * @param float $gROSS_AMOUNT
     * @param float $eNTIRE_AMOUNT
     * @param float $iVA_AMOUNT
     * @param float $iEPS_AMOUNT
     * @param float $tOTAL
     * @param float $dISCOUNTS
     * @param int $dIFFERENCE_KEY
     * @param string $dIFFERENCE_KEY_DESC
     * @param float $aMOUNT
     */
    public function __construct($iD = null, $pRODUCT_ID = null, $bAR_CODE = null, $dEPARTMENT_ARTICLE_ID = null, $dEPARTMENT_ARTICLE_DESC = null, $aRTICLE_DESC = null, $rECEIPT_QUANTITY = null, $mEASUREMENT_UNIT = null, $oRDERED_QUANTITY = null, $dIFFERENCES = null, $bILLED_QUANTITY = null, $uNLIKE_UNITS = null, $aUTHORIZED_PRICE = null, $bILLED_PRICE = null, $pRICE_DIFFERENCE = null, $dISCOUNT_RATE = null, $iVA_RATE = null, $iEPS25 = null, $iEPS30 = null, $iEPS53 = null, $gROSS_AMOUNT = null, $eNTIRE_AMOUNT = null, $iVA_AMOUNT = null, $iEPS_AMOUNT = null, $tOTAL = null, $dISCOUNTS = null, $dIFFERENCE_KEY = null, $dIFFERENCE_KEY_DESC = null, $aMOUNT = null)
    {
        $this
            ->setID($iD)
            ->setPRODUCT_ID($pRODUCT_ID)
            ->setBAR_CODE($bAR_CODE)
            ->setDEPARTMENT_ARTICLE_ID($dEPARTMENT_ARTICLE_ID)
            ->setDEPARTMENT_ARTICLE_DESC($dEPARTMENT_ARTICLE_DESC)
            ->setARTICLE_DESC($aRTICLE_DESC)
            ->setRECEIPT_QUANTITY($rECEIPT_QUANTITY)
            ->setMEASUREMENT_UNIT($mEASUREMENT_UNIT)
            ->setORDERED_QUANTITY($oRDERED_QUANTITY)
            ->setDIFFERENCES($dIFFERENCES)
            ->setBILLED_QUANTITY($bILLED_QUANTITY)
            ->setUNLIKE_UNITS($uNLIKE_UNITS)
            ->setAUTHORIZED_PRICE($aUTHORIZED_PRICE)
            ->setBILLED_PRICE($bILLED_PRICE)
            ->setPRICE_DIFFERENCE($pRICE_DIFFERENCE)
            ->setDISCOUNT_RATE($dISCOUNT_RATE)
            ->setIVA_RATE($iVA_RATE)
            ->setIEPS25($iEPS25)
            ->setIEPS30($iEPS30)
            ->setIEPS53($iEPS53)
            ->setGROSS_AMOUNT($gROSS_AMOUNT)
            ->setENTIRE_AMOUNT($eNTIRE_AMOUNT)
            ->setIVA_AMOUNT($iVA_AMOUNT)
            ->setIEPS_AMOUNT($iEPS_AMOUNT)
            ->setTOTAL($tOTAL)
            ->setDISCOUNTS($dISCOUNTS)
            ->setDIFFERENCE_KEY($dIFFERENCE_KEY)
            ->setDIFFERENCE_KEY_DESC($dIFFERENCE_KEY_DESC)
            ->setAMOUNT($aMOUNT);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\DETAIL
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get PRODUCT_ID value
     * @return int|null
     */
    public function getPRODUCT_ID()
    {
        return $this->PRODUCT_ID;
    }
    /**
     * Set PRODUCT_ID value
     * @param int $pRODUCT_ID
     * @return \StructType\DETAIL
     */
    public function setPRODUCT_ID($pRODUCT_ID = null)
    {
        // validation for constraint: int
        if (!is_null($pRODUCT_ID) && !(is_int($pRODUCT_ID) || ctype_digit($pRODUCT_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pRODUCT_ID, true), gettype($pRODUCT_ID)), __LINE__);
        }
        $this->PRODUCT_ID = $pRODUCT_ID;
        return $this;
    }
    /**
     * Get BAR_CODE value
     * @return string|null
     */
    public function getBAR_CODE()
    {
        return $this->BAR_CODE;
    }
    /**
     * Set BAR_CODE value
     * @param string $bAR_CODE
     * @return \StructType\DETAIL
     */
    public function setBAR_CODE($bAR_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($bAR_CODE) && !is_string($bAR_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bAR_CODE, true), gettype($bAR_CODE)), __LINE__);
        }
        $this->BAR_CODE = $bAR_CODE;
        return $this;
    }
    /**
     * Get DEPARTMENT_ARTICLE_ID value
     * @return int|null
     */
    public function getDEPARTMENT_ARTICLE_ID()
    {
        return $this->DEPARTMENT_ARTICLE_ID;
    }
    /**
     * Set DEPARTMENT_ARTICLE_ID value
     * @param int $dEPARTMENT_ARTICLE_ID
     * @return \StructType\DETAIL
     */
    public function setDEPARTMENT_ARTICLE_ID($dEPARTMENT_ARTICLE_ID = null)
    {
        // validation for constraint: int
        if (!is_null($dEPARTMENT_ARTICLE_ID) && !(is_int($dEPARTMENT_ARTICLE_ID) || ctype_digit($dEPARTMENT_ARTICLE_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dEPARTMENT_ARTICLE_ID, true), gettype($dEPARTMENT_ARTICLE_ID)), __LINE__);
        }
        $this->DEPARTMENT_ARTICLE_ID = $dEPARTMENT_ARTICLE_ID;
        return $this;
    }
    /**
     * Get DEPARTMENT_ARTICLE_DESC value
     * @return string|null
     */
    public function getDEPARTMENT_ARTICLE_DESC()
    {
        return $this->DEPARTMENT_ARTICLE_DESC;
    }
    /**
     * Set DEPARTMENT_ARTICLE_DESC value
     * @param string $dEPARTMENT_ARTICLE_DESC
     * @return \StructType\DETAIL
     */
    public function setDEPARTMENT_ARTICLE_DESC($dEPARTMENT_ARTICLE_DESC = null)
    {
        // validation for constraint: string
        if (!is_null($dEPARTMENT_ARTICLE_DESC) && !is_string($dEPARTMENT_ARTICLE_DESC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dEPARTMENT_ARTICLE_DESC, true), gettype($dEPARTMENT_ARTICLE_DESC)), __LINE__);
        }
        $this->DEPARTMENT_ARTICLE_DESC = $dEPARTMENT_ARTICLE_DESC;
        return $this;
    }
    /**
     * Get ARTICLE_DESC value
     * @return string|null
     */
    public function getARTICLE_DESC()
    {
        return $this->ARTICLE_DESC;
    }
    /**
     * Set ARTICLE_DESC value
     * @param string $aRTICLE_DESC
     * @return \StructType\DETAIL
     */
    public function setARTICLE_DESC($aRTICLE_DESC = null)
    {
        // validation for constraint: string
        if (!is_null($aRTICLE_DESC) && !is_string($aRTICLE_DESC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aRTICLE_DESC, true), gettype($aRTICLE_DESC)), __LINE__);
        }
        $this->ARTICLE_DESC = $aRTICLE_DESC;
        return $this;
    }
    /**
     * Get RECEIPT_QUANTITY value
     * @return int|null
     */
    public function getRECEIPT_QUANTITY()
    {
        return $this->RECEIPT_QUANTITY;
    }
    /**
     * Set RECEIPT_QUANTITY value
     * @param int $rECEIPT_QUANTITY
     * @return \StructType\DETAIL
     */
    public function setRECEIPT_QUANTITY($rECEIPT_QUANTITY = null)
    {
        // validation for constraint: int
        if (!is_null($rECEIPT_QUANTITY) && !(is_int($rECEIPT_QUANTITY) || ctype_digit($rECEIPT_QUANTITY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rECEIPT_QUANTITY, true), gettype($rECEIPT_QUANTITY)), __LINE__);
        }
        $this->RECEIPT_QUANTITY = $rECEIPT_QUANTITY;
        return $this;
    }
    /**
     * Get MEASUREMENT_UNIT value
     * @return string|null
     */
    public function getMEASUREMENT_UNIT()
    {
        return $this->MEASUREMENT_UNIT;
    }
    /**
     * Set MEASUREMENT_UNIT value
     * @param string $mEASUREMENT_UNIT
     * @return \StructType\DETAIL
     */
    public function setMEASUREMENT_UNIT($mEASUREMENT_UNIT = null)
    {
        // validation for constraint: string
        if (!is_null($mEASUREMENT_UNIT) && !is_string($mEASUREMENT_UNIT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mEASUREMENT_UNIT, true), gettype($mEASUREMENT_UNIT)), __LINE__);
        }
        $this->MEASUREMENT_UNIT = $mEASUREMENT_UNIT;
        return $this;
    }
    /**
     * Get ORDERED_QUANTITY value
     * @return int|null
     */
    public function getORDERED_QUANTITY()
    {
        return $this->ORDERED_QUANTITY;
    }
    /**
     * Set ORDERED_QUANTITY value
     * @param int $oRDERED_QUANTITY
     * @return \StructType\DETAIL
     */
    public function setORDERED_QUANTITY($oRDERED_QUANTITY = null)
    {
        // validation for constraint: int
        if (!is_null($oRDERED_QUANTITY) && !(is_int($oRDERED_QUANTITY) || ctype_digit($oRDERED_QUANTITY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oRDERED_QUANTITY, true), gettype($oRDERED_QUANTITY)), __LINE__);
        }
        $this->ORDERED_QUANTITY = $oRDERED_QUANTITY;
        return $this;
    }
    /**
     * Get DIFFERENCES value
     * @return int|null
     */
    public function getDIFFERENCES()
    {
        return $this->DIFFERENCES;
    }
    /**
     * Set DIFFERENCES value
     * @param int $dIFFERENCES
     * @return \StructType\DETAIL
     */
    public function setDIFFERENCES($dIFFERENCES = null)
    {
        // validation for constraint: int
        if (!is_null($dIFFERENCES) && !(is_int($dIFFERENCES) || ctype_digit($dIFFERENCES))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dIFFERENCES, true), gettype($dIFFERENCES)), __LINE__);
        }
        $this->DIFFERENCES = $dIFFERENCES;
        return $this;
    }
    /**
     * Get BILLED_QUANTITY value
     * @return int|null
     */
    public function getBILLED_QUANTITY()
    {
        return $this->BILLED_QUANTITY;
    }
    /**
     * Set BILLED_QUANTITY value
     * @param int $bILLED_QUANTITY
     * @return \StructType\DETAIL
     */
    public function setBILLED_QUANTITY($bILLED_QUANTITY = null)
    {
        // validation for constraint: int
        if (!is_null($bILLED_QUANTITY) && !(is_int($bILLED_QUANTITY) || ctype_digit($bILLED_QUANTITY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bILLED_QUANTITY, true), gettype($bILLED_QUANTITY)), __LINE__);
        }
        $this->BILLED_QUANTITY = $bILLED_QUANTITY;
        return $this;
    }
    /**
     * Get UNLIKE_UNITS value
     * @return int|null
     */
    public function getUNLIKE_UNITS()
    {
        return $this->UNLIKE_UNITS;
    }
    /**
     * Set UNLIKE_UNITS value
     * @param int $uNLIKE_UNITS
     * @return \StructType\DETAIL
     */
    public function setUNLIKE_UNITS($uNLIKE_UNITS = null)
    {
        // validation for constraint: int
        if (!is_null($uNLIKE_UNITS) && !(is_int($uNLIKE_UNITS) || ctype_digit($uNLIKE_UNITS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uNLIKE_UNITS, true), gettype($uNLIKE_UNITS)), __LINE__);
        }
        $this->UNLIKE_UNITS = $uNLIKE_UNITS;
        return $this;
    }
    /**
     * Get AUTHORIZED_PRICE value
     * @return float|null
     */
    public function getAUTHORIZED_PRICE()
    {
        return $this->AUTHORIZED_PRICE;
    }
    /**
     * Set AUTHORIZED_PRICE value
     * @param float $aUTHORIZED_PRICE
     * @return \StructType\DETAIL
     */
    public function setAUTHORIZED_PRICE($aUTHORIZED_PRICE = null)
    {
        // validation for constraint: float
        if (!is_null($aUTHORIZED_PRICE) && !(is_float($aUTHORIZED_PRICE) || is_numeric($aUTHORIZED_PRICE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aUTHORIZED_PRICE, true), gettype($aUTHORIZED_PRICE)), __LINE__);
        }
        $this->AUTHORIZED_PRICE = $aUTHORIZED_PRICE;
        return $this;
    }
    /**
     * Get BILLED_PRICE value
     * @return float|null
     */
    public function getBILLED_PRICE()
    {
        return $this->BILLED_PRICE;
    }
    /**
     * Set BILLED_PRICE value
     * @param float $bILLED_PRICE
     * @return \StructType\DETAIL
     */
    public function setBILLED_PRICE($bILLED_PRICE = null)
    {
        // validation for constraint: float
        if (!is_null($bILLED_PRICE) && !(is_float($bILLED_PRICE) || is_numeric($bILLED_PRICE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bILLED_PRICE, true), gettype($bILLED_PRICE)), __LINE__);
        }
        $this->BILLED_PRICE = $bILLED_PRICE;
        return $this;
    }
    /**
     * Get PRICE_DIFFERENCE value
     * @return float|null
     */
    public function getPRICE_DIFFERENCE()
    {
        return $this->PRICE_DIFFERENCE;
    }
    /**
     * Set PRICE_DIFFERENCE value
     * @param float $pRICE_DIFFERENCE
     * @return \StructType\DETAIL
     */
    public function setPRICE_DIFFERENCE($pRICE_DIFFERENCE = null)
    {
        // validation for constraint: float
        if (!is_null($pRICE_DIFFERENCE) && !(is_float($pRICE_DIFFERENCE) || is_numeric($pRICE_DIFFERENCE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pRICE_DIFFERENCE, true), gettype($pRICE_DIFFERENCE)), __LINE__);
        }
        $this->PRICE_DIFFERENCE = $pRICE_DIFFERENCE;
        return $this;
    }
    /**
     * Get DISCOUNT_RATE value
     * @return float|null
     */
    public function getDISCOUNT_RATE()
    {
        return $this->DISCOUNT_RATE;
    }
    /**
     * Set DISCOUNT_RATE value
     * @param float $dISCOUNT_RATE
     * @return \StructType\DETAIL
     */
    public function setDISCOUNT_RATE($dISCOUNT_RATE = null)
    {
        // validation for constraint: float
        if (!is_null($dISCOUNT_RATE) && !(is_float($dISCOUNT_RATE) || is_numeric($dISCOUNT_RATE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dISCOUNT_RATE, true), gettype($dISCOUNT_RATE)), __LINE__);
        }
        $this->DISCOUNT_RATE = $dISCOUNT_RATE;
        return $this;
    }
    /**
     * Get IVA_RATE value
     * @return float|null
     */
    public function getIVA_RATE()
    {
        return $this->IVA_RATE;
    }
    /**
     * Set IVA_RATE value
     * @param float $iVA_RATE
     * @return \StructType\DETAIL
     */
    public function setIVA_RATE($iVA_RATE = null)
    {
        // validation for constraint: float
        if (!is_null($iVA_RATE) && !(is_float($iVA_RATE) || is_numeric($iVA_RATE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iVA_RATE, true), gettype($iVA_RATE)), __LINE__);
        }
        $this->IVA_RATE = $iVA_RATE;
        return $this;
    }
    /**
     * Get IEPS25 value
     * @return float|null
     */
    public function getIEPS25()
    {
        return $this->IEPS25;
    }
    /**
     * Set IEPS25 value
     * @param float $iEPS25
     * @return \StructType\DETAIL
     */
    public function setIEPS25($iEPS25 = null)
    {
        // validation for constraint: float
        if (!is_null($iEPS25) && !(is_float($iEPS25) || is_numeric($iEPS25))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iEPS25, true), gettype($iEPS25)), __LINE__);
        }
        $this->IEPS25 = $iEPS25;
        return $this;
    }
    /**
     * Get IEPS30 value
     * @return float|null
     */
    public function getIEPS30()
    {
        return $this->IEPS30;
    }
    /**
     * Set IEPS30 value
     * @param float $iEPS30
     * @return \StructType\DETAIL
     */
    public function setIEPS30($iEPS30 = null)
    {
        // validation for constraint: float
        if (!is_null($iEPS30) && !(is_float($iEPS30) || is_numeric($iEPS30))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iEPS30, true), gettype($iEPS30)), __LINE__);
        }
        $this->IEPS30 = $iEPS30;
        return $this;
    }
    /**
     * Get IEPS53 value
     * @return float|null
     */
    public function getIEPS53()
    {
        return $this->IEPS53;
    }
    /**
     * Set IEPS53 value
     * @param float $iEPS53
     * @return \StructType\DETAIL
     */
    public function setIEPS53($iEPS53 = null)
    {
        // validation for constraint: float
        if (!is_null($iEPS53) && !(is_float($iEPS53) || is_numeric($iEPS53))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iEPS53, true), gettype($iEPS53)), __LINE__);
        }
        $this->IEPS53 = $iEPS53;
        return $this;
    }
    /**
     * Get GROSS_AMOUNT value
     * @return float|null
     */
    public function getGROSS_AMOUNT()
    {
        return $this->GROSS_AMOUNT;
    }
    /**
     * Set GROSS_AMOUNT value
     * @param float $gROSS_AMOUNT
     * @return \StructType\DETAIL
     */
    public function setGROSS_AMOUNT($gROSS_AMOUNT = null)
    {
        // validation for constraint: float
        if (!is_null($gROSS_AMOUNT) && !(is_float($gROSS_AMOUNT) || is_numeric($gROSS_AMOUNT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gROSS_AMOUNT, true), gettype($gROSS_AMOUNT)), __LINE__);
        }
        $this->GROSS_AMOUNT = $gROSS_AMOUNT;
        return $this;
    }
    /**
     * Get ENTIRE_AMOUNT value
     * @return float|null
     */
    public function getENTIRE_AMOUNT()
    {
        return $this->ENTIRE_AMOUNT;
    }
    /**
     * Set ENTIRE_AMOUNT value
     * @param float $eNTIRE_AMOUNT
     * @return \StructType\DETAIL
     */
    public function setENTIRE_AMOUNT($eNTIRE_AMOUNT = null)
    {
        // validation for constraint: float
        if (!is_null($eNTIRE_AMOUNT) && !(is_float($eNTIRE_AMOUNT) || is_numeric($eNTIRE_AMOUNT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($eNTIRE_AMOUNT, true), gettype($eNTIRE_AMOUNT)), __LINE__);
        }
        $this->ENTIRE_AMOUNT = $eNTIRE_AMOUNT;
        return $this;
    }
    /**
     * Get IVA_AMOUNT value
     * @return float|null
     */
    public function getIVA_AMOUNT()
    {
        return $this->IVA_AMOUNT;
    }
    /**
     * Set IVA_AMOUNT value
     * @param float $iVA_AMOUNT
     * @return \StructType\DETAIL
     */
    public function setIVA_AMOUNT($iVA_AMOUNT = null)
    {
        // validation for constraint: float
        if (!is_null($iVA_AMOUNT) && !(is_float($iVA_AMOUNT) || is_numeric($iVA_AMOUNT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iVA_AMOUNT, true), gettype($iVA_AMOUNT)), __LINE__);
        }
        $this->IVA_AMOUNT = $iVA_AMOUNT;
        return $this;
    }
    /**
     * Get IEPS_AMOUNT value
     * @return float|null
     */
    public function getIEPS_AMOUNT()
    {
        return $this->IEPS_AMOUNT;
    }
    /**
     * Set IEPS_AMOUNT value
     * @param float $iEPS_AMOUNT
     * @return \StructType\DETAIL
     */
    public function setIEPS_AMOUNT($iEPS_AMOUNT = null)
    {
        // validation for constraint: float
        if (!is_null($iEPS_AMOUNT) && !(is_float($iEPS_AMOUNT) || is_numeric($iEPS_AMOUNT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iEPS_AMOUNT, true), gettype($iEPS_AMOUNT)), __LINE__);
        }
        $this->IEPS_AMOUNT = $iEPS_AMOUNT;
        return $this;
    }
    /**
     * Get TOTAL value
     * @return float|null
     */
    public function getTOTAL()
    {
        return $this->TOTAL;
    }
    /**
     * Set TOTAL value
     * @param float $tOTAL
     * @return \StructType\DETAIL
     */
    public function setTOTAL($tOTAL = null)
    {
        // validation for constraint: float
        if (!is_null($tOTAL) && !(is_float($tOTAL) || is_numeric($tOTAL))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tOTAL, true), gettype($tOTAL)), __LINE__);
        }
        $this->TOTAL = $tOTAL;
        return $this;
    }
    /**
     * Get DISCOUNTS value
     * @return float|null
     */
    public function getDISCOUNTS()
    {
        return $this->DISCOUNTS;
    }
    /**
     * Set DISCOUNTS value
     * @param float $dISCOUNTS
     * @return \StructType\DETAIL
     */
    public function setDISCOUNTS($dISCOUNTS = null)
    {
        // validation for constraint: float
        if (!is_null($dISCOUNTS) && !(is_float($dISCOUNTS) || is_numeric($dISCOUNTS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dISCOUNTS, true), gettype($dISCOUNTS)), __LINE__);
        }
        $this->DISCOUNTS = $dISCOUNTS;
        return $this;
    }
    /**
     * Get DIFFERENCE_KEY value
     * @return int|null
     */
    public function getDIFFERENCE_KEY()
    {
        return $this->DIFFERENCE_KEY;
    }
    /**
     * Set DIFFERENCE_KEY value
     * @param int $dIFFERENCE_KEY
     * @return \StructType\DETAIL
     */
    public function setDIFFERENCE_KEY($dIFFERENCE_KEY = null)
    {
        // validation for constraint: int
        if (!is_null($dIFFERENCE_KEY) && !(is_int($dIFFERENCE_KEY) || ctype_digit($dIFFERENCE_KEY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dIFFERENCE_KEY, true), gettype($dIFFERENCE_KEY)), __LINE__);
        }
        $this->DIFFERENCE_KEY = $dIFFERENCE_KEY;
        return $this;
    }
    /**
     * Get DIFFERENCE_KEY_DESC value
     * @return string|null
     */
    public function getDIFFERENCE_KEY_DESC()
    {
        return $this->DIFFERENCE_KEY_DESC;
    }
    /**
     * Set DIFFERENCE_KEY_DESC value
     * @param string $dIFFERENCE_KEY_DESC
     * @return \StructType\DETAIL
     */
    public function setDIFFERENCE_KEY_DESC($dIFFERENCE_KEY_DESC = null)
    {
        // validation for constraint: string
        if (!is_null($dIFFERENCE_KEY_DESC) && !is_string($dIFFERENCE_KEY_DESC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dIFFERENCE_KEY_DESC, true), gettype($dIFFERENCE_KEY_DESC)), __LINE__);
        }
        $this->DIFFERENCE_KEY_DESC = $dIFFERENCE_KEY_DESC;
        return $this;
    }
    /**
     * Get AMOUNT value
     * @return float|null
     */
    public function getAMOUNT()
    {
        return $this->AMOUNT;
    }
    /**
     * Set AMOUNT value
     * @param float $aMOUNT
     * @return \StructType\DETAIL
     */
    public function setAMOUNT($aMOUNT = null)
    {
        // validation for constraint: float
        if (!is_null($aMOUNT) && !(is_float($aMOUNT) || is_numeric($aMOUNT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aMOUNT, true), gettype($aMOUNT)), __LINE__);
        }
        $this->AMOUNT = $aMOUNT;
        return $this;
    }
}
