<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for currency StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional que especifica el tipo de divisa utilizada, para efectos de comprobantes fiscales digitales emitidos UNICAMENTE se podrá utilizar como divisa la moneda nacional (MXN), sin embargo dentro del complemento se podrá
 * detallar en otra de forma informativa. Lo detallado en esta etiqueta deberá coincidir con lo declarado en las etiquetas del SAT considerando el tipo de cambio.
 * @subpackage Structs
 */
class Currency extends AbstractStructBase
{
    /**
     * The currencyISOCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $currencyISOCode;
    /**
     * The currencyFunction
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * @var string[]
     */
    public $currencyFunction;
    /**
     * The rateOfChange
     * Meta information extracted from the WSDL
     * - documentation: Nodo opcional que especifical la tasa de cambio que se aplica a las monedas. La regla general para calcular la tasa de cambio es la siguiente:Divisa de Referencia multiplicada por la Tasa = Divisa Objetivo
     * - minOccurs: 0
     * @var float
     */
    public $rateOfChange;
    /**
     * Constructor method for currency
     * @uses Currency::setCurrencyISOCode()
     * @uses Currency::setCurrencyFunction()
     * @uses Currency::setRateOfChange()
     * @param string $currencyISOCode
     * @param string[] $currencyFunction
     * @param float $rateOfChange
     */
    public function __construct($currencyISOCode = null, array $currencyFunction = array(), $rateOfChange = null)
    {
        $this
            ->setCurrencyISOCode($currencyISOCode)
            ->setCurrencyFunction($currencyFunction)
            ->setRateOfChange($rateOfChange);
    }
    /**
     * Get currencyISOCode value
     * @return string
     */
    public function getCurrencyISOCode()
    {
        return $this->currencyISOCode;
    }
    /**
     * Set currencyISOCode value
     * @param string $currencyISOCode
     * @return \StructType\Currency
     */
    public function setCurrencyISOCode($currencyISOCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyISOCode) && !is_string($currencyISOCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyISOCode, true), gettype($currencyISOCode)), __LINE__);
        }
        $this->currencyISOCode = $currencyISOCode;
        return $this;
    }
    /**
     * Get currencyFunction value
     * @return string[]|null
     */
    public function getCurrencyFunction()
    {
        return $this->currencyFunction;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrencyFunction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrencyFunction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrencyFunctionForArrayConstraintsFromSetCurrencyFunction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $currencyCurrencyFunctionItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CurrencyFunction::valueIsValid($currencyCurrencyFunctionItem)) {
                $invalidValues[] = is_object($currencyCurrencyFunctionItem) ? get_class($currencyCurrencyFunctionItem) : sprintf('%s(%s)', gettype($currencyCurrencyFunctionItem), var_export($currencyCurrencyFunctionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CurrencyFunction', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CurrencyFunction::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set currencyFunction value
     * @uses \EnumType\CurrencyFunction::valueIsValid()
     * @uses \EnumType\CurrencyFunction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $currencyFunction
     * @return \StructType\Currency
     */
    public function setCurrencyFunction(array $currencyFunction = array())
    {
        // validation for constraint: array
        if ('' !== ($currencyFunctionArrayErrorMessage = self::validateCurrencyFunctionForArrayConstraintsFromSetCurrencyFunction($currencyFunction))) {
            throw new \InvalidArgumentException($currencyFunctionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($currencyFunction) && count($currencyFunction) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($currencyFunction)), __LINE__);
        }
        $this->currencyFunction = $currencyFunction;
        return $this;
    }
    /**
     * Add item to currencyFunction value
     * @uses \EnumType\CurrencyFunction::valueIsValid()
     * @uses \EnumType\CurrencyFunction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Currency
     */
    public function addToCurrencyFunction($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CurrencyFunction::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CurrencyFunction', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\CurrencyFunction::getValidValues())), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->currencyFunction) && count($this->currencyFunction) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->currencyFunction)), __LINE__);
        }
        $this->currencyFunction[] = $item;
        return $this;
    }
    /**
     * Get rateOfChange value
     * @return float|null
     */
    public function getRateOfChange()
    {
        return $this->rateOfChange;
    }
    /**
     * Set rateOfChange value
     * @param float $rateOfChange
     * @return \StructType\Currency
     */
    public function setRateOfChange($rateOfChange = null)
    {
        // validation for constraint: float
        if (!is_null($rateOfChange) && !(is_float($rateOfChange) || is_numeric($rateOfChange))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rateOfChange, true), gettype($rateOfChange)), __LINE__);
        }
        $this->rateOfChange = $rateOfChange;
        return $this;
    }
}
