<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CuentaPredial StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional para asentar el número de cuenta predial con el que fue registrado el inmueble, en el sistema catastral de la entidad federativa de que trate. | Nodo opcional para asentar el número de cuenta predial con el que fue
 * registrado el inmueble, en el sistema catastral de la entidad federativa de que trate, o bien para incorporar los datos de identificación del certificado de participación inmobiliaria no amortizable.
 * @subpackage Structs
 */
class CuentaPredial extends AbstractStructBase
{
    /**
     * The Numero
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 150
     * - minLength: 1
     * - pattern: [0-9]{1,150}
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $Numero;
    /**
     * The numero
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $numero;
    /**
     * Constructor method for CuentaPredial
     * @uses CuentaPredial::setNumero()
     * @uses CuentaPredial::setNumero_1()
     * @param string $numero
     * @param string $numero
     */
    public function __construct($numero = null, $numero_1 = null)
    {
        $this
            ->setNumero($numero)
            ->setNumero_1($numero_1);
    }
    /**
     * Get Numero value
     * @return string
     */
    public function getNumero()
    {
        return $this->Numero;
    }
    /**
     * Set Numero value
     * @param string $numero
     * @return \StructType\CuentaPredial
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($numero) && mb_strlen($numero) > 150) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen($numero)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($numero) && mb_strlen($numero) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($numero)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,150})
        if (!is_null($numero) && !preg_match('/[0-9]{1,150}/', $numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,150}', var_export($numero, true)), __LINE__);
        }
        $this->Numero = $numero;
        return $this;
    }
    /**
     * Get Numero value
     * @return string
     */
    public function getNumero_1()
    {
        return $this->numero;
    }
    /**
     * Set Numero value
     * @param string $numero
     * @return \StructType\CuentaPredial
     */
    public function setNumero_1($numero_1 = null)
    {
        // validation for constraint: string
        if (!is_null($numero_1) && !is_string($numero_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero_1, true), gettype($numero_1)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($numero_1) && mb_strlen($numero_1) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($numero_1)), __LINE__);
        }
        $this->numero = $numero_1;
        return $this;
    }
}
