<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Conceptos StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo requerido para listar los conceptos cubiertos por el comprobante.
 * @subpackage Structs
 */
class Conceptos extends AbstractStructBase
{
    /**
     * The Concepto
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Concepto[]
     */
    public $Concepto;
    /**
     * Constructor method for Conceptos
     * @uses Conceptos::setConcepto()
     * @param \StructType\Concepto[] $concepto
     */
    public function __construct(array $concepto = array())
    {
        $this
            ->setConcepto($concepto);
    }
    /**
     * Get Concepto value
     * @return \StructType\Concepto[]|null
     */
    public function getConcepto()
    {
        return $this->Concepto;
    }
    /**
     * This method is responsible for validating the values passed to the setConcepto method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConcepto method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConceptoForArrayConstraintsFromSetConcepto(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $conceptosConceptoItem) {
            // validation for constraint: itemType
            if (!$conceptosConceptoItem instanceof \StructType\Concepto) {
                $invalidValues[] = is_object($conceptosConceptoItem) ? get_class($conceptosConceptoItem) : sprintf('%s(%s)', gettype($conceptosConceptoItem), var_export($conceptosConceptoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Concepto property can only contain items of type \StructType\Concepto, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Concepto value
     * @throws \InvalidArgumentException
     * @param \StructType\Concepto[] $concepto
     * @return \StructType\Conceptos
     */
    public function setConcepto(array $concepto = array())
    {
        // validation for constraint: array
        if ('' !== ($conceptoArrayErrorMessage = self::validateConceptoForArrayConstraintsFromSetConcepto($concepto))) {
            throw new \InvalidArgumentException($conceptoArrayErrorMessage, __LINE__);
        }
        $this->Concepto = $concepto;
        return $this;
    }
    /**
     * Add item to Concepto value
     * @throws \InvalidArgumentException
     * @param \StructType\Concepto $item
     * @return \StructType\Conceptos
     */
    public function addToConcepto(\StructType\Concepto $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Concepto) {
            throw new \InvalidArgumentException(sprintf('The Concepto property can only contain items of type \StructType\Concepto, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Concepto[] = $item;
        return $this;
    }
}
