<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Concepto StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo requerido para registrar la información detallada de un bien o servicio amparado en el comprobante.
 * @subpackage Structs
 */
class Concepto extends AbstractStructBase
{
    /**
     * The Cantidad
     * Meta information extracted from the WSDL
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.000001
     * - use: required
     * - whiteSpace: collapse
     * @var float
     */
    public $Cantidad;
    /**
     * The ClaveProdServ
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para expresar la clave del producto o del servicio amparado por el presente concepto. Es requerido y deben utilizar las claves del catálogo de productos y servicios, cuando los conceptos que registren por sus
     * actividades correspondan con dichos conceptos.
     * - base: xs:string
     * - pattern: [0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $ClaveProdServ;
    /**
     * The ClaveUnidad
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para precisar la clave de unidad de medida estandarizada aplicable para la cantidad expresada en el concepto. La unidad debe corresponder con la descripción del concepto.
     * - base: xs:string
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $ClaveUnidad;
    /**
     * The Descripcion
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1000
     * - minLength: 1
     * - pattern: [^|]{1,1000}
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $Descripcion;
    /**
     * The Importe
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para precisar el importe total de los bienes o servicios del presente concepto. Debe ser equivalente al resultado de multiplicar la cantidad por el valor unitario expresado en el concepto. No se permiten valores
     * negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales. El valor se redondea de acuerdo con el número de decimales que soporta la moneda. No se permiten valores negativos. | Tipo definido para expresar
     * importes numéricos con fracción hasta seis decimales
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.0
     * - pattern: [0-9]{1,18}(.[0-9]{1,6})?
     * - use: required
     * - whiteSpace: collapse
     * @var float
     */
    public $Importe;
    /**
     * The ValorUnitario
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para precisar el valor o precio unitario del bien o servicio cubierto por el presente concepto. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales. El valor se redondea de acuerdo
     * con el número de decimales que soporta la moneda. No se permiten valores negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.0
     * - pattern: [0-9]{1,18}(.[0-9]{1,6})?
     * - use: required
     * - whiteSpace: collapse
     * @var float
     */
    public $ValorUnitario;
    /**
     * The Impuestos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Impuestos
     */
    public $Impuestos;
    /**
     * The InformacionAduanera
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InformacionAduanera[]
     */
    public $InformacionAduanera;
    /**
     * The CuentaPredial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CuentaPredial
     */
    public $CuentaPredial;
    /**
     * The ComplementoConcepto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ComplementoConcepto
     */
    public $ComplementoConcepto;
    /**
     * The Parte
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Parte[]
     */
    public $Parte;
    /**
     * The Descuento
     * Meta information extracted from the WSDL
     * - documentation: Atributo opcional para representar el importe de los descuentos aplicables al concepto. No se permiten valores negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales. El valor se redondea de
     * acuerdo con el número de decimales que soporta la moneda. No se permiten valores negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.0
     * - pattern: [0-9]{1,18}(.[0-9]{1,6})?
     * - whiteSpace: collapse
     * @var float
     */
    public $Descuento;
    /**
     * The NoIdentificacion
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 100
     * - minLength: 1
     * - pattern: [^|]{1,100}
     * - whiteSpace: collapse
     * @var string
     */
    public $NoIdentificacion;
    /**
     * The Unidad
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 20
     * - minLength: 1
     * - pattern: [^|]{1,20}
     * - whiteSpace: collapse
     * @var string
     */
    public $Unidad;
    /**
     * Constructor method for Concepto
     * @uses Concepto::setCantidad()
     * @uses Concepto::setClaveProdServ()
     * @uses Concepto::setClaveUnidad()
     * @uses Concepto::setDescripcion()
     * @uses Concepto::setImporte()
     * @uses Concepto::setValorUnitario()
     * @uses Concepto::setImpuestos()
     * @uses Concepto::setInformacionAduanera()
     * @uses Concepto::setCuentaPredial()
     * @uses Concepto::setComplementoConcepto()
     * @uses Concepto::setParte()
     * @uses Concepto::setDescuento()
     * @uses Concepto::setNoIdentificacion()
     * @uses Concepto::setUnidad()
     * @param float $cantidad
     * @param string $claveProdServ
     * @param string $claveUnidad
     * @param string $descripcion
     * @param float $importe
     * @param float $valorUnitario
     * @param \StructType\Impuestos $impuestos
     * @param \StructType\InformacionAduanera[] $informacionAduanera
     * @param \StructType\CuentaPredial $cuentaPredial
     * @param \StructType\ComplementoConcepto $complementoConcepto
     * @param \StructType\Parte[] $parte
     * @param float $descuento
     * @param string $noIdentificacion
     * @param string $unidad
     */
    public function __construct($cantidad = null, $claveProdServ = null, $claveUnidad = null, $descripcion = null, $importe = null, $valorUnitario = null, \StructType\Impuestos $impuestos = null, array $informacionAduanera = array(), \StructType\CuentaPredial $cuentaPredial = null, \StructType\ComplementoConcepto $complementoConcepto = null, array $parte = array(), $descuento = null, $noIdentificacion = null, $unidad = null)
    {
        $this
            ->setCantidad($cantidad)
            ->setClaveProdServ($claveProdServ)
            ->setClaveUnidad($claveUnidad)
            ->setDescripcion($descripcion)
            ->setImporte($importe)
            ->setValorUnitario($valorUnitario)
            ->setImpuestos($impuestos)
            ->setInformacionAduanera($informacionAduanera)
            ->setCuentaPredial($cuentaPredial)
            ->setComplementoConcepto($complementoConcepto)
            ->setParte($parte)
            ->setDescuento($descuento)
            ->setNoIdentificacion($noIdentificacion)
            ->setUnidad($unidad);
    }
    /**
     * Get Cantidad value
     * @return float
     */
    public function getCantidad()
    {
        return $this->Cantidad;
    }
    /**
     * Set Cantidad value
     * @param float $cantidad
     * @return \StructType\Concepto
     */
    public function setCantidad($cantidad = null)
    {
        // validation for constraint: float
        if (!is_null($cantidad) && !(is_float($cantidad) || is_numeric($cantidad))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cantidad, true), gettype($cantidad)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($cantidad) && mb_strlen(mb_substr($cantidad, false !== mb_strpos($cantidad, '.') ? mb_strpos($cantidad, '.') + 1 : mb_strlen($cantidad))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($cantidad, true), mb_strlen(mb_substr($cantidad, mb_strpos($cantidad, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.000001)
        if (!is_null($cantidad) && $cantidad < 0.000001) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.000001', var_export($cantidad, true)), __LINE__);
        }
        $this->Cantidad = $cantidad;
        return $this;
    }
    /**
     * Get ClaveProdServ value
     * @return string
     */
    public function getClaveProdServ()
    {
        return $this->ClaveProdServ;
    }
    /**
     * Set ClaveProdServ value
     * @param string $claveProdServ
     * @return \StructType\Concepto
     */
    public function setClaveProdServ($claveProdServ = null)
    {
        // validation for constraint: string
        if (!is_null($claveProdServ) && !is_string($claveProdServ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claveProdServ, true), gettype($claveProdServ)), __LINE__);
        }
        // validation for constraint: pattern([0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9])
        if (!is_null($claveProdServ) && !preg_match('/[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]/', $claveProdServ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]', var_export($claveProdServ, true)), __LINE__);
        }
        $this->ClaveProdServ = $claveProdServ;
        return $this;
    }
    /**
     * Get ClaveUnidad value
     * @return string
     */
    public function getClaveUnidad()
    {
        return $this->ClaveUnidad;
    }
    /**
     * Set ClaveUnidad value
     * @param string $claveUnidad
     * @return \StructType\Concepto
     */
    public function setClaveUnidad($claveUnidad = null)
    {
        // validation for constraint: string
        if (!is_null($claveUnidad) && !is_string($claveUnidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claveUnidad, true), gettype($claveUnidad)), __LINE__);
        }
        $this->ClaveUnidad = $claveUnidad;
        return $this;
    }
    /**
     * Get Descripcion value
     * @return string
     */
    public function getDescripcion()
    {
        return $this->Descripcion;
    }
    /**
     * Set Descripcion value
     * @param string $descripcion
     * @return \StructType\Concepto
     */
    public function setDescripcion($descripcion = null)
    {
        // validation for constraint: string
        if (!is_null($descripcion) && !is_string($descripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descripcion, true), gettype($descripcion)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($descripcion) && mb_strlen($descripcion) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($descripcion)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($descripcion) && mb_strlen($descripcion) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($descripcion)), __LINE__);
        }
        // validation for constraint: pattern([^|]{1,1000})
        if (!is_null($descripcion) && !preg_match('/[^|]{1,1000}/', $descripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^|]{1,1000}', var_export($descripcion, true)), __LINE__);
        }
        $this->Descripcion = $descripcion;
        return $this;
    }
    /**
     * Get Importe value
     * @return float
     */
    public function getImporte()
    {
        return $this->Importe;
    }
    /**
     * Set Importe value
     * @param float $importe
     * @return \StructType\Concepto
     */
    public function setImporte($importe = null)
    {
        // validation for constraint: float
        if (!is_null($importe) && !(is_float($importe) || is_numeric($importe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importe, true), gettype($importe)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($importe) && mb_strlen(mb_substr($importe, false !== mb_strpos($importe, '.') ? mb_strpos($importe, '.') + 1 : mb_strlen($importe))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($importe, true), mb_strlen(mb_substr($importe, mb_strpos($importe, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($importe) && $importe < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($importe, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,18}(.[0-9]{1,6})?)
        if (!is_null($importe) && !preg_match('/[0-9]{1,18}(.[0-9]{1,6})?/', $importe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,18}(.[0-9]{1,6})?', var_export($importe, true)), __LINE__);
        }
        $this->Importe = $importe;
        return $this;
    }
    /**
     * Get ValorUnitario value
     * @return float
     */
    public function getValorUnitario()
    {
        return $this->ValorUnitario;
    }
    /**
     * Set ValorUnitario value
     * @param float $valorUnitario
     * @return \StructType\Concepto
     */
    public function setValorUnitario($valorUnitario = null)
    {
        // validation for constraint: float
        if (!is_null($valorUnitario) && !(is_float($valorUnitario) || is_numeric($valorUnitario))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorUnitario, true), gettype($valorUnitario)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($valorUnitario) && mb_strlen(mb_substr($valorUnitario, false !== mb_strpos($valorUnitario, '.') ? mb_strpos($valorUnitario, '.') + 1 : mb_strlen($valorUnitario))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($valorUnitario, true), mb_strlen(mb_substr($valorUnitario, mb_strpos($valorUnitario, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($valorUnitario) && $valorUnitario < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($valorUnitario, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,18}(.[0-9]{1,6})?)
        if (!is_null($valorUnitario) && !preg_match('/[0-9]{1,18}(.[0-9]{1,6})?/', $valorUnitario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,18}(.[0-9]{1,6})?', var_export($valorUnitario, true)), __LINE__);
        }
        $this->ValorUnitario = $valorUnitario;
        return $this;
    }
    /**
     * Get Impuestos value
     * @return \StructType\Impuestos|null
     */
    public function getImpuestos()
    {
        return $this->Impuestos;
    }
    /**
     * Set Impuestos value
     * @param \StructType\Impuestos $impuestos
     * @return \StructType\Concepto
     */
    public function setImpuestos(\StructType\Impuestos $impuestos = null)
    {
        $this->Impuestos = $impuestos;
        return $this;
    }
    /**
     * Get InformacionAduanera value
     * @return \StructType\InformacionAduanera[]|null
     */
    public function getInformacionAduanera()
    {
        return $this->InformacionAduanera;
    }
    /**
     * This method is responsible for validating the values passed to the setInformacionAduanera method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInformacionAduanera method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInformacionAduaneraForArrayConstraintsFromSetInformacionAduanera(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $conceptoInformacionAduaneraItem) {
            // validation for constraint: itemType
            if (!$conceptoInformacionAduaneraItem instanceof \StructType\InformacionAduanera) {
                $invalidValues[] = is_object($conceptoInformacionAduaneraItem) ? get_class($conceptoInformacionAduaneraItem) : sprintf('%s(%s)', gettype($conceptoInformacionAduaneraItem), var_export($conceptoInformacionAduaneraItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InformacionAduanera property can only contain items of type \StructType\InformacionAduanera, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InformacionAduanera value
     * @throws \InvalidArgumentException
     * @param \StructType\InformacionAduanera[] $informacionAduanera
     * @return \StructType\Concepto
     */
    public function setInformacionAduanera(array $informacionAduanera = array())
    {
        // validation for constraint: array
        if ('' !== ($informacionAduaneraArrayErrorMessage = self::validateInformacionAduaneraForArrayConstraintsFromSetInformacionAduanera($informacionAduanera))) {
            throw new \InvalidArgumentException($informacionAduaneraArrayErrorMessage, __LINE__);
        }
        $this->InformacionAduanera = $informacionAduanera;
        return $this;
    }
    /**
     * Add item to InformacionAduanera value
     * @throws \InvalidArgumentException
     * @param \StructType\InformacionAduanera $item
     * @return \StructType\Concepto
     */
    public function addToInformacionAduanera(\StructType\InformacionAduanera $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InformacionAduanera) {
            throw new \InvalidArgumentException(sprintf('The InformacionAduanera property can only contain items of type \StructType\InformacionAduanera, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InformacionAduanera[] = $item;
        return $this;
    }
    /**
     * Get CuentaPredial value
     * @return \StructType\CuentaPredial|null
     */
    public function getCuentaPredial()
    {
        return $this->CuentaPredial;
    }
    /**
     * Set CuentaPredial value
     * @param \StructType\CuentaPredial $cuentaPredial
     * @return \StructType\Concepto
     */
    public function setCuentaPredial(\StructType\CuentaPredial $cuentaPredial = null)
    {
        $this->CuentaPredial = $cuentaPredial;
        return $this;
    }
    /**
     * Get ComplementoConcepto value
     * @return \StructType\ComplementoConcepto|null
     */
    public function getComplementoConcepto()
    {
        return $this->ComplementoConcepto;
    }
    /**
     * Set ComplementoConcepto value
     * @param \StructType\ComplementoConcepto $complementoConcepto
     * @return \StructType\Concepto
     */
    public function setComplementoConcepto(\StructType\ComplementoConcepto $complementoConcepto = null)
    {
        $this->ComplementoConcepto = $complementoConcepto;
        return $this;
    }
    /**
     * Get Parte value
     * @return \StructType\Parte[]|null
     */
    public function getParte()
    {
        return $this->Parte;
    }
    /**
     * This method is responsible for validating the values passed to the setParte method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParte method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParteForArrayConstraintsFromSetParte(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $conceptoParteItem) {
            // validation for constraint: itemType
            if (!$conceptoParteItem instanceof \StructType\Parte) {
                $invalidValues[] = is_object($conceptoParteItem) ? get_class($conceptoParteItem) : sprintf('%s(%s)', gettype($conceptoParteItem), var_export($conceptoParteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Parte property can only contain items of type \StructType\Parte, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Parte value
     * @throws \InvalidArgumentException
     * @param \StructType\Parte[] $parte
     * @return \StructType\Concepto
     */
    public function setParte(array $parte = array())
    {
        // validation for constraint: array
        if ('' !== ($parteArrayErrorMessage = self::validateParteForArrayConstraintsFromSetParte($parte))) {
            throw new \InvalidArgumentException($parteArrayErrorMessage, __LINE__);
        }
        $this->Parte = $parte;
        return $this;
    }
    /**
     * Add item to Parte value
     * @throws \InvalidArgumentException
     * @param \StructType\Parte $item
     * @return \StructType\Concepto
     */
    public function addToParte(\StructType\Parte $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Parte) {
            throw new \InvalidArgumentException(sprintf('The Parte property can only contain items of type \StructType\Parte, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Parte[] = $item;
        return $this;
    }
    /**
     * Get Descuento value
     * @return float|null
     */
    public function getDescuento()
    {
        return $this->Descuento;
    }
    /**
     * Set Descuento value
     * @param float $descuento
     * @return \StructType\Concepto
     */
    public function setDescuento($descuento = null)
    {
        // validation for constraint: float
        if (!is_null($descuento) && !(is_float($descuento) || is_numeric($descuento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($descuento, true), gettype($descuento)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($descuento) && mb_strlen(mb_substr($descuento, false !== mb_strpos($descuento, '.') ? mb_strpos($descuento, '.') + 1 : mb_strlen($descuento))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($descuento, true), mb_strlen(mb_substr($descuento, mb_strpos($descuento, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($descuento) && $descuento < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($descuento, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,18}(.[0-9]{1,6})?)
        if (!is_null($descuento) && !preg_match('/[0-9]{1,18}(.[0-9]{1,6})?/', $descuento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,18}(.[0-9]{1,6})?', var_export($descuento, true)), __LINE__);
        }
        $this->Descuento = $descuento;
        return $this;
    }
    /**
     * Get NoIdentificacion value
     * @return string|null
     */
    public function getNoIdentificacion()
    {
        return $this->NoIdentificacion;
    }
    /**
     * Set NoIdentificacion value
     * @param string $noIdentificacion
     * @return \StructType\Concepto
     */
    public function setNoIdentificacion($noIdentificacion = null)
    {
        // validation for constraint: string
        if (!is_null($noIdentificacion) && !is_string($noIdentificacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noIdentificacion, true), gettype($noIdentificacion)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($noIdentificacion) && mb_strlen($noIdentificacion) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($noIdentificacion)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($noIdentificacion) && mb_strlen($noIdentificacion) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($noIdentificacion)), __LINE__);
        }
        // validation for constraint: pattern([^|]{1,100})
        if (!is_null($noIdentificacion) && !preg_match('/[^|]{1,100}/', $noIdentificacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^|]{1,100}', var_export($noIdentificacion, true)), __LINE__);
        }
        $this->NoIdentificacion = $noIdentificacion;
        return $this;
    }
    /**
     * Get Unidad value
     * @return string|null
     */
    public function getUnidad()
    {
        return $this->Unidad;
    }
    /**
     * Set Unidad value
     * @param string $unidad
     * @return \StructType\Concepto
     */
    public function setUnidad($unidad = null)
    {
        // validation for constraint: string
        if (!is_null($unidad) && !is_string($unidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unidad, true), gettype($unidad)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($unidad) && mb_strlen($unidad) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($unidad)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($unidad) && mb_strlen($unidad) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($unidad)), __LINE__);
        }
        // validation for constraint: pattern([^|]{1,20})
        if (!is_null($unidad) && !preg_match('/[^|]{1,20}/', $unidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^|]{1,20}', var_export($unidad, true)), __LINE__);
        }
        $this->Unidad = $unidad;
        return $this;
    }
}
