<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Comprobante StructType
 * Meta information extracted from the WSDL
 * - documentation: Estándar de Comprobante Fiscal Digital por Internet.
 * @subpackage Structs
 */
class Comprobante extends AbstractStructBase
{
    /**
     * The Certificado
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $Certificado;
    /**
     * The Fecha
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para la expresión de la fecha y hora de expedición del Comprobante Fiscal Digital por Internet. Se expresa en la forma AAAA-MM-DDThh:mm:ss y debe corresponder con la hora local donde se expide el comprobante. |
     * Tipo definido para la expresión de la fecha y hora. Se expresa en la forma AAAA-MM-DDThh:mm:ss
     * - base: xs:dateTime
     * - pattern: (20[1-9][0-9])-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T(([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $Fecha;
    /**
     * The LugarExpedicion
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para incorporar el código postal del lugar de expedición del comprobante (domicilio de la matriz o de la sucursal).
     * - base: xs:string
     * - pattern: [0-9][0-9][0-9][0-9][0-9]
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $LugarExpedicion;
    /**
     * The Moneda
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para identificar la clave de la moneda utilizada para expresar los montos, cuando se usa moneda nacional se registra MXN. Conforme con la especificación ISO 4217.
     * - base: xs:string
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $Moneda;
    /**
     * The NoCertificado
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 20
     * - pattern: [0-9]{20}
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $NoCertificado;
    /**
     * The Sello
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $Sello;
    /**
     * The SubTotal
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para representar la suma de los importes de los conceptos antes de descuentos e impuesto. No se permiten valores negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales. El
     * valor se redondea de acuerdo con el número de decimales que soporta la moneda. No se permiten valores negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.0
     * - pattern: [0-9]{1,18}(.[0-9]{1,6})?
     * - use: required
     * - whiteSpace: collapse
     * @var float
     */
    public $SubTotal;
    /**
     * The TipoDeComprobante
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para expresar la clave del efecto del comprobante fiscal para el contribuyente emisor.
     * - use: required
     * @var string
     */
    public $TipoDeComprobante;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para representar la suma del subtotal, menos los descuentos aplicables, más las contribuciones recibidas (impuestos trasladados - federales o locales, derechos, productos, aprovechamientos, aportaciones de
     * seguridad social, contribuciones de mejoras) menos los impuestos retenidos. Si el valor es superior al límite que establezca el SAT en la Resolución Miscelánea Fiscal vigente, el emisor debe obtener del PAC que vaya a timbrar el CFDI, de manera no
     * automática, una clave de confirmación para ratificar que el valor es correcto e integrar dicha clave en el atributo Confirmacion. No se permiten valores negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis
     * decimales. El valor se redondea de acuerdo con el número de decimales que soporta la moneda. No se permiten valores negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.0
     * - pattern: [0-9]{1,18}(.[0-9]{1,6})?
     * - use: required
     * - whiteSpace: collapse
     * @var float
     */
    public $Total;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - fixed: 3.3
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $Version;
    /**
     * The CfdiRelacionados
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CfdiRelacionados
     */
    public $CfdiRelacionados;
    /**
     * The Emisor
     * @var \StructType\Emisor
     */
    public $Emisor;
    /**
     * The Receptor
     * @var \StructType\Receptor
     */
    public $Receptor;
    /**
     * The Conceptos
     * @var \StructType\Conceptos
     */
    public $Conceptos;
    /**
     * The Impuestos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Impuestos
     */
    public $Impuestos;
    /**
     * The Complemento
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Complemento[]
     */
    public $Complemento;
    /**
     * The Addenda
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Addenda
     */
    public $Addenda;
    /**
     * The CondicionesDePago
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1000
     * - minLength: 1
     * - pattern: [^|]{1,1000}
     * - whiteSpace: collapse
     * @var string
     */
    public $CondicionesDePago;
    /**
     * The Confirmacion
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 5
     * - pattern: [0-9a-zA-Z]{5}
     * - whiteSpace: collapse
     * @var string
     */
    public $Confirmacion;
    /**
     * The Descuento
     * Meta information extracted from the WSDL
     * - documentation: Atributo condicional para representar el importe total de los descuentos aplicables antes de impuestos. No se permiten valores negativos. Se debe registrar cuando existan conceptos con descuento. | Tipo definido para expresar
     * importes numéricos con fracción hasta seis decimales. El valor se redondea de acuerdo con el número de decimales que soporta la moneda. No se permiten valores negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis
     * decimales
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.0
     * - pattern: [0-9]{1,18}(.[0-9]{1,6})?
     * - whiteSpace: collapse
     * @var float
     */
    public $Descuento;
    /**
     * The Folio
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 40
     * - minLength: 1
     * - pattern: [^|]{1,40}
     * - whiteSpace: collapse
     * @var string
     */
    public $Folio;
    /**
     * The FormaPago
     * Meta information extracted from the WSDL
     * - documentation: Atributo condicional para expresar la clave de la forma de pago de los bienes o servicios amparados por el comprobante. Si no se conoce la forma de pago este atributo se debe omitir.
     * @var string
     */
    public $FormaPago;
    /**
     * The MetodoPago
     * Meta information extracted from the WSDL
     * - documentation: Atributo condicional para precisar la clave del método de pago que aplica para este comprobante fiscal digital por Internet, conforme al Artículo 29-A fracción VII incisos a y b del CFF.
     * @var string
     */
    public $MetodoPago;
    /**
     * The Serie
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [^|]{1,25}
     * - whiteSpace: collapse
     * @var string
     */
    public $Serie;
    /**
     * The TipoCambio
     * Meta information extracted from the WSDL
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.000001
     * - whiteSpace: collapse
     * @var float
     */
    public $TipoCambio;
    /**
     * Constructor method for Comprobante
     * @uses Comprobante::setCertificado()
     * @uses Comprobante::setFecha()
     * @uses Comprobante::setLugarExpedicion()
     * @uses Comprobante::setMoneda()
     * @uses Comprobante::setNoCertificado()
     * @uses Comprobante::setSello()
     * @uses Comprobante::setSubTotal()
     * @uses Comprobante::setTipoDeComprobante()
     * @uses Comprobante::setTotal()
     * @uses Comprobante::setVersion()
     * @uses Comprobante::setCfdiRelacionados()
     * @uses Comprobante::setEmisor()
     * @uses Comprobante::setReceptor()
     * @uses Comprobante::setConceptos()
     * @uses Comprobante::setImpuestos()
     * @uses Comprobante::setComplemento()
     * @uses Comprobante::setAddenda()
     * @uses Comprobante::setCondicionesDePago()
     * @uses Comprobante::setConfirmacion()
     * @uses Comprobante::setDescuento()
     * @uses Comprobante::setFolio()
     * @uses Comprobante::setFormaPago()
     * @uses Comprobante::setMetodoPago()
     * @uses Comprobante::setSerie()
     * @uses Comprobante::setTipoCambio()
     * @param string $certificado
     * @param string $fecha
     * @param string $lugarExpedicion
     * @param string $moneda
     * @param string $noCertificado
     * @param string $sello
     * @param float $subTotal
     * @param string $tipoDeComprobante
     * @param float $total
     * @param string $version
     * @param \StructType\CfdiRelacionados $cfdiRelacionados
     * @param \StructType\Emisor $emisor
     * @param \StructType\Receptor $receptor
     * @param \StructType\Conceptos $conceptos
     * @param \StructType\Impuestos $impuestos
     * @param \StructType\Complemento[] $complemento
     * @param \StructType\Addenda $addenda
     * @param string $condicionesDePago
     * @param string $confirmacion
     * @param float $descuento
     * @param string $folio
     * @param string $formaPago
     * @param string $metodoPago
     * @param string $serie
     * @param float $tipoCambio
     */
    public function __construct($certificado = null, $fecha = null, $lugarExpedicion = null, $moneda = null, $noCertificado = null, $sello = null, $subTotal = null, $tipoDeComprobante = null, $total = null, $version = null, \StructType\CfdiRelacionados $cfdiRelacionados = null, \StructType\Emisor $emisor = null, \StructType\Receptor $receptor = null, \StructType\Conceptos $conceptos = null, \StructType\Impuestos $impuestos = null, array $complemento = array(), \StructType\Addenda $addenda = null, $condicionesDePago = null, $confirmacion = null, $descuento = null, $folio = null, $formaPago = null, $metodoPago = null, $serie = null, $tipoCambio = null)
    {
        $this
            ->setCertificado($certificado)
            ->setFecha($fecha)
            ->setLugarExpedicion($lugarExpedicion)
            ->setMoneda($moneda)
            ->setNoCertificado($noCertificado)
            ->setSello($sello)
            ->setSubTotal($subTotal)
            ->setTipoDeComprobante($tipoDeComprobante)
            ->setTotal($total)
            ->setVersion($version)
            ->setCfdiRelacionados($cfdiRelacionados)
            ->setEmisor($emisor)
            ->setReceptor($receptor)
            ->setConceptos($conceptos)
            ->setImpuestos($impuestos)
            ->setComplemento($complemento)
            ->setAddenda($addenda)
            ->setCondicionesDePago($condicionesDePago)
            ->setConfirmacion($confirmacion)
            ->setDescuento($descuento)
            ->setFolio($folio)
            ->setFormaPago($formaPago)
            ->setMetodoPago($metodoPago)
            ->setSerie($serie)
            ->setTipoCambio($tipoCambio);
    }
    /**
     * Get Certificado value
     * @return string
     */
    public function getCertificado()
    {
        return $this->Certificado;
    }
    /**
     * Set Certificado value
     * @param string $certificado
     * @return \StructType\Comprobante
     */
    public function setCertificado($certificado = null)
    {
        // validation for constraint: string
        if (!is_null($certificado) && !is_string($certificado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certificado, true), gettype($certificado)), __LINE__);
        }
        $this->Certificado = $certificado;
        return $this;
    }
    /**
     * Get Fecha value
     * @return string
     */
    public function getFecha()
    {
        return $this->Fecha;
    }
    /**
     * Set Fecha value
     * @param string $fecha
     * @return \StructType\Comprobante
     */
    public function setFecha($fecha = null)
    {
        // validation for constraint: string
        if (!is_null($fecha) && !is_string($fecha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fecha, true), gettype($fecha)), __LINE__);
        }
        // validation for constraint: pattern((20[1-9][0-9])-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T(([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]))
        if (!is_null($fecha) && !preg_match('/(20[1-9][0-9])-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T(([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])/', $fecha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (20[1-9][0-9])-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T(([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])', var_export($fecha, true)), __LINE__);
        }
        $this->Fecha = $fecha;
        return $this;
    }
    /**
     * Get LugarExpedicion value
     * @return string
     */
    public function getLugarExpedicion()
    {
        return $this->LugarExpedicion;
    }
    /**
     * Set LugarExpedicion value
     * @param string $lugarExpedicion
     * @return \StructType\Comprobante
     */
    public function setLugarExpedicion($lugarExpedicion = null)
    {
        // validation for constraint: string
        if (!is_null($lugarExpedicion) && !is_string($lugarExpedicion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lugarExpedicion, true), gettype($lugarExpedicion)), __LINE__);
        }
        // validation for constraint: pattern([0-9][0-9][0-9][0-9][0-9])
        if (!is_null($lugarExpedicion) && !preg_match('/[0-9][0-9][0-9][0-9][0-9]/', $lugarExpedicion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9][0-9][0-9][0-9][0-9]', var_export($lugarExpedicion, true)), __LINE__);
        }
        $this->LugarExpedicion = $lugarExpedicion;
        return $this;
    }
    /**
     * Get Moneda value
     * @return string
     */
    public function getMoneda()
    {
        return $this->Moneda;
    }
    /**
     * Set Moneda value
     * @param string $moneda
     * @return \StructType\Comprobante
     */
    public function setMoneda($moneda = null)
    {
        // validation for constraint: string
        if (!is_null($moneda) && !is_string($moneda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moneda, true), gettype($moneda)), __LINE__);
        }
        $this->Moneda = $moneda;
        return $this;
    }
    /**
     * Get NoCertificado value
     * @return string
     */
    public function getNoCertificado()
    {
        return $this->NoCertificado;
    }
    /**
     * Set NoCertificado value
     * @param string $noCertificado
     * @return \StructType\Comprobante
     */
    public function setNoCertificado($noCertificado = null)
    {
        // validation for constraint: string
        if (!is_null($noCertificado) && !is_string($noCertificado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noCertificado, true), gettype($noCertificado)), __LINE__);
        }
        // validation for constraint: length(20)
        if (!is_null($noCertificado) && mb_strlen($noCertificado) !== 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 20', mb_strlen($noCertificado)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{20})
        if (!is_null($noCertificado) && !preg_match('/[0-9]{20}/', $noCertificado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{20}', var_export($noCertificado, true)), __LINE__);
        }
        $this->NoCertificado = $noCertificado;
        return $this;
    }
    /**
     * Get Sello value
     * @return string
     */
    public function getSello()
    {
        return $this->Sello;
    }
    /**
     * Set Sello value
     * @param string $sello
     * @return \StructType\Comprobante
     */
    public function setSello($sello = null)
    {
        // validation for constraint: string
        if (!is_null($sello) && !is_string($sello)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sello, true), gettype($sello)), __LINE__);
        }
        $this->Sello = $sello;
        return $this;
    }
    /**
     * Get SubTotal value
     * @return float
     */
    public function getSubTotal()
    {
        return $this->SubTotal;
    }
    /**
     * Set SubTotal value
     * @param float $subTotal
     * @return \StructType\Comprobante
     */
    public function setSubTotal($subTotal = null)
    {
        // validation for constraint: float
        if (!is_null($subTotal) && !(is_float($subTotal) || is_numeric($subTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($subTotal, true), gettype($subTotal)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($subTotal) && mb_strlen(mb_substr($subTotal, false !== mb_strpos($subTotal, '.') ? mb_strpos($subTotal, '.') + 1 : mb_strlen($subTotal))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($subTotal, true), mb_strlen(mb_substr($subTotal, mb_strpos($subTotal, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($subTotal) && $subTotal < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($subTotal, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,18}(.[0-9]{1,6})?)
        if (!is_null($subTotal) && !preg_match('/[0-9]{1,18}(.[0-9]{1,6})?/', $subTotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,18}(.[0-9]{1,6})?', var_export($subTotal, true)), __LINE__);
        }
        $this->SubTotal = $subTotal;
        return $this;
    }
    /**
     * Get TipoDeComprobante value
     * @return string
     */
    public function getTipoDeComprobante()
    {
        return $this->TipoDeComprobante;
    }
    /**
     * Set TipoDeComprobante value
     * @uses \EnumType\C_TipoDeComprobante::valueIsValid()
     * @uses \EnumType\C_TipoDeComprobante::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoDeComprobante
     * @return \StructType\Comprobante
     */
    public function setTipoDeComprobante($tipoDeComprobante = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\C_TipoDeComprobante::valueIsValid($tipoDeComprobante)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\C_TipoDeComprobante', is_array($tipoDeComprobante) ? implode(', ', $tipoDeComprobante) : var_export($tipoDeComprobante, true), implode(', ', \EnumType\C_TipoDeComprobante::getValidValues())), __LINE__);
        }
        $this->TipoDeComprobante = $tipoDeComprobante;
        return $this;
    }
    /**
     * Get Total value
     * @return float
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param float $total
     * @return \StructType\Comprobante
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total) && mb_strlen(mb_substr($total, false !== mb_strpos($total, '.') ? mb_strpos($total, '.') + 1 : mb_strlen($total))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total, true), mb_strlen(mb_substr($total, mb_strpos($total, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($total) && $total < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($total, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,18}(.[0-9]{1,6})?)
        if (!is_null($total) && !preg_match('/[0-9]{1,18}(.[0-9]{1,6})?/', $total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,18}(.[0-9]{1,6})?', var_export($total, true)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Version value
     * @return string
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\Comprobante
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get CfdiRelacionados value
     * @return \StructType\CfdiRelacionados|null
     */
    public function getCfdiRelacionados()
    {
        return $this->CfdiRelacionados;
    }
    /**
     * Set CfdiRelacionados value
     * @param \StructType\CfdiRelacionados $cfdiRelacionados
     * @return \StructType\Comprobante
     */
    public function setCfdiRelacionados(\StructType\CfdiRelacionados $cfdiRelacionados = null)
    {
        $this->CfdiRelacionados = $cfdiRelacionados;
        return $this;
    }
    /**
     * Get Emisor value
     * @return \StructType\Emisor|null
     */
    public function getEmisor()
    {
        return $this->Emisor;
    }
    /**
     * Set Emisor value
     * @param \StructType\Emisor $emisor
     * @return \StructType\Comprobante
     */
    public function setEmisor(\StructType\Emisor $emisor = null)
    {
        $this->Emisor = $emisor;
        return $this;
    }
    /**
     * Get Receptor value
     * @return \StructType\Receptor|null
     */
    public function getReceptor()
    {
        return $this->Receptor;
    }
    /**
     * Set Receptor value
     * @param \StructType\Receptor $receptor
     * @return \StructType\Comprobante
     */
    public function setReceptor(\StructType\Receptor $receptor = null)
    {
        $this->Receptor = $receptor;
        return $this;
    }
    /**
     * Get Conceptos value
     * @return \StructType\Conceptos|null
     */
    public function getConceptos()
    {
        return $this->Conceptos;
    }
    /**
     * Set Conceptos value
     * @param \StructType\Conceptos $conceptos
     * @return \StructType\Comprobante
     */
    public function setConceptos(\StructType\Conceptos $conceptos = null)
    {
        $this->Conceptos = $conceptos;
        return $this;
    }
    /**
     * Get Impuestos value
     * @return \StructType\Impuestos|null
     */
    public function getImpuestos()
    {
        return $this->Impuestos;
    }
    /**
     * Set Impuestos value
     * @param \StructType\Impuestos $impuestos
     * @return \StructType\Comprobante
     */
    public function setImpuestos(\StructType\Impuestos $impuestos = null)
    {
        $this->Impuestos = $impuestos;
        return $this;
    }
    /**
     * Get Complemento value
     * @return \StructType\Complemento[]|null
     */
    public function getComplemento()
    {
        return $this->Complemento;
    }
    /**
     * This method is responsible for validating the values passed to the setComplemento method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComplemento method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateComplementoForArrayConstraintsFromSetComplemento(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $comprobanteComplementoItem) {
            // validation for constraint: itemType
            if (!$comprobanteComplementoItem instanceof \StructType\Complemento) {
                $invalidValues[] = is_object($comprobanteComplementoItem) ? get_class($comprobanteComplementoItem) : sprintf('%s(%s)', gettype($comprobanteComplementoItem), var_export($comprobanteComplementoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Complemento property can only contain items of type \StructType\Complemento, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Complemento value
     * @throws \InvalidArgumentException
     * @param \StructType\Complemento[] $complemento
     * @return \StructType\Comprobante
     */
    public function setComplemento(array $complemento = array())
    {
        // validation for constraint: array
        if ('' !== ($complementoArrayErrorMessage = self::validateComplementoForArrayConstraintsFromSetComplemento($complemento))) {
            throw new \InvalidArgumentException($complementoArrayErrorMessage, __LINE__);
        }
        $this->Complemento = $complemento;
        return $this;
    }
    /**
     * Add item to Complemento value
     * @throws \InvalidArgumentException
     * @param \StructType\Complemento $item
     * @return \StructType\Comprobante
     */
    public function addToComplemento(\StructType\Complemento $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Complemento) {
            throw new \InvalidArgumentException(sprintf('The Complemento property can only contain items of type \StructType\Complemento, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Complemento[] = $item;
        return $this;
    }
    /**
     * Get Addenda value
     * @return \StructType\Addenda|null
     */
    public function getAddenda()
    {
        return $this->Addenda;
    }
    /**
     * Set Addenda value
     * @param \StructType\Addenda $addenda
     * @return \StructType\Comprobante
     */
    public function setAddenda(\StructType\Addenda $addenda = null)
    {
        $this->Addenda = $addenda;
        return $this;
    }
    /**
     * Get CondicionesDePago value
     * @return string|null
     */
    public function getCondicionesDePago()
    {
        return $this->CondicionesDePago;
    }
    /**
     * Set CondicionesDePago value
     * @param string $condicionesDePago
     * @return \StructType\Comprobante
     */
    public function setCondicionesDePago($condicionesDePago = null)
    {
        // validation for constraint: string
        if (!is_null($condicionesDePago) && !is_string($condicionesDePago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($condicionesDePago, true), gettype($condicionesDePago)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($condicionesDePago) && mb_strlen($condicionesDePago) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($condicionesDePago)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($condicionesDePago) && mb_strlen($condicionesDePago) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($condicionesDePago)), __LINE__);
        }
        // validation for constraint: pattern([^|]{1,1000})
        if (!is_null($condicionesDePago) && !preg_match('/[^|]{1,1000}/', $condicionesDePago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^|]{1,1000}', var_export($condicionesDePago, true)), __LINE__);
        }
        $this->CondicionesDePago = $condicionesDePago;
        return $this;
    }
    /**
     * Get Confirmacion value
     * @return string|null
     */
    public function getConfirmacion()
    {
        return $this->Confirmacion;
    }
    /**
     * Set Confirmacion value
     * @param string $confirmacion
     * @return \StructType\Comprobante
     */
    public function setConfirmacion($confirmacion = null)
    {
        // validation for constraint: string
        if (!is_null($confirmacion) && !is_string($confirmacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmacion, true), gettype($confirmacion)), __LINE__);
        }
        // validation for constraint: length(5)
        if (!is_null($confirmacion) && mb_strlen($confirmacion) !== 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 5', mb_strlen($confirmacion)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{5})
        if (!is_null($confirmacion) && !preg_match('/[0-9a-zA-Z]{5}/', $confirmacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{5}', var_export($confirmacion, true)), __LINE__);
        }
        $this->Confirmacion = $confirmacion;
        return $this;
    }
    /**
     * Get Descuento value
     * @return float|null
     */
    public function getDescuento()
    {
        return $this->Descuento;
    }
    /**
     * Set Descuento value
     * @param float $descuento
     * @return \StructType\Comprobante
     */
    public function setDescuento($descuento = null)
    {
        // validation for constraint: float
        if (!is_null($descuento) && !(is_float($descuento) || is_numeric($descuento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($descuento, true), gettype($descuento)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($descuento) && mb_strlen(mb_substr($descuento, false !== mb_strpos($descuento, '.') ? mb_strpos($descuento, '.') + 1 : mb_strlen($descuento))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($descuento, true), mb_strlen(mb_substr($descuento, mb_strpos($descuento, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($descuento) && $descuento < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($descuento, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,18}(.[0-9]{1,6})?)
        if (!is_null($descuento) && !preg_match('/[0-9]{1,18}(.[0-9]{1,6})?/', $descuento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,18}(.[0-9]{1,6})?', var_export($descuento, true)), __LINE__);
        }
        $this->Descuento = $descuento;
        return $this;
    }
    /**
     * Get Folio value
     * @return string|null
     */
    public function getFolio()
    {
        return $this->Folio;
    }
    /**
     * Set Folio value
     * @param string $folio
     * @return \StructType\Comprobante
     */
    public function setFolio($folio = null)
    {
        // validation for constraint: string
        if (!is_null($folio) && !is_string($folio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($folio, true), gettype($folio)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($folio) && mb_strlen($folio) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($folio)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($folio) && mb_strlen($folio) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($folio)), __LINE__);
        }
        // validation for constraint: pattern([^|]{1,40})
        if (!is_null($folio) && !preg_match('/[^|]{1,40}/', $folio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^|]{1,40}', var_export($folio, true)), __LINE__);
        }
        $this->Folio = $folio;
        return $this;
    }
    /**
     * Get FormaPago value
     * @return string|null
     */
    public function getFormaPago()
    {
        return $this->FormaPago;
    }
    /**
     * Set FormaPago value
     * @uses \EnumType\C_FormaPago::valueIsValid()
     * @uses \EnumType\C_FormaPago::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $formaPago
     * @return \StructType\Comprobante
     */
    public function setFormaPago($formaPago = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\C_FormaPago::valueIsValid($formaPago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\C_FormaPago', is_array($formaPago) ? implode(', ', $formaPago) : var_export($formaPago, true), implode(', ', \EnumType\C_FormaPago::getValidValues())), __LINE__);
        }
        $this->FormaPago = $formaPago;
        return $this;
    }
    /**
     * Get MetodoPago value
     * @return string|null
     */
    public function getMetodoPago()
    {
        return $this->MetodoPago;
    }
    /**
     * Set MetodoPago value
     * @uses \EnumType\C_MetodoPago::valueIsValid()
     * @uses \EnumType\C_MetodoPago::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $metodoPago
     * @return \StructType\Comprobante
     */
    public function setMetodoPago($metodoPago = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\C_MetodoPago::valueIsValid($metodoPago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\C_MetodoPago', is_array($metodoPago) ? implode(', ', $metodoPago) : var_export($metodoPago, true), implode(', ', \EnumType\C_MetodoPago::getValidValues())), __LINE__);
        }
        $this->MetodoPago = $metodoPago;
        return $this;
    }
    /**
     * Get Serie value
     * @return string|null
     */
    public function getSerie()
    {
        return $this->Serie;
    }
    /**
     * Set Serie value
     * @param string $serie
     * @return \StructType\Comprobante
     */
    public function setSerie($serie = null)
    {
        // validation for constraint: string
        if (!is_null($serie) && !is_string($serie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serie, true), gettype($serie)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($serie) && mb_strlen($serie) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($serie)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($serie) && mb_strlen($serie) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($serie)), __LINE__);
        }
        // validation for constraint: pattern([^|]{1,25})
        if (!is_null($serie) && !preg_match('/[^|]{1,25}/', $serie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^|]{1,25}', var_export($serie, true)), __LINE__);
        }
        $this->Serie = $serie;
        return $this;
    }
    /**
     * Get TipoCambio value
     * @return float|null
     */
    public function getTipoCambio()
    {
        return $this->TipoCambio;
    }
    /**
     * Set TipoCambio value
     * @param float $tipoCambio
     * @return \StructType\Comprobante
     */
    public function setTipoCambio($tipoCambio = null)
    {
        // validation for constraint: float
        if (!is_null($tipoCambio) && !(is_float($tipoCambio) || is_numeric($tipoCambio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tipoCambio, true), gettype($tipoCambio)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($tipoCambio) && mb_strlen(mb_substr($tipoCambio, false !== mb_strpos($tipoCambio, '.') ? mb_strpos($tipoCambio, '.') + 1 : mb_strlen($tipoCambio))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($tipoCambio, true), mb_strlen(mb_substr($tipoCambio, mb_strpos($tipoCambio, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.000001)
        if (!is_null($tipoCambio) && $tipoCambio < 0.000001) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.000001', var_export($tipoCambio, true)), __LINE__);
        }
        $this->TipoCambio = $tipoCambio;
        return $this;
    }
}
