<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Complemento StructType
 * Meta information extracted from the WSDL
 * - documentation: Complemento requerido para la emision y recepcion de comprobantes fiscales digitales en el sector Retail | Complemento requerido para el Timbrado Fiscal Digital que da validez al Comprobante fiscal digital por Internet. | Complemento
 * para el Comprobante Fiscal Digital por Internet (CFDI) para registrar información sobre la recepción de pagos. El emisor de este complemento para recepción de pagos debe ser quien las leyes le obligue a expedir comprobantes por los actos o
 * actividades que realicen, por los ingresos que se perciban o por las retenciones de contribuciones que efectúen. | Nodo opcional donde se incluye el complemento Timbre Fiscal Digital de manera obligatoria y los nodos complementarios determinados por
 * el SAT, de acuerdo con las disposiciones particulares para un sector o actividad específica.
 * @subpackage Structs
 */
class Complemento extends AbstractStructBase
{
    /**
     * The Pagos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:Pagos
     * @var \StructType\Pagos
     */
    public $Pagos;
    /**
     * The TimbreFiscalDigital
     * Meta information extracted from the WSDL
     * - ref: ns0:TimbreFiscalDigital
     * @var \StructType\TimbreFiscalDigital
     */
    public $TimbreFiscalDigital;
    /**
     * The detallista
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: detallista:detallista
     * @var \StructType\Detallista
     */
    public $detallista;
    /**
     * Constructor method for Complemento
     * @uses Complemento::setPagos()
     * @uses Complemento::setTimbreFiscalDigital()
     * @uses Complemento::setDetallista()
     * @param \StructType\Pagos $pagos
     * @param \StructType\TimbreFiscalDigital $timbreFiscalDigital
     * @param \StructType\Detallista $detallista
     */
    public function __construct(\StructType\Pagos $pagos = null, \StructType\TimbreFiscalDigital $timbreFiscalDigital = null, \StructType\Detallista $detallista = null)
    {
        $this
            ->setPagos($pagos)
            ->setTimbreFiscalDigital($timbreFiscalDigital)
            ->setDetallista($detallista);
    }
    /**
     * Get Pagos value
     * @return \StructType\Pagos|null
     */
    public function getPagos()
    {
        return $this->Pagos;
    }
    /**
     * Set Pagos value
     * @param \StructType\Pagos $pagos
     * @return \StructType\Complemento
     */
    public function setPagos(\StructType\Pagos $pagos = null)
    {
        $this->Pagos = $pagos;
        return $this;
    }
    /**
     * Get TimbreFiscalDigital value
     * @return \StructType\TimbreFiscalDigital|null
     */
    public function getTimbreFiscalDigital()
    {
        return $this->TimbreFiscalDigital;
    }
    /**
     * Set TimbreFiscalDigital value
     * @param \StructType\TimbreFiscalDigital $timbreFiscalDigital
     * @return \StructType\Complemento
     */
    public function setTimbreFiscalDigital(\StructType\TimbreFiscalDigital $timbreFiscalDigital = null)
    {
        $this->TimbreFiscalDigital = $timbreFiscalDigital;
        return $this;
    }
    /**
     * Get detallista value
     * @return \StructType\Detallista|null
     */
    public function getDetallista()
    {
        return $this->detallista;
    }
    /**
     * Set detallista value
     * @param \StructType\Detallista $detallista
     * @return \StructType\Complemento
     */
    public function setDetallista(\StructType\Detallista $detallista = null)
    {
        $this->detallista = $detallista;
        return $this;
    }
}
