<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CfdiRelacionados StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional para precisar la información de los comprobantes relacionados.
 * @subpackage Structs
 */
class CfdiRelacionados extends AbstractStructBase
{
    /**
     * The TipoRelacion
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para indicar la clave de la relación que existe entre éste que se esta generando y el o los CFDI previos.
     * - use: required
     * @var string
     */
    public $TipoRelacion;
    /**
     * The CfdiRelacionado
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\CfdiRelacionado[]
     */
    public $CfdiRelacionado;
    /**
     * Constructor method for CfdiRelacionados
     * @uses CfdiRelacionados::setTipoRelacion()
     * @uses CfdiRelacionados::setCfdiRelacionado()
     * @param string $tipoRelacion
     * @param \StructType\CfdiRelacionado[] $cfdiRelacionado
     */
    public function __construct($tipoRelacion = null, array $cfdiRelacionado = array())
    {
        $this
            ->setTipoRelacion($tipoRelacion)
            ->setCfdiRelacionado($cfdiRelacionado);
    }
    /**
     * Get TipoRelacion value
     * @return string
     */
    public function getTipoRelacion()
    {
        return $this->TipoRelacion;
    }
    /**
     * Set TipoRelacion value
     * @uses \EnumType\C_TipoRelacion::valueIsValid()
     * @uses \EnumType\C_TipoRelacion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoRelacion
     * @return \StructType\CfdiRelacionados
     */
    public function setTipoRelacion($tipoRelacion = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\C_TipoRelacion::valueIsValid($tipoRelacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\C_TipoRelacion', is_array($tipoRelacion) ? implode(', ', $tipoRelacion) : var_export($tipoRelacion, true), implode(', ', \EnumType\C_TipoRelacion::getValidValues())), __LINE__);
        }
        $this->TipoRelacion = $tipoRelacion;
        return $this;
    }
    /**
     * Get CfdiRelacionado value
     * @return \StructType\CfdiRelacionado[]|null
     */
    public function getCfdiRelacionado()
    {
        return $this->CfdiRelacionado;
    }
    /**
     * This method is responsible for validating the values passed to the setCfdiRelacionado method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCfdiRelacionado method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCfdiRelacionadoForArrayConstraintsFromSetCfdiRelacionado(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cfdiRelacionadosCfdiRelacionadoItem) {
            // validation for constraint: itemType
            if (!$cfdiRelacionadosCfdiRelacionadoItem instanceof \StructType\CfdiRelacionado) {
                $invalidValues[] = is_object($cfdiRelacionadosCfdiRelacionadoItem) ? get_class($cfdiRelacionadosCfdiRelacionadoItem) : sprintf('%s(%s)', gettype($cfdiRelacionadosCfdiRelacionadoItem), var_export($cfdiRelacionadosCfdiRelacionadoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CfdiRelacionado property can only contain items of type \StructType\CfdiRelacionado, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CfdiRelacionado value
     * @throws \InvalidArgumentException
     * @param \StructType\CfdiRelacionado[] $cfdiRelacionado
     * @return \StructType\CfdiRelacionados
     */
    public function setCfdiRelacionado(array $cfdiRelacionado = array())
    {
        // validation for constraint: array
        if ('' !== ($cfdiRelacionadoArrayErrorMessage = self::validateCfdiRelacionadoForArrayConstraintsFromSetCfdiRelacionado($cfdiRelacionado))) {
            throw new \InvalidArgumentException($cfdiRelacionadoArrayErrorMessage, __LINE__);
        }
        $this->CfdiRelacionado = $cfdiRelacionado;
        return $this;
    }
    /**
     * Add item to CfdiRelacionado value
     * @throws \InvalidArgumentException
     * @param \StructType\CfdiRelacionado $item
     * @return \StructType\CfdiRelacionados
     */
    public function addToCfdiRelacionado(\StructType\CfdiRelacionado $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CfdiRelacionado) {
            throw new \InvalidArgumentException(sprintf('The CfdiRelacionado property can only contain items of type \StructType\CfdiRelacionado, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CfdiRelacionado[] = $item;
        return $this;
    }
}
