<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CfdiRelacionado StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo requerido para precisar la información de los comprobantes relacionados.
 * @subpackage Structs
 */
class CfdiRelacionado extends AbstractStructBase
{
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 36
     * - pattern: [a-f0-9A-F]{8}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{12}
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $UUID;
    /**
     * Constructor method for CfdiRelacionado
     * @uses CfdiRelacionado::setUUID()
     * @param string $uUID
     */
    public function __construct($uUID = null)
    {
        $this
            ->setUUID($uUID);
    }
    /**
     * Get UUID value
     * @return string
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\CfdiRelacionado
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        // validation for constraint: length(36)
        if (!is_null($uUID) && mb_strlen($uUID) !== 36) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 36', mb_strlen($uUID)), __LINE__);
        }
        // validation for constraint: pattern([a-f0-9A-F]{8}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{12})
        if (!is_null($uUID) && !preg_match('/[a-f0-9A-F]{8}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{12}/', $uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-f0-9A-F]{8}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{12}', var_export($uUID, true)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
}
