<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for buyer StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo requerido que especifica información del comprador
 * @subpackage Structs
 */
class Buyer extends AbstractStructBase
{
    /**
     * The gln
     * Meta information extracted from the WSDL
     * - documentation: Nodo requerido que especifica el número global de localización (GLN) del comprador. | Nodo requerido que especifica el número global de localización (GLN) del vendedor. | Nodo opcional que especifica el número global de
     * localización (GLN) de la ubicación a entregar la mercancía | Nodo opcional que especifica el número global de localización (GLN)de la ubicación del emisor de la factura | Nodo opcional que especifica el número global de localización (GLN) de
     * la aduana | SG2NAD 3039 CALIF BY | SG2NAD 3039 CALIF SU
     * - base: xs:string
     * - length: 13
     * @var string
     */
    public $gln;
    /**
     * The contactInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContactInformation
     */
    public $contactInformation;
    /**
     * Constructor method for buyer
     * @uses Buyer::setGln()
     * @uses Buyer::setContactInformation()
     * @param string $gln
     * @param \StructType\ContactInformation $contactInformation
     */
    public function __construct($gln = null, \StructType\ContactInformation $contactInformation = null)
    {
        $this
            ->setGln($gln)
            ->setContactInformation($contactInformation);
    }
    /**
     * Get gln value
     * @return string|null
     */
    public function getGln()
    {
        return $this->gln;
    }
    /**
     * Set gln value
     * @param string $gln
     * @return \StructType\Buyer
     */
    public function setGln($gln = null)
    {
        // validation for constraint: string
        if (!is_null($gln) && !is_string($gln)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gln, true), gettype($gln)), __LINE__);
        }
        // validation for constraint: length(13)
        if (!is_null($gln) && mb_strlen($gln) !== 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 13', mb_strlen($gln)), __LINE__);
        }
        $this->gln = $gln;
        return $this;
    }
    /**
     * Get contactInformation value
     * @return \StructType\ContactInformation|null
     */
    public function getContactInformation()
    {
        return $this->contactInformation;
    }
    /**
     * Set contactInformation value
     * @param \StructType\ContactInformation $contactInformation
     * @return \StructType\Buyer
     */
    public function setContactInformation(\StructType\ContactInformation $contactInformation = null)
    {
        $this->contactInformation = $contactInformation;
        return $this;
    }
}
