<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for allowanceCharge StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional que especifica la información de los cargos o descuentos globales por línea de artículo | Nodo opcional que especifica la información de los cargos o descuentos globales mercantiles por factura
 * @subpackage Structs
 */
class AllowanceCharge extends AbstractStructBase
{
    /**
     * The allowanceChargeType
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $allowanceChargeType;
    /**
     * The settlementType
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $settlementType;
    /**
     * The specialServicesType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $specialServicesType;
    /**
     * The monetaryAmountOrPercentage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MonetaryAmountOrPercentage
     */
    public $monetaryAmountOrPercentage;
    /**
     * The sequenceNumber
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 15
     * - minLength: 1
     * @var string
     */
    public $sequenceNumber;
    /**
     * Constructor method for allowanceCharge
     * @uses AllowanceCharge::setAllowanceChargeType()
     * @uses AllowanceCharge::setSettlementType()
     * @uses AllowanceCharge::setSpecialServicesType()
     * @uses AllowanceCharge::setMonetaryAmountOrPercentage()
     * @uses AllowanceCharge::setSequenceNumber()
     * @param string $allowanceChargeType
     * @param string $settlementType
     * @param string $specialServicesType
     * @param \StructType\MonetaryAmountOrPercentage $monetaryAmountOrPercentage
     * @param string $sequenceNumber
     */
    public function __construct($allowanceChargeType = null, $settlementType = null, $specialServicesType = null, \StructType\MonetaryAmountOrPercentage $monetaryAmountOrPercentage = null, $sequenceNumber = null)
    {
        $this
            ->setAllowanceChargeType($allowanceChargeType)
            ->setSettlementType($settlementType)
            ->setSpecialServicesType($specialServicesType)
            ->setMonetaryAmountOrPercentage($monetaryAmountOrPercentage)
            ->setSequenceNumber($sequenceNumber);
    }
    /**
     * Get allowanceChargeType value
     * @return string
     */
    public function getAllowanceChargeType()
    {
        return $this->allowanceChargeType;
    }
    /**
     * Set allowanceChargeType value
     * @param string $allowanceChargeType
     * @return \StructType\AllowanceCharge
     */
    public function setAllowanceChargeType($allowanceChargeType = null)
    {
        // validation for constraint: string
        if (!is_null($allowanceChargeType) && !is_string($allowanceChargeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowanceChargeType, true), gettype($allowanceChargeType)), __LINE__);
        }
        $this->allowanceChargeType = $allowanceChargeType;
        return $this;
    }
    /**
     * Get settlementType value
     * @return string
     */
    public function getSettlementType()
    {
        return $this->settlementType;
    }
    /**
     * Set settlementType value
     * @param string $settlementType
     * @return \StructType\AllowanceCharge
     */
    public function setSettlementType($settlementType = null)
    {
        // validation for constraint: string
        if (!is_null($settlementType) && !is_string($settlementType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settlementType, true), gettype($settlementType)), __LINE__);
        }
        $this->settlementType = $settlementType;
        return $this;
    }
    /**
     * Get specialServicesType value
     * @return string|null
     */
    public function getSpecialServicesType()
    {
        return $this->specialServicesType;
    }
    /**
     * Set specialServicesType value
     * @uses \EnumType\SpecialServicesType::valueIsValid()
     * @uses \EnumType\SpecialServicesType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $specialServicesType
     * @return \StructType\AllowanceCharge
     */
    public function setSpecialServicesType($specialServicesType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SpecialServicesType::valueIsValid($specialServicesType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SpecialServicesType', is_array($specialServicesType) ? implode(', ', $specialServicesType) : var_export($specialServicesType, true), implode(', ', \EnumType\SpecialServicesType::getValidValues())), __LINE__);
        }
        $this->specialServicesType = $specialServicesType;
        return $this;
    }
    /**
     * Get monetaryAmountOrPercentage value
     * @return \StructType\MonetaryAmountOrPercentage|null
     */
    public function getMonetaryAmountOrPercentage()
    {
        return $this->monetaryAmountOrPercentage;
    }
    /**
     * Set monetaryAmountOrPercentage value
     * @param \StructType\MonetaryAmountOrPercentage $monetaryAmountOrPercentage
     * @return \StructType\AllowanceCharge
     */
    public function setMonetaryAmountOrPercentage(\StructType\MonetaryAmountOrPercentage $monetaryAmountOrPercentage = null)
    {
        $this->monetaryAmountOrPercentage = $monetaryAmountOrPercentage;
        return $this;
    }
    /**
     * Get sequenceNumber value
     * @return string|null
     */
    public function getSequenceNumber()
    {
        return $this->sequenceNumber;
    }
    /**
     * Set sequenceNumber value
     * @param string $sequenceNumber
     * @return \StructType\AllowanceCharge
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sequenceNumber) && !is_string($sequenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sequenceNumber, true), gettype($sequenceNumber)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($sequenceNumber) && mb_strlen($sequenceNumber) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($sequenceNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($sequenceNumber) && mb_strlen($sequenceNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($sequenceNumber)), __LINE__);
        }
        $this->sequenceNumber = $sequenceNumber;
        return $this;
    }
}
