<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ackErrorApplicationIdentification StructType
 * @subpackage Structs
 */
class AckErrorApplicationIdentification extends AbstractStructBase
{
    /**
     * The entityType
     * Meta information extracted from the WSDL
     * - form: qualified
     * @var string
     */
    public $entityType;
    /**
     * The uniqueCreatorIdentification
     * Meta information extracted from the WSDL
     * - documentation: BGM 1004 No Folio
     * - form: qualified
     * @var string
     */
    public $uniqueCreatorIdentification;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * Constructor method for ackErrorApplicationIdentification
     * @uses AckErrorApplicationIdentification::setEntityType()
     * @uses AckErrorApplicationIdentification::setUniqueCreatorIdentification()
     * @uses AckErrorApplicationIdentification::setType()
     * @param string $entityType
     * @param string $uniqueCreatorIdentification
     * @param string $type
     */
    public function __construct($entityType = null, $uniqueCreatorIdentification = null, $type = null)
    {
        $this
            ->setEntityType($entityType)
            ->setUniqueCreatorIdentification($uniqueCreatorIdentification)
            ->setType($type);
    }
    /**
     * Get entityType value
     * @return string|null
     */
    public function getEntityType()
    {
        return $this->entityType;
    }
    /**
     * Set entityType value
     * @uses \EnumType\EntityType::valueIsValid()
     * @uses \EnumType\EntityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $entityType
     * @return \StructType\AckErrorApplicationIdentification
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityType::valueIsValid($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityType', is_array($entityType) ? implode(', ', $entityType) : var_export($entityType, true), implode(', ', \EnumType\EntityType::getValidValues())), __LINE__);
        }
        $this->entityType = $entityType;
        return $this;
    }
    /**
     * Get uniqueCreatorIdentification value
     * @return string|null
     */
    public function getUniqueCreatorIdentification()
    {
        return $this->uniqueCreatorIdentification;
    }
    /**
     * Set uniqueCreatorIdentification value
     * @param string $uniqueCreatorIdentification
     * @return \StructType\AckErrorApplicationIdentification
     */
    public function setUniqueCreatorIdentification($uniqueCreatorIdentification = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueCreatorIdentification) && !is_string($uniqueCreatorIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueCreatorIdentification, true), gettype($uniqueCreatorIdentification)), __LINE__);
        }
        $this->uniqueCreatorIdentification = $uniqueCreatorIdentification;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\AckErrorApplicationIdentification
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
