<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AckErrorApplication StructType
 * Meta information extracted from the WSDL
 * - documentation: Respuesta de Aplicación XML en Base a EAN UCC
 * @subpackage Structs
 */
class AckErrorApplication extends AbstractStructBase
{
    /**
     * The ackErrorApplicationIdentification
     * Meta information extracted from the WSDL
     * - form: qualified
     * @var \StructType\AckErrorApplicationIdentification
     */
    public $ackErrorApplicationIdentification;
    /**
     * The ApplicationInformation
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\ApplicationInformation
     */
    public $ApplicationInformation;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - form: qualified
     * @var \StructType\ReferenceNumber
     */
    public $ReferenceNumber;
    /**
     * The supplierNumber
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\SupplierNumber
     */
    public $supplierNumber;
    /**
     * The additionalReferenceNumber
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\AdditionalReferenceNumber
     */
    public $additionalReferenceNumber;
    /**
     * The despatchAdviceNumber
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\DespatchAdviceNumber
     */
    public $despatchAdviceNumber;
    /**
     * The Buyer
     * Meta information extracted from the WSDL
     * - form: qualified
     * @var \StructType\Buyer_1
     */
    public $Buyer;
    /**
     * The Seller
     * Meta information extracted from the WSDL
     * - form: qualified
     * @var \StructType\Seller_1
     */
    public $Seller;
    /**
     * The messageError
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: 99999
     * @var \StructType\MessageError[]
     */
    public $messageError;
    /**
     * The contentVersion
     * @var anySimpleType
     */
    public $contentVersion;
    /**
     * The creationDate
     * @var anySimpleType
     */
    public $creationDate;
    /**
     * The documentStatus
     * @var string
     */
    public $documentStatus;
    /**
     * The documentStructureVersion
     * @var anySimpleType
     */
    public $documentStructureVersion;
    /**
     * Constructor method for AckErrorApplication
     * @uses AckErrorApplication::setAckErrorApplicationIdentification()
     * @uses AckErrorApplication::setApplicationInformation()
     * @uses AckErrorApplication::setReferenceNumber()
     * @uses AckErrorApplication::setSupplierNumber()
     * @uses AckErrorApplication::setAdditionalReferenceNumber()
     * @uses AckErrorApplication::setDespatchAdviceNumber()
     * @uses AckErrorApplication::setBuyer()
     * @uses AckErrorApplication::setSeller()
     * @uses AckErrorApplication::setMessageError()
     * @uses AckErrorApplication::setContentVersion()
     * @uses AckErrorApplication::setCreationDate()
     * @uses AckErrorApplication::setDocumentStatus()
     * @uses AckErrorApplication::setDocumentStructureVersion()
     * @param \StructType\AckErrorApplicationIdentification $ackErrorApplicationIdentification
     * @param \StructType\ApplicationInformation $applicationInformation
     * @param \StructType\ReferenceNumber $referenceNumber
     * @param \StructType\SupplierNumber $supplierNumber
     * @param \StructType\AdditionalReferenceNumber $additionalReferenceNumber
     * @param \StructType\DespatchAdviceNumber $despatchAdviceNumber
     * @param \StructType\Buyer_1 $buyer
     * @param \StructType\Seller_1 $seller
     * @param \StructType\MessageError[] $messageError
     * @param anySimpleType $contentVersion
     * @param anySimpleType $creationDate
     * @param string $documentStatus
     * @param anySimpleType $documentStructureVersion
     */
    public function __construct(\StructType\AckErrorApplicationIdentification $ackErrorApplicationIdentification = null, \StructType\ApplicationInformation $applicationInformation = null, \StructType\ReferenceNumber $referenceNumber = null, \StructType\SupplierNumber $supplierNumber = null, \StructType\AdditionalReferenceNumber $additionalReferenceNumber = null, \StructType\DespatchAdviceNumber $despatchAdviceNumber = null, \StructType\Buyer_1 $buyer = null, \StructType\Seller_1 $seller = null, array $messageError = array(), anySimpleType $contentVersion = null, anySimpleType $creationDate = null, $documentStatus = null, anySimpleType $documentStructureVersion = null)
    {
        $this
            ->setAckErrorApplicationIdentification($ackErrorApplicationIdentification)
            ->setApplicationInformation($applicationInformation)
            ->setReferenceNumber($referenceNumber)
            ->setSupplierNumber($supplierNumber)
            ->setAdditionalReferenceNumber($additionalReferenceNumber)
            ->setDespatchAdviceNumber($despatchAdviceNumber)
            ->setBuyer($buyer)
            ->setSeller($seller)
            ->setMessageError($messageError)
            ->setContentVersion($contentVersion)
            ->setCreationDate($creationDate)
            ->setDocumentStatus($documentStatus)
            ->setDocumentStructureVersion($documentStructureVersion);
    }
    /**
     * Get ackErrorApplicationIdentification value
     * @return \StructType\AckErrorApplicationIdentification|null
     */
    public function getAckErrorApplicationIdentification()
    {
        return $this->ackErrorApplicationIdentification;
    }
    /**
     * Set ackErrorApplicationIdentification value
     * @param \StructType\AckErrorApplicationIdentification $ackErrorApplicationIdentification
     * @return \StructType\AckErrorApplication
     */
    public function setAckErrorApplicationIdentification(\StructType\AckErrorApplicationIdentification $ackErrorApplicationIdentification = null)
    {
        $this->ackErrorApplicationIdentification = $ackErrorApplicationIdentification;
        return $this;
    }
    /**
     * Get ApplicationInformation value
     * @return \StructType\ApplicationInformation|null
     */
    public function getApplicationInformation()
    {
        return $this->ApplicationInformation;
    }
    /**
     * Set ApplicationInformation value
     * @param \StructType\ApplicationInformation $applicationInformation
     * @return \StructType\AckErrorApplication
     */
    public function setApplicationInformation(\StructType\ApplicationInformation $applicationInformation = null)
    {
        $this->ApplicationInformation = $applicationInformation;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return \StructType\ReferenceNumber|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param \StructType\ReferenceNumber $referenceNumber
     * @return \StructType\AckErrorApplication
     */
    public function setReferenceNumber(\StructType\ReferenceNumber $referenceNumber = null)
    {
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get supplierNumber value
     * @return \StructType\SupplierNumber|null
     */
    public function getSupplierNumber()
    {
        return $this->supplierNumber;
    }
    /**
     * Set supplierNumber value
     * @param \StructType\SupplierNumber $supplierNumber
     * @return \StructType\AckErrorApplication
     */
    public function setSupplierNumber(\StructType\SupplierNumber $supplierNumber = null)
    {
        $this->supplierNumber = $supplierNumber;
        return $this;
    }
    /**
     * Get additionalReferenceNumber value
     * @return \StructType\AdditionalReferenceNumber|null
     */
    public function getAdditionalReferenceNumber()
    {
        return $this->additionalReferenceNumber;
    }
    /**
     * Set additionalReferenceNumber value
     * @param \StructType\AdditionalReferenceNumber $additionalReferenceNumber
     * @return \StructType\AckErrorApplication
     */
    public function setAdditionalReferenceNumber(\StructType\AdditionalReferenceNumber $additionalReferenceNumber = null)
    {
        $this->additionalReferenceNumber = $additionalReferenceNumber;
        return $this;
    }
    /**
     * Get despatchAdviceNumber value
     * @return \StructType\DespatchAdviceNumber|null
     */
    public function getDespatchAdviceNumber()
    {
        return $this->despatchAdviceNumber;
    }
    /**
     * Set despatchAdviceNumber value
     * @param \StructType\DespatchAdviceNumber $despatchAdviceNumber
     * @return \StructType\AckErrorApplication
     */
    public function setDespatchAdviceNumber(\StructType\DespatchAdviceNumber $despatchAdviceNumber = null)
    {
        $this->despatchAdviceNumber = $despatchAdviceNumber;
        return $this;
    }
    /**
     * Get Buyer value
     * @return \StructType\Buyer_1|null
     */
    public function getBuyer()
    {
        return $this->Buyer;
    }
    /**
     * Set Buyer value
     * @param \StructType\Buyer_1 $buyer
     * @return \StructType\AckErrorApplication
     */
    public function setBuyer(\StructType\Buyer_1 $buyer = null)
    {
        $this->Buyer = $buyer;
        return $this;
    }
    /**
     * Get Seller value
     * @return \StructType\Seller_1|null
     */
    public function getSeller()
    {
        return $this->Seller;
    }
    /**
     * Set Seller value
     * @param \StructType\Seller_1 $seller
     * @return \StructType\AckErrorApplication
     */
    public function setSeller(\StructType\Seller_1 $seller = null)
    {
        $this->Seller = $seller;
        return $this;
    }
    /**
     * Get messageError value
     * @return \StructType\MessageError[]|null
     */
    public function getMessageError()
    {
        return $this->messageError;
    }
    /**
     * This method is responsible for validating the values passed to the setMessageError method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMessageError method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMessageErrorForArrayConstraintsFromSetMessageError(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ackErrorApplicationMessageErrorItem) {
            // validation for constraint: itemType
            if (!$ackErrorApplicationMessageErrorItem instanceof \StructType\MessageError) {
                $invalidValues[] = is_object($ackErrorApplicationMessageErrorItem) ? get_class($ackErrorApplicationMessageErrorItem) : sprintf('%s(%s)', gettype($ackErrorApplicationMessageErrorItem), var_export($ackErrorApplicationMessageErrorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The messageError property can only contain items of type \StructType\MessageError, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set messageError value
     * @throws \InvalidArgumentException
     * @param \StructType\MessageError[] $messageError
     * @return \StructType\AckErrorApplication
     */
    public function setMessageError(array $messageError = array())
    {
        // validation for constraint: array
        if ('' !== ($messageErrorArrayErrorMessage = self::validateMessageErrorForArrayConstraintsFromSetMessageError($messageError))) {
            throw new \InvalidArgumentException($messageErrorArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99999)
        if (is_array($messageError) && count($messageError) > 99999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99999', count($messageError)), __LINE__);
        }
        $this->messageError = $messageError;
        return $this;
    }
    /**
     * Add item to messageError value
     * @throws \InvalidArgumentException
     * @param \StructType\MessageError $item
     * @return \StructType\AckErrorApplication
     */
    public function addToMessageError(\StructType\MessageError $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MessageError) {
            throw new \InvalidArgumentException(sprintf('The messageError property can only contain items of type \StructType\MessageError, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99999)
        if (is_array($this->messageError) && count($this->messageError) >= 99999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99999', count($this->messageError)), __LINE__);
        }
        $this->messageError[] = $item;
        return $this;
    }
    /**
     * Get contentVersion value
     * @return anySimpleType|null
     */
    public function getContentVersion()
    {
        return $this->contentVersion;
    }
    /**
     * Set contentVersion value
     * @param anySimpleType $contentVersion
     * @return \StructType\AckErrorApplication
     */
    public function setContentVersion(anySimpleType $contentVersion = null)
    {
        $this->contentVersion = $contentVersion;
        return $this;
    }
    /**
     * Get creationDate value
     * @return anySimpleType|null
     */
    public function getCreationDate()
    {
        return $this->creationDate;
    }
    /**
     * Set creationDate value
     * @param anySimpleType $creationDate
     * @return \StructType\AckErrorApplication
     */
    public function setCreationDate(anySimpleType $creationDate = null)
    {
        $this->creationDate = $creationDate;
        return $this;
    }
    /**
     * Get documentStatus value
     * @return string|null
     */
    public function getDocumentStatus()
    {
        return $this->documentStatus;
    }
    /**
     * Set documentStatus value
     * @param string $documentStatus
     * @return \StructType\AckErrorApplication
     */
    public function setDocumentStatus($documentStatus = null)
    {
        // validation for constraint: string
        if (!is_null($documentStatus) && !is_string($documentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentStatus, true), gettype($documentStatus)), __LINE__);
        }
        $this->documentStatus = $documentStatus;
        return $this;
    }
    /**
     * Get documentStructureVersion value
     * @return anySimpleType|null
     */
    public function getDocumentStructureVersion()
    {
        return $this->documentStructureVersion;
    }
    /**
     * Set documentStructureVersion value
     * @param anySimpleType $documentStructureVersion
     * @return \StructType\AckErrorApplication
     */
    public function setDocumentStructureVersion(anySimpleType $documentStructureVersion = null)
    {
        $this->documentStructureVersion = $documentStructureVersion;
        return $this;
    }
}
