<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named setDigitalInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SET_DIGITAL_INVOICE_REQUEST $parameters
     * @return \StructType\SET_DIGITAL_INVOICE_RESPONSE|bool
     */
    public function setDigitalInvoice(\StructType\SET_DIGITAL_INVOICE_REQUEST $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setDigitalInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SET_DIGITAL_INVOICE_RESPONSE
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
