<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getIntegrationNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_INTEGRATION_NUMBER_REQUEST $parameters
     * @return \StructType\GET_INTEGRATION_NUMBER_RESPONSE|bool
     */
    public function getIntegrationNumber(\StructType\GET_INTEGRATION_NUMBER_REQUEST $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getIntegrationNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReceiptNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_RECEIPT_NUMBER_REQUEST $parameters
     * @return \StructType\GET_RECEIPT_NUMBER_RESPONSE|bool
     */
    public function getReceiptNumber(\StructType\GET_RECEIPT_NUMBER_REQUEST $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getReceiptNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMessage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MESSAGE_REQUEST $parameters
     * @return \StructType\MESSAGE_REPLY|bool
     */
    public function getMessage(\StructType\MESSAGE_REQUEST $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSheetDifferences
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_SHEET_DIFFERENCES_REQUEST $parameters
     * @return \StructType\GET_SHEET_DIFFERENCES_RESPONSE|bool
     */
    public function getSheetDifferences(\StructType\GET_SHEET_DIFFERENCES_REQUEST $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSheetDifferences($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_INTEGRATION_NUMBER_RESPONSE|\StructType\GET_RECEIPT_NUMBER_RESPONSE|\StructType\GET_SHEET_DIFFERENCES_RESPONSE|\StructType\MESSAGE_REPLY
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
