<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsDespachoPaqueteria StructType
 * @subpackage Structs
 */
class ClsDespachoPaqueteria extends AbstractStructBase
{
    /**
     * The IDDespacho
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IDDespacho;
    /**
     * The FechaHoraLote
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FechaHoraLote;
    /**
     * The FechaHoraRecepcion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FechaHoraRecepcion;
    /**
     * The FechaDespacho
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FechaDespacho;
    /**
     * The IDClienteRemitente
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IDClienteRemitente;
    /**
     * The IDCiudadCliente
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IDCiudadCliente;
    /**
     * The IDSucursalRemitente
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IDSucursalRemitente;
    /**
     * The CodigoCuentaRemitente
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CodigoCuentaRemitente;
    /**
     * The IDTipoIdentificacionRte
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IDTipoIdentificacionRte;
    /**
     * The IDOrigen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IDOrigen;
    /**
     * The IDCDOrigen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IDCDOrigen;
    /**
     * The IDTipoIdentificacionDrio
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IDTipoIdentificacionDrio;
    /**
     * The IDDestino
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IDDestino;
    /**
     * The IDCDDestino
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IDCDDestino;
    /**
     * The TotalUnidades
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TotalUnidades;
    /**
     * The TotalPeso
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalPeso;
    /**
     * The TotalPesoFacturado
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalPesoFacturado;
    /**
     * The TotalValorMercancia
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalValorMercancia;
    /**
     * The IDEstadoDespacho
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IDEstadoDespacho;
    /**
     * The FechaHoraCreacion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FechaHoraCreacion;
    /**
     * The FechaHoraUltimaModificacion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FechaHoraUltimaModificacion;
    /**
     * The FechaHoraAnulacion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FechaHoraAnulacion;
    /**
     * The FechaDocumentoReferencia
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FechaDocumentoReferencia;
    /**
     * The DocumentosDevolver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DocumentosDevolver;
    /**
     * The DocumentosEntregar
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DocumentosEntregar;
    /**
     * The EsEntregaBodega
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EsEntregaBodega;
    /**
     * The CodigoLote
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoLote;
    /**
     * The NombreRemitente
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NombreRemitente;
    /**
     * The NumeroIdentificacionRte
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroIdentificacionRte;
    /**
     * The TelefonoRte
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TelefonoRte;
    /**
     * The DireccionRte
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DireccionRte;
    /**
     * The CodigoDaneOrigen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoDaneOrigen;
    /**
     * The NombreDestinatario
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NombreDestinatario;
    /**
     * The NumeroIdentificacionDrio
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroIdentificacionDrio;
    /**
     * The TelefonoDrio
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TelefonoDrio;
    /**
     * The DireccionDrio
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DireccionDrio;
    /**
     * The CodigoDaneDestino
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoDaneDestino;
    /**
     * The BarrioDrio
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BarrioDrio;
    /**
     * The TipoServicioTCC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoServicioTCC;
    /**
     * The Comentarios
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comentarios;
    /**
     * The NumeroRemesa
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroRemesa;
    /**
     * The UsuarioCreacion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UsuarioCreacion;
    /**
     * The UsuarioUltimaModificacion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UsuarioUltimaModificacion;
    /**
     * The ComentarioAnulacion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ComentarioAnulacion;
    /**
     * The UsuarioAnulacion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UsuarioAnulacion;
    /**
     * The TipoDocumentoReferencia
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoDocumentoReferencia;
    /**
     * The NumeroDocumentoReferencia
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroDocumentoReferencia;
    /**
     * The CentroCosto
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CentroCosto;
    /**
     * The CiudadOrigen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CiudadOrigen;
    /**
     * The DepartamentoOrigen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepartamentoOrigen;
    /**
     * The CiudadDestino
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CiudadDestino;
    /**
     * The DepartamentoDestino
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepartamentoDestino;
    /**
     * The detDespacho
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfClsDespachoPaqueteriaDetalle
     */
    public $detDespacho;
    /**
     * Constructor method for clsDespachoPaqueteria
     * @uses ClsDespachoPaqueteria::setIDDespacho()
     * @uses ClsDespachoPaqueteria::setFechaHoraLote()
     * @uses ClsDespachoPaqueteria::setFechaHoraRecepcion()
     * @uses ClsDespachoPaqueteria::setFechaDespacho()
     * @uses ClsDespachoPaqueteria::setIDClienteRemitente()
     * @uses ClsDespachoPaqueteria::setIDCiudadCliente()
     * @uses ClsDespachoPaqueteria::setIDSucursalRemitente()
     * @uses ClsDespachoPaqueteria::setCodigoCuentaRemitente()
     * @uses ClsDespachoPaqueteria::setIDTipoIdentificacionRte()
     * @uses ClsDespachoPaqueteria::setIDOrigen()
     * @uses ClsDespachoPaqueteria::setIDCDOrigen()
     * @uses ClsDespachoPaqueteria::setIDTipoIdentificacionDrio()
     * @uses ClsDespachoPaqueteria::setIDDestino()
     * @uses ClsDespachoPaqueteria::setIDCDDestino()
     * @uses ClsDespachoPaqueteria::setTotalUnidades()
     * @uses ClsDespachoPaqueteria::setTotalPeso()
     * @uses ClsDespachoPaqueteria::setTotalPesoFacturado()
     * @uses ClsDespachoPaqueteria::setTotalValorMercancia()
     * @uses ClsDespachoPaqueteria::setIDEstadoDespacho()
     * @uses ClsDespachoPaqueteria::setFechaHoraCreacion()
     * @uses ClsDespachoPaqueteria::setFechaHoraUltimaModificacion()
     * @uses ClsDespachoPaqueteria::setFechaHoraAnulacion()
     * @uses ClsDespachoPaqueteria::setFechaDocumentoReferencia()
     * @uses ClsDespachoPaqueteria::setDocumentosDevolver()
     * @uses ClsDespachoPaqueteria::setDocumentosEntregar()
     * @uses ClsDespachoPaqueteria::setEsEntregaBodega()
     * @uses ClsDespachoPaqueteria::setCodigoLote()
     * @uses ClsDespachoPaqueteria::setNombreRemitente()
     * @uses ClsDespachoPaqueteria::setNumeroIdentificacionRte()
     * @uses ClsDespachoPaqueteria::setTelefonoRte()
     * @uses ClsDespachoPaqueteria::setDireccionRte()
     * @uses ClsDespachoPaqueteria::setCodigoDaneOrigen()
     * @uses ClsDespachoPaqueteria::setNombreDestinatario()
     * @uses ClsDespachoPaqueteria::setNumeroIdentificacionDrio()
     * @uses ClsDespachoPaqueteria::setTelefonoDrio()
     * @uses ClsDespachoPaqueteria::setDireccionDrio()
     * @uses ClsDespachoPaqueteria::setCodigoDaneDestino()
     * @uses ClsDespachoPaqueteria::setBarrioDrio()
     * @uses ClsDespachoPaqueteria::setTipoServicioTCC()
     * @uses ClsDespachoPaqueteria::setComentarios()
     * @uses ClsDespachoPaqueteria::setNumeroRemesa()
     * @uses ClsDespachoPaqueteria::setUsuarioCreacion()
     * @uses ClsDespachoPaqueteria::setUsuarioUltimaModificacion()
     * @uses ClsDespachoPaqueteria::setComentarioAnulacion()
     * @uses ClsDespachoPaqueteria::setUsuarioAnulacion()
     * @uses ClsDespachoPaqueteria::setTipoDocumentoReferencia()
     * @uses ClsDespachoPaqueteria::setNumeroDocumentoReferencia()
     * @uses ClsDespachoPaqueteria::setCentroCosto()
     * @uses ClsDespachoPaqueteria::setCiudadOrigen()
     * @uses ClsDespachoPaqueteria::setDepartamentoOrigen()
     * @uses ClsDespachoPaqueteria::setCiudadDestino()
     * @uses ClsDespachoPaqueteria::setDepartamentoDestino()
     * @uses ClsDespachoPaqueteria::setDetDespacho()
     * @param int $iDDespacho
     * @param string $fechaHoraLote
     * @param string $fechaHoraRecepcion
     * @param string $fechaDespacho
     * @param int $iDClienteRemitente
     * @param int $iDCiudadCliente
     * @param int $iDSucursalRemitente
     * @param int $codigoCuentaRemitente
     * @param int $iDTipoIdentificacionRte
     * @param int $iDOrigen
     * @param int $iDCDOrigen
     * @param int $iDTipoIdentificacionDrio
     * @param int $iDDestino
     * @param int $iDCDDestino
     * @param int $totalUnidades
     * @param float $totalPeso
     * @param float $totalPesoFacturado
     * @param float $totalValorMercancia
     * @param int $iDEstadoDespacho
     * @param string $fechaHoraCreacion
     * @param string $fechaHoraUltimaModificacion
     * @param string $fechaHoraAnulacion
     * @param string $fechaDocumentoReferencia
     * @param int $documentosDevolver
     * @param int $documentosEntregar
     * @param bool $esEntregaBodega
     * @param string $codigoLote
     * @param string $nombreRemitente
     * @param string $numeroIdentificacionRte
     * @param string $telefonoRte
     * @param string $direccionRte
     * @param string $codigoDaneOrigen
     * @param string $nombreDestinatario
     * @param string $numeroIdentificacionDrio
     * @param string $telefonoDrio
     * @param string $direccionDrio
     * @param string $codigoDaneDestino
     * @param string $barrioDrio
     * @param string $tipoServicioTCC
     * @param string $comentarios
     * @param string $numeroRemesa
     * @param string $usuarioCreacion
     * @param string $usuarioUltimaModificacion
     * @param string $comentarioAnulacion
     * @param string $usuarioAnulacion
     * @param string $tipoDocumentoReferencia
     * @param string $numeroDocumentoReferencia
     * @param string $centroCosto
     * @param string $ciudadOrigen
     * @param string $departamentoOrigen
     * @param string $ciudadDestino
     * @param string $departamentoDestino
     * @param \ArrayType\ArrayOfClsDespachoPaqueteriaDetalle $detDespacho
     */
    public function __construct($iDDespacho = null, $fechaHoraLote = null, $fechaHoraRecepcion = null, $fechaDespacho = null, $iDClienteRemitente = null, $iDCiudadCliente = null, $iDSucursalRemitente = null, $codigoCuentaRemitente = null, $iDTipoIdentificacionRte = null, $iDOrigen = null, $iDCDOrigen = null, $iDTipoIdentificacionDrio = null, $iDDestino = null, $iDCDDestino = null, $totalUnidades = null, $totalPeso = null, $totalPesoFacturado = null, $totalValorMercancia = null, $iDEstadoDespacho = null, $fechaHoraCreacion = null, $fechaHoraUltimaModificacion = null, $fechaHoraAnulacion = null, $fechaDocumentoReferencia = null, $documentosDevolver = null, $documentosEntregar = null, $esEntregaBodega = null, $codigoLote = null, $nombreRemitente = null, $numeroIdentificacionRte = null, $telefonoRte = null, $direccionRte = null, $codigoDaneOrigen = null, $nombreDestinatario = null, $numeroIdentificacionDrio = null, $telefonoDrio = null, $direccionDrio = null, $codigoDaneDestino = null, $barrioDrio = null, $tipoServicioTCC = null, $comentarios = null, $numeroRemesa = null, $usuarioCreacion = null, $usuarioUltimaModificacion = null, $comentarioAnulacion = null, $usuarioAnulacion = null, $tipoDocumentoReferencia = null, $numeroDocumentoReferencia = null, $centroCosto = null, $ciudadOrigen = null, $departamentoOrigen = null, $ciudadDestino = null, $departamentoDestino = null, \ArrayType\ArrayOfClsDespachoPaqueteriaDetalle $detDespacho = null)
    {
        $this
            ->setIDDespacho($iDDespacho)
            ->setFechaHoraLote($fechaHoraLote)
            ->setFechaHoraRecepcion($fechaHoraRecepcion)
            ->setFechaDespacho($fechaDespacho)
            ->setIDClienteRemitente($iDClienteRemitente)
            ->setIDCiudadCliente($iDCiudadCliente)
            ->setIDSucursalRemitente($iDSucursalRemitente)
            ->setCodigoCuentaRemitente($codigoCuentaRemitente)
            ->setIDTipoIdentificacionRte($iDTipoIdentificacionRte)
            ->setIDOrigen($iDOrigen)
            ->setIDCDOrigen($iDCDOrigen)
            ->setIDTipoIdentificacionDrio($iDTipoIdentificacionDrio)
            ->setIDDestino($iDDestino)
            ->setIDCDDestino($iDCDDestino)
            ->setTotalUnidades($totalUnidades)
            ->setTotalPeso($totalPeso)
            ->setTotalPesoFacturado($totalPesoFacturado)
            ->setTotalValorMercancia($totalValorMercancia)
            ->setIDEstadoDespacho($iDEstadoDespacho)
            ->setFechaHoraCreacion($fechaHoraCreacion)
            ->setFechaHoraUltimaModificacion($fechaHoraUltimaModificacion)
            ->setFechaHoraAnulacion($fechaHoraAnulacion)
            ->setFechaDocumentoReferencia($fechaDocumentoReferencia)
            ->setDocumentosDevolver($documentosDevolver)
            ->setDocumentosEntregar($documentosEntregar)
            ->setEsEntregaBodega($esEntregaBodega)
            ->setCodigoLote($codigoLote)
            ->setNombreRemitente($nombreRemitente)
            ->setNumeroIdentificacionRte($numeroIdentificacionRte)
            ->setTelefonoRte($telefonoRte)
            ->setDireccionRte($direccionRte)
            ->setCodigoDaneOrigen($codigoDaneOrigen)
            ->setNombreDestinatario($nombreDestinatario)
            ->setNumeroIdentificacionDrio($numeroIdentificacionDrio)
            ->setTelefonoDrio($telefonoDrio)
            ->setDireccionDrio($direccionDrio)
            ->setCodigoDaneDestino($codigoDaneDestino)
            ->setBarrioDrio($barrioDrio)
            ->setTipoServicioTCC($tipoServicioTCC)
            ->setComentarios($comentarios)
            ->setNumeroRemesa($numeroRemesa)
            ->setUsuarioCreacion($usuarioCreacion)
            ->setUsuarioUltimaModificacion($usuarioUltimaModificacion)
            ->setComentarioAnulacion($comentarioAnulacion)
            ->setUsuarioAnulacion($usuarioAnulacion)
            ->setTipoDocumentoReferencia($tipoDocumentoReferencia)
            ->setNumeroDocumentoReferencia($numeroDocumentoReferencia)
            ->setCentroCosto($centroCosto)
            ->setCiudadOrigen($ciudadOrigen)
            ->setDepartamentoOrigen($departamentoOrigen)
            ->setCiudadDestino($ciudadDestino)
            ->setDepartamentoDestino($departamentoDestino)
            ->setDetDespacho($detDespacho);
    }
    /**
     * Get IDDespacho value
     * @return int
     */
    public function getIDDespacho()
    {
        return $this->IDDespacho;
    }
    /**
     * Set IDDespacho value
     * @param int $iDDespacho
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setIDDespacho($iDDespacho = null)
    {
        // validation for constraint: int
        if (!is_null($iDDespacho) && !is_numeric($iDDespacho)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iDDespacho)), __LINE__);
        }
        $this->IDDespacho = $iDDespacho;
        return $this;
    }
    /**
     * Get FechaHoraLote value
     * @return string
     */
    public function getFechaHoraLote()
    {
        return $this->FechaHoraLote;
    }
    /**
     * Set FechaHoraLote value
     * @param string $fechaHoraLote
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setFechaHoraLote($fechaHoraLote = null)
    {
        // validation for constraint: string
        if (!is_null($fechaHoraLote) && !is_string($fechaHoraLote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaHoraLote)), __LINE__);
        }
        $this->FechaHoraLote = $fechaHoraLote;
        return $this;
    }
    /**
     * Get FechaHoraRecepcion value
     * @return string
     */
    public function getFechaHoraRecepcion()
    {
        return $this->FechaHoraRecepcion;
    }
    /**
     * Set FechaHoraRecepcion value
     * @param string $fechaHoraRecepcion
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setFechaHoraRecepcion($fechaHoraRecepcion = null)
    {
        // validation for constraint: string
        if (!is_null($fechaHoraRecepcion) && !is_string($fechaHoraRecepcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaHoraRecepcion)), __LINE__);
        }
        $this->FechaHoraRecepcion = $fechaHoraRecepcion;
        return $this;
    }
    /**
     * Get FechaDespacho value
     * @return string
     */
    public function getFechaDespacho()
    {
        return $this->FechaDespacho;
    }
    /**
     * Set FechaDespacho value
     * @param string $fechaDespacho
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setFechaDespacho($fechaDespacho = null)
    {
        // validation for constraint: string
        if (!is_null($fechaDespacho) && !is_string($fechaDespacho)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaDespacho)), __LINE__);
        }
        $this->FechaDespacho = $fechaDespacho;
        return $this;
    }
    /**
     * Get IDClienteRemitente value
     * @return int
     */
    public function getIDClienteRemitente()
    {
        return $this->IDClienteRemitente;
    }
    /**
     * Set IDClienteRemitente value
     * @param int $iDClienteRemitente
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setIDClienteRemitente($iDClienteRemitente = null)
    {
        // validation for constraint: int
        if (!is_null($iDClienteRemitente) && !is_numeric($iDClienteRemitente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iDClienteRemitente)), __LINE__);
        }
        $this->IDClienteRemitente = $iDClienteRemitente;
        return $this;
    }
    /**
     * Get IDCiudadCliente value
     * @return int
     */
    public function getIDCiudadCliente()
    {
        return $this->IDCiudadCliente;
    }
    /**
     * Set IDCiudadCliente value
     * @param int $iDCiudadCliente
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setIDCiudadCliente($iDCiudadCliente = null)
    {
        // validation for constraint: int
        if (!is_null($iDCiudadCliente) && !is_numeric($iDCiudadCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iDCiudadCliente)), __LINE__);
        }
        $this->IDCiudadCliente = $iDCiudadCliente;
        return $this;
    }
    /**
     * Get IDSucursalRemitente value
     * @return int
     */
    public function getIDSucursalRemitente()
    {
        return $this->IDSucursalRemitente;
    }
    /**
     * Set IDSucursalRemitente value
     * @param int $iDSucursalRemitente
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setIDSucursalRemitente($iDSucursalRemitente = null)
    {
        // validation for constraint: int
        if (!is_null($iDSucursalRemitente) && !is_numeric($iDSucursalRemitente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iDSucursalRemitente)), __LINE__);
        }
        $this->IDSucursalRemitente = $iDSucursalRemitente;
        return $this;
    }
    /**
     * Get CodigoCuentaRemitente value
     * @return int
     */
    public function getCodigoCuentaRemitente()
    {
        return $this->CodigoCuentaRemitente;
    }
    /**
     * Set CodigoCuentaRemitente value
     * @param int $codigoCuentaRemitente
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setCodigoCuentaRemitente($codigoCuentaRemitente = null)
    {
        // validation for constraint: int
        if (!is_null($codigoCuentaRemitente) && !is_numeric($codigoCuentaRemitente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoCuentaRemitente)), __LINE__);
        }
        $this->CodigoCuentaRemitente = $codigoCuentaRemitente;
        return $this;
    }
    /**
     * Get IDTipoIdentificacionRte value
     * @return int
     */
    public function getIDTipoIdentificacionRte()
    {
        return $this->IDTipoIdentificacionRte;
    }
    /**
     * Set IDTipoIdentificacionRte value
     * @param int $iDTipoIdentificacionRte
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setIDTipoIdentificacionRte($iDTipoIdentificacionRte = null)
    {
        // validation for constraint: int
        if (!is_null($iDTipoIdentificacionRte) && !is_numeric($iDTipoIdentificacionRte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iDTipoIdentificacionRte)), __LINE__);
        }
        $this->IDTipoIdentificacionRte = $iDTipoIdentificacionRte;
        return $this;
    }
    /**
     * Get IDOrigen value
     * @return int
     */
    public function getIDOrigen()
    {
        return $this->IDOrigen;
    }
    /**
     * Set IDOrigen value
     * @param int $iDOrigen
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setIDOrigen($iDOrigen = null)
    {
        // validation for constraint: int
        if (!is_null($iDOrigen) && !is_numeric($iDOrigen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iDOrigen)), __LINE__);
        }
        $this->IDOrigen = $iDOrigen;
        return $this;
    }
    /**
     * Get IDCDOrigen value
     * @return int
     */
    public function getIDCDOrigen()
    {
        return $this->IDCDOrigen;
    }
    /**
     * Set IDCDOrigen value
     * @param int $iDCDOrigen
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setIDCDOrigen($iDCDOrigen = null)
    {
        // validation for constraint: int
        if (!is_null($iDCDOrigen) && !is_numeric($iDCDOrigen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iDCDOrigen)), __LINE__);
        }
        $this->IDCDOrigen = $iDCDOrigen;
        return $this;
    }
    /**
     * Get IDTipoIdentificacionDrio value
     * @return int
     */
    public function getIDTipoIdentificacionDrio()
    {
        return $this->IDTipoIdentificacionDrio;
    }
    /**
     * Set IDTipoIdentificacionDrio value
     * @param int $iDTipoIdentificacionDrio
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setIDTipoIdentificacionDrio($iDTipoIdentificacionDrio = null)
    {
        // validation for constraint: int
        if (!is_null($iDTipoIdentificacionDrio) && !is_numeric($iDTipoIdentificacionDrio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iDTipoIdentificacionDrio)), __LINE__);
        }
        $this->IDTipoIdentificacionDrio = $iDTipoIdentificacionDrio;
        return $this;
    }
    /**
     * Get IDDestino value
     * @return int
     */
    public function getIDDestino()
    {
        return $this->IDDestino;
    }
    /**
     * Set IDDestino value
     * @param int $iDDestino
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setIDDestino($iDDestino = null)
    {
        // validation for constraint: int
        if (!is_null($iDDestino) && !is_numeric($iDDestino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iDDestino)), __LINE__);
        }
        $this->IDDestino = $iDDestino;
        return $this;
    }
    /**
     * Get IDCDDestino value
     * @return int
     */
    public function getIDCDDestino()
    {
        return $this->IDCDDestino;
    }
    /**
     * Set IDCDDestino value
     * @param int $iDCDDestino
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setIDCDDestino($iDCDDestino = null)
    {
        // validation for constraint: int
        if (!is_null($iDCDDestino) && !is_numeric($iDCDDestino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iDCDDestino)), __LINE__);
        }
        $this->IDCDDestino = $iDCDDestino;
        return $this;
    }
    /**
     * Get TotalUnidades value
     * @return int
     */
    public function getTotalUnidades()
    {
        return $this->TotalUnidades;
    }
    /**
     * Set TotalUnidades value
     * @param int $totalUnidades
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setTotalUnidades($totalUnidades = null)
    {
        // validation for constraint: int
        if (!is_null($totalUnidades) && !is_numeric($totalUnidades)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalUnidades)), __LINE__);
        }
        $this->TotalUnidades = $totalUnidades;
        return $this;
    }
    /**
     * Get TotalPeso value
     * @return float
     */
    public function getTotalPeso()
    {
        return $this->TotalPeso;
    }
    /**
     * Set TotalPeso value
     * @param float $totalPeso
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setTotalPeso($totalPeso = null)
    {
        $this->TotalPeso = $totalPeso;
        return $this;
    }
    /**
     * Get TotalPesoFacturado value
     * @return float
     */
    public function getTotalPesoFacturado()
    {
        return $this->TotalPesoFacturado;
    }
    /**
     * Set TotalPesoFacturado value
     * @param float $totalPesoFacturado
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setTotalPesoFacturado($totalPesoFacturado = null)
    {
        $this->TotalPesoFacturado = $totalPesoFacturado;
        return $this;
    }
    /**
     * Get TotalValorMercancia value
     * @return float
     */
    public function getTotalValorMercancia()
    {
        return $this->TotalValorMercancia;
    }
    /**
     * Set TotalValorMercancia value
     * @param float $totalValorMercancia
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setTotalValorMercancia($totalValorMercancia = null)
    {
        $this->TotalValorMercancia = $totalValorMercancia;
        return $this;
    }
    /**
     * Get IDEstadoDespacho value
     * @return int
     */
    public function getIDEstadoDespacho()
    {
        return $this->IDEstadoDespacho;
    }
    /**
     * Set IDEstadoDespacho value
     * @param int $iDEstadoDespacho
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setIDEstadoDespacho($iDEstadoDespacho = null)
    {
        // validation for constraint: int
        if (!is_null($iDEstadoDespacho) && !is_numeric($iDEstadoDespacho)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iDEstadoDespacho)), __LINE__);
        }
        $this->IDEstadoDespacho = $iDEstadoDespacho;
        return $this;
    }
    /**
     * Get FechaHoraCreacion value
     * @return string
     */
    public function getFechaHoraCreacion()
    {
        return $this->FechaHoraCreacion;
    }
    /**
     * Set FechaHoraCreacion value
     * @param string $fechaHoraCreacion
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setFechaHoraCreacion($fechaHoraCreacion = null)
    {
        // validation for constraint: string
        if (!is_null($fechaHoraCreacion) && !is_string($fechaHoraCreacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaHoraCreacion)), __LINE__);
        }
        $this->FechaHoraCreacion = $fechaHoraCreacion;
        return $this;
    }
    /**
     * Get FechaHoraUltimaModificacion value
     * @return string
     */
    public function getFechaHoraUltimaModificacion()
    {
        return $this->FechaHoraUltimaModificacion;
    }
    /**
     * Set FechaHoraUltimaModificacion value
     * @param string $fechaHoraUltimaModificacion
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setFechaHoraUltimaModificacion($fechaHoraUltimaModificacion = null)
    {
        // validation for constraint: string
        if (!is_null($fechaHoraUltimaModificacion) && !is_string($fechaHoraUltimaModificacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaHoraUltimaModificacion)), __LINE__);
        }
        $this->FechaHoraUltimaModificacion = $fechaHoraUltimaModificacion;
        return $this;
    }
    /**
     * Get FechaHoraAnulacion value
     * @return string
     */
    public function getFechaHoraAnulacion()
    {
        return $this->FechaHoraAnulacion;
    }
    /**
     * Set FechaHoraAnulacion value
     * @param string $fechaHoraAnulacion
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setFechaHoraAnulacion($fechaHoraAnulacion = null)
    {
        // validation for constraint: string
        if (!is_null($fechaHoraAnulacion) && !is_string($fechaHoraAnulacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaHoraAnulacion)), __LINE__);
        }
        $this->FechaHoraAnulacion = $fechaHoraAnulacion;
        return $this;
    }
    /**
     * Get FechaDocumentoReferencia value
     * @return string
     */
    public function getFechaDocumentoReferencia()
    {
        return $this->FechaDocumentoReferencia;
    }
    /**
     * Set FechaDocumentoReferencia value
     * @param string $fechaDocumentoReferencia
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setFechaDocumentoReferencia($fechaDocumentoReferencia = null)
    {
        // validation for constraint: string
        if (!is_null($fechaDocumentoReferencia) && !is_string($fechaDocumentoReferencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaDocumentoReferencia)), __LINE__);
        }
        $this->FechaDocumentoReferencia = $fechaDocumentoReferencia;
        return $this;
    }
    /**
     * Get DocumentosDevolver value
     * @return int
     */
    public function getDocumentosDevolver()
    {
        return $this->DocumentosDevolver;
    }
    /**
     * Set DocumentosDevolver value
     * @param int $documentosDevolver
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setDocumentosDevolver($documentosDevolver = null)
    {
        // validation for constraint: int
        if (!is_null($documentosDevolver) && !is_numeric($documentosDevolver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($documentosDevolver)), __LINE__);
        }
        $this->DocumentosDevolver = $documentosDevolver;
        return $this;
    }
    /**
     * Get DocumentosEntregar value
     * @return int
     */
    public function getDocumentosEntregar()
    {
        return $this->DocumentosEntregar;
    }
    /**
     * Set DocumentosEntregar value
     * @param int $documentosEntregar
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setDocumentosEntregar($documentosEntregar = null)
    {
        // validation for constraint: int
        if (!is_null($documentosEntregar) && !is_numeric($documentosEntregar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($documentosEntregar)), __LINE__);
        }
        $this->DocumentosEntregar = $documentosEntregar;
        return $this;
    }
    /**
     * Get EsEntregaBodega value
     * @return bool
     */
    public function getEsEntregaBodega()
    {
        return $this->EsEntregaBodega;
    }
    /**
     * Set EsEntregaBodega value
     * @param bool $esEntregaBodega
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setEsEntregaBodega($esEntregaBodega = null)
    {
        $this->EsEntregaBodega = $esEntregaBodega;
        return $this;
    }
    /**
     * Get CodigoLote value
     * @return string|null
     */
    public function getCodigoLote()
    {
        return $this->CodigoLote;
    }
    /**
     * Set CodigoLote value
     * @param string $codigoLote
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setCodigoLote($codigoLote = null)
    {
        // validation for constraint: string
        if (!is_null($codigoLote) && !is_string($codigoLote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoLote)), __LINE__);
        }
        $this->CodigoLote = $codigoLote;
        return $this;
    }
    /**
     * Get NombreRemitente value
     * @return string|null
     */
    public function getNombreRemitente()
    {
        return $this->NombreRemitente;
    }
    /**
     * Set NombreRemitente value
     * @param string $nombreRemitente
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setNombreRemitente($nombreRemitente = null)
    {
        // validation for constraint: string
        if (!is_null($nombreRemitente) && !is_string($nombreRemitente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nombreRemitente)), __LINE__);
        }
        $this->NombreRemitente = $nombreRemitente;
        return $this;
    }
    /**
     * Get NumeroIdentificacionRte value
     * @return string|null
     */
    public function getNumeroIdentificacionRte()
    {
        return $this->NumeroIdentificacionRte;
    }
    /**
     * Set NumeroIdentificacionRte value
     * @param string $numeroIdentificacionRte
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setNumeroIdentificacionRte($numeroIdentificacionRte = null)
    {
        // validation for constraint: string
        if (!is_null($numeroIdentificacionRte) && !is_string($numeroIdentificacionRte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numeroIdentificacionRte)), __LINE__);
        }
        $this->NumeroIdentificacionRte = $numeroIdentificacionRte;
        return $this;
    }
    /**
     * Get TelefonoRte value
     * @return string|null
     */
    public function getTelefonoRte()
    {
        return $this->TelefonoRte;
    }
    /**
     * Set TelefonoRte value
     * @param string $telefonoRte
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setTelefonoRte($telefonoRte = null)
    {
        // validation for constraint: string
        if (!is_null($telefonoRte) && !is_string($telefonoRte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telefonoRte)), __LINE__);
        }
        $this->TelefonoRte = $telefonoRte;
        return $this;
    }
    /**
     * Get DireccionRte value
     * @return string|null
     */
    public function getDireccionRte()
    {
        return $this->DireccionRte;
    }
    /**
     * Set DireccionRte value
     * @param string $direccionRte
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setDireccionRte($direccionRte = null)
    {
        // validation for constraint: string
        if (!is_null($direccionRte) && !is_string($direccionRte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($direccionRte)), __LINE__);
        }
        $this->DireccionRte = $direccionRte;
        return $this;
    }
    /**
     * Get CodigoDaneOrigen value
     * @return string|null
     */
    public function getCodigoDaneOrigen()
    {
        return $this->CodigoDaneOrigen;
    }
    /**
     * Set CodigoDaneOrigen value
     * @param string $codigoDaneOrigen
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setCodigoDaneOrigen($codigoDaneOrigen = null)
    {
        // validation for constraint: string
        if (!is_null($codigoDaneOrigen) && !is_string($codigoDaneOrigen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoDaneOrigen)), __LINE__);
        }
        $this->CodigoDaneOrigen = $codigoDaneOrigen;
        return $this;
    }
    /**
     * Get NombreDestinatario value
     * @return string|null
     */
    public function getNombreDestinatario()
    {
        return $this->NombreDestinatario;
    }
    /**
     * Set NombreDestinatario value
     * @param string $nombreDestinatario
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setNombreDestinatario($nombreDestinatario = null)
    {
        // validation for constraint: string
        if (!is_null($nombreDestinatario) && !is_string($nombreDestinatario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nombreDestinatario)), __LINE__);
        }
        $this->NombreDestinatario = $nombreDestinatario;
        return $this;
    }
    /**
     * Get NumeroIdentificacionDrio value
     * @return string|null
     */
    public function getNumeroIdentificacionDrio()
    {
        return $this->NumeroIdentificacionDrio;
    }
    /**
     * Set NumeroIdentificacionDrio value
     * @param string $numeroIdentificacionDrio
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setNumeroIdentificacionDrio($numeroIdentificacionDrio = null)
    {
        // validation for constraint: string
        if (!is_null($numeroIdentificacionDrio) && !is_string($numeroIdentificacionDrio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numeroIdentificacionDrio)), __LINE__);
        }
        $this->NumeroIdentificacionDrio = $numeroIdentificacionDrio;
        return $this;
    }
    /**
     * Get TelefonoDrio value
     * @return string|null
     */
    public function getTelefonoDrio()
    {
        return $this->TelefonoDrio;
    }
    /**
     * Set TelefonoDrio value
     * @param string $telefonoDrio
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setTelefonoDrio($telefonoDrio = null)
    {
        // validation for constraint: string
        if (!is_null($telefonoDrio) && !is_string($telefonoDrio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telefonoDrio)), __LINE__);
        }
        $this->TelefonoDrio = $telefonoDrio;
        return $this;
    }
    /**
     * Get DireccionDrio value
     * @return string|null
     */
    public function getDireccionDrio()
    {
        return $this->DireccionDrio;
    }
    /**
     * Set DireccionDrio value
     * @param string $direccionDrio
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setDireccionDrio($direccionDrio = null)
    {
        // validation for constraint: string
        if (!is_null($direccionDrio) && !is_string($direccionDrio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($direccionDrio)), __LINE__);
        }
        $this->DireccionDrio = $direccionDrio;
        return $this;
    }
    /**
     * Get CodigoDaneDestino value
     * @return string|null
     */
    public function getCodigoDaneDestino()
    {
        return $this->CodigoDaneDestino;
    }
    /**
     * Set CodigoDaneDestino value
     * @param string $codigoDaneDestino
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setCodigoDaneDestino($codigoDaneDestino = null)
    {
        // validation for constraint: string
        if (!is_null($codigoDaneDestino) && !is_string($codigoDaneDestino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoDaneDestino)), __LINE__);
        }
        $this->CodigoDaneDestino = $codigoDaneDestino;
        return $this;
    }
    /**
     * Get BarrioDrio value
     * @return string|null
     */
    public function getBarrioDrio()
    {
        return $this->BarrioDrio;
    }
    /**
     * Set BarrioDrio value
     * @param string $barrioDrio
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setBarrioDrio($barrioDrio = null)
    {
        // validation for constraint: string
        if (!is_null($barrioDrio) && !is_string($barrioDrio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barrioDrio)), __LINE__);
        }
        $this->BarrioDrio = $barrioDrio;
        return $this;
    }
    /**
     * Get TipoServicioTCC value
     * @return string|null
     */
    public function getTipoServicioTCC()
    {
        return $this->TipoServicioTCC;
    }
    /**
     * Set TipoServicioTCC value
     * @param string $tipoServicioTCC
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setTipoServicioTCC($tipoServicioTCC = null)
    {
        // validation for constraint: string
        if (!is_null($tipoServicioTCC) && !is_string($tipoServicioTCC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoServicioTCC)), __LINE__);
        }
        $this->TipoServicioTCC = $tipoServicioTCC;
        return $this;
    }
    /**
     * Get Comentarios value
     * @return string|null
     */
    public function getComentarios()
    {
        return $this->Comentarios;
    }
    /**
     * Set Comentarios value
     * @param string $comentarios
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setComentarios($comentarios = null)
    {
        // validation for constraint: string
        if (!is_null($comentarios) && !is_string($comentarios)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comentarios)), __LINE__);
        }
        $this->Comentarios = $comentarios;
        return $this;
    }
    /**
     * Get NumeroRemesa value
     * @return string|null
     */
    public function getNumeroRemesa()
    {
        return $this->NumeroRemesa;
    }
    /**
     * Set NumeroRemesa value
     * @param string $numeroRemesa
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setNumeroRemesa($numeroRemesa = null)
    {
        // validation for constraint: string
        if (!is_null($numeroRemesa) && !is_string($numeroRemesa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numeroRemesa)), __LINE__);
        }
        $this->NumeroRemesa = $numeroRemesa;
        return $this;
    }
    /**
     * Get UsuarioCreacion value
     * @return string|null
     */
    public function getUsuarioCreacion()
    {
        return $this->UsuarioCreacion;
    }
    /**
     * Set UsuarioCreacion value
     * @param string $usuarioCreacion
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setUsuarioCreacion($usuarioCreacion = null)
    {
        // validation for constraint: string
        if (!is_null($usuarioCreacion) && !is_string($usuarioCreacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usuarioCreacion)), __LINE__);
        }
        $this->UsuarioCreacion = $usuarioCreacion;
        return $this;
    }
    /**
     * Get UsuarioUltimaModificacion value
     * @return string|null
     */
    public function getUsuarioUltimaModificacion()
    {
        return $this->UsuarioUltimaModificacion;
    }
    /**
     * Set UsuarioUltimaModificacion value
     * @param string $usuarioUltimaModificacion
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setUsuarioUltimaModificacion($usuarioUltimaModificacion = null)
    {
        // validation for constraint: string
        if (!is_null($usuarioUltimaModificacion) && !is_string($usuarioUltimaModificacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usuarioUltimaModificacion)), __LINE__);
        }
        $this->UsuarioUltimaModificacion = $usuarioUltimaModificacion;
        return $this;
    }
    /**
     * Get ComentarioAnulacion value
     * @return string|null
     */
    public function getComentarioAnulacion()
    {
        return $this->ComentarioAnulacion;
    }
    /**
     * Set ComentarioAnulacion value
     * @param string $comentarioAnulacion
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setComentarioAnulacion($comentarioAnulacion = null)
    {
        // validation for constraint: string
        if (!is_null($comentarioAnulacion) && !is_string($comentarioAnulacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comentarioAnulacion)), __LINE__);
        }
        $this->ComentarioAnulacion = $comentarioAnulacion;
        return $this;
    }
    /**
     * Get UsuarioAnulacion value
     * @return string|null
     */
    public function getUsuarioAnulacion()
    {
        return $this->UsuarioAnulacion;
    }
    /**
     * Set UsuarioAnulacion value
     * @param string $usuarioAnulacion
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setUsuarioAnulacion($usuarioAnulacion = null)
    {
        // validation for constraint: string
        if (!is_null($usuarioAnulacion) && !is_string($usuarioAnulacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usuarioAnulacion)), __LINE__);
        }
        $this->UsuarioAnulacion = $usuarioAnulacion;
        return $this;
    }
    /**
     * Get TipoDocumentoReferencia value
     * @return string|null
     */
    public function getTipoDocumentoReferencia()
    {
        return $this->TipoDocumentoReferencia;
    }
    /**
     * Set TipoDocumentoReferencia value
     * @param string $tipoDocumentoReferencia
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setTipoDocumentoReferencia($tipoDocumentoReferencia = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDocumentoReferencia) && !is_string($tipoDocumentoReferencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoDocumentoReferencia)), __LINE__);
        }
        $this->TipoDocumentoReferencia = $tipoDocumentoReferencia;
        return $this;
    }
    /**
     * Get NumeroDocumentoReferencia value
     * @return string|null
     */
    public function getNumeroDocumentoReferencia()
    {
        return $this->NumeroDocumentoReferencia;
    }
    /**
     * Set NumeroDocumentoReferencia value
     * @param string $numeroDocumentoReferencia
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setNumeroDocumentoReferencia($numeroDocumentoReferencia = null)
    {
        // validation for constraint: string
        if (!is_null($numeroDocumentoReferencia) && !is_string($numeroDocumentoReferencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numeroDocumentoReferencia)), __LINE__);
        }
        $this->NumeroDocumentoReferencia = $numeroDocumentoReferencia;
        return $this;
    }
    /**
     * Get CentroCosto value
     * @return string|null
     */
    public function getCentroCosto()
    {
        return $this->CentroCosto;
    }
    /**
     * Set CentroCosto value
     * @param string $centroCosto
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setCentroCosto($centroCosto = null)
    {
        // validation for constraint: string
        if (!is_null($centroCosto) && !is_string($centroCosto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($centroCosto)), __LINE__);
        }
        $this->CentroCosto = $centroCosto;
        return $this;
    }
    /**
     * Get CiudadOrigen value
     * @return string|null
     */
    public function getCiudadOrigen()
    {
        return $this->CiudadOrigen;
    }
    /**
     * Set CiudadOrigen value
     * @param string $ciudadOrigen
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setCiudadOrigen($ciudadOrigen = null)
    {
        // validation for constraint: string
        if (!is_null($ciudadOrigen) && !is_string($ciudadOrigen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ciudadOrigen)), __LINE__);
        }
        $this->CiudadOrigen = $ciudadOrigen;
        return $this;
    }
    /**
     * Get DepartamentoOrigen value
     * @return string|null
     */
    public function getDepartamentoOrigen()
    {
        return $this->DepartamentoOrigen;
    }
    /**
     * Set DepartamentoOrigen value
     * @param string $departamentoOrigen
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setDepartamentoOrigen($departamentoOrigen = null)
    {
        // validation for constraint: string
        if (!is_null($departamentoOrigen) && !is_string($departamentoOrigen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departamentoOrigen)), __LINE__);
        }
        $this->DepartamentoOrigen = $departamentoOrigen;
        return $this;
    }
    /**
     * Get CiudadDestino value
     * @return string|null
     */
    public function getCiudadDestino()
    {
        return $this->CiudadDestino;
    }
    /**
     * Set CiudadDestino value
     * @param string $ciudadDestino
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setCiudadDestino($ciudadDestino = null)
    {
        // validation for constraint: string
        if (!is_null($ciudadDestino) && !is_string($ciudadDestino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ciudadDestino)), __LINE__);
        }
        $this->CiudadDestino = $ciudadDestino;
        return $this;
    }
    /**
     * Get DepartamentoDestino value
     * @return string|null
     */
    public function getDepartamentoDestino()
    {
        return $this->DepartamentoDestino;
    }
    /**
     * Set DepartamentoDestino value
     * @param string $departamentoDestino
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setDepartamentoDestino($departamentoDestino = null)
    {
        // validation for constraint: string
        if (!is_null($departamentoDestino) && !is_string($departamentoDestino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departamentoDestino)), __LINE__);
        }
        $this->DepartamentoDestino = $departamentoDestino;
        return $this;
    }
    /**
     * Get detDespacho value
     * @return \ArrayType\ArrayOfClsDespachoPaqueteriaDetalle|null
     */
    public function getDetDespacho()
    {
        return $this->detDespacho;
    }
    /**
     * Set detDespacho value
     * @param \ArrayType\ArrayOfClsDespachoPaqueteriaDetalle $detDespacho
     * @return \StructType\ClsDespachoPaqueteria
     */
    public function setDetDespacho(\ArrayType\ArrayOfClsDespachoPaqueteriaDetalle $detDespacho = null)
    {
        $this->detDespacho = $detDespacho;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsDespachoPaqueteria
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
