<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDestinatario ArrayType
 * @subpackage Arrays
 */
class ArrayOfDestinatario extends AbstractStructArrayBase
{
    /**
     * The destinatario
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Destinatario[]
     */
    public $destinatario;
    /**
     * Constructor method for ArrayOfDestinatario
     * @uses ArrayOfDestinatario::setDestinatario()
     * @param \StructType\Destinatario[] $destinatario
     */
    public function __construct(array $destinatario = array())
    {
        $this
            ->setDestinatario($destinatario);
    }
    /**
     * Get destinatario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Destinatario[]|null
     */
    public function getDestinatario()
    {
        return isset($this->destinatario) ? $this->destinatario : null;
    }
    /**
     * Set destinatario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Destinatario[] $destinatario
     * @return \ArrayType\ArrayOfDestinatario
     */
    public function setDestinatario(array $destinatario = array())
    {
        foreach ($destinatario as $arrayOfDestinatarioDestinatarioItem) {
            // validation for constraint: itemType
            if (!$arrayOfDestinatarioDestinatarioItem instanceof \StructType\Destinatario) {
                throw new \InvalidArgumentException(sprintf('The destinatario property can only contain items of \StructType\Destinatario, "%s" given', is_object($arrayOfDestinatarioDestinatarioItem) ? get_class($arrayOfDestinatarioDestinatarioItem) : gettype($arrayOfDestinatarioDestinatarioItem)), __LINE__);
            }
        }
        if (is_null($destinatario) || (is_array($destinatario) && empty($destinatario))) {
            unset($this->destinatario);
        } else {
            $this->destinatario = $destinatario;
        }
        return $this;
    }
    /**
     * Add item to destinatario value
     * @throws \InvalidArgumentException
     * @param \StructType\Destinatario $item
     * @return \ArrayType\ArrayOfDestinatario
     */
    public function addToDestinatario(\StructType\Destinatario $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Destinatario) {
            throw new \InvalidArgumentException(sprintf('The destinatario property can only contain items of \StructType\Destinatario, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->destinatario[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Destinatario|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Destinatario|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Destinatario|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Destinatario|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Destinatario|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string destinatario
     */
    public function getAttributeName()
    {
        return 'destinatario';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDestinatario
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
