<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Grabar ServiceType
 * @subpackage Services
 */
class Grabar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GrabarDespacho
     * Meta informations extracted from the WSDL
     * - documentation: Graba un despacho de Paquetería
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GrabarDespacho $parameters
     * @return \StructType\GrabarDespachoResponse|bool
     */
    public function GrabarDespacho(\StructType\GrabarDespacho $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GrabarDespacho($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GrabarDespacho2
     * Meta informations extracted from the WSDL
     * - documentation: Graba un despacho de Paquetería con el segundo esquema de Despacho
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GrabarDespacho2 $parameters
     * @return \StructType\GrabarDespacho2Response|bool
     */
    public function GrabarDespacho2(\StructType\GrabarDespacho2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GrabarDespacho2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GrabarDespacho3
     * Meta informations extracted from the WSDL
     * - documentation: Graba un despacho de Paquetería
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GrabarDespacho3 $parameters
     * @return \StructType\GrabarDespacho3Response|bool
     */
    public function GrabarDespacho3(\StructType\GrabarDespacho3 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GrabarDespacho3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GrabarDespacho4
     * Meta informations extracted from the WSDL
     * - documentation: Graba un despacho de Paquetería
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GrabarDespacho4 $parameters
     * @return \StructType\GrabarDespacho4Response|bool
     */
    public function GrabarDespacho4(\StructType\GrabarDespacho4 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GrabarDespacho4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GrabarDespacho5
     * Meta informations extracted from the WSDL
     * - documentation: Graba un despacho de Paquetería
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GrabarDespacho5 $parameters
     * @return \StructType\GrabarDespacho5Response|bool
     */
    public function GrabarDespacho5(\StructType\GrabarDespacho5 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GrabarDespacho5($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GrabarDespacho6
     * Meta informations extracted from the WSDL
     * - documentation: Graba los despachos enviado como una relación de envio de Paquetería en modelo Clientes de SION
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GrabarDespacho6 $parameters
     * @return \StructType\GrabarDespacho6Response|bool
     */
    public function GrabarDespacho6(\StructType\GrabarDespacho6 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GrabarDespacho6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GrabarDespacho2Response|\StructType\GrabarDespacho3Response|\StructType\GrabarDespacho4Response|\StructType\GrabarDespacho5Response|\StructType\GrabarDespacho6Response|\StructType\GrabarDespachoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
