<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Anular ServiceType
 * @subpackage Services
 */
class Anular extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AnularDespacho
     * Meta informations extracted from the WSDL
     * - documentation: Anula un despacho. Se debe proporcionar el número de remesa y la cuenta del despacho.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AnularDespacho $parameters
     * @return \StructType\AnularDespachoResponse|bool
     */
    public function AnularDespacho(\StructType\AnularDespacho $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AnularDespacho($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AnularDespachoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
