<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUnidad ArrayType
 * @subpackage Arrays
 */
class ArrayOfUnidad extends AbstractStructArrayBase
{
    /**
     * The unidad
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Unidad[]
     */
    public $unidad;
    /**
     * Constructor method for ArrayOfUnidad
     * @uses ArrayOfUnidad::setUnidad()
     * @param \StructType\Unidad[] $unidad
     */
    public function __construct(array $unidad = array())
    {
        $this
            ->setUnidad($unidad);
    }
    /**
     * Get unidad value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Unidad[]|null
     */
    public function getUnidad()
    {
        return isset($this->unidad) ? $this->unidad : null;
    }
    /**
     * Set unidad value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Unidad[] $unidad
     * @return \ArrayType\ArrayOfUnidad
     */
    public function setUnidad(array $unidad = array())
    {
        foreach ($unidad as $arrayOfUnidadUnidadItem) {
            // validation for constraint: itemType
            if (!$arrayOfUnidadUnidadItem instanceof \StructType\Unidad) {
                throw new \InvalidArgumentException(sprintf('The unidad property can only contain items of \StructType\Unidad, "%s" given', is_object($arrayOfUnidadUnidadItem) ? get_class($arrayOfUnidadUnidadItem) : gettype($arrayOfUnidadUnidadItem)), __LINE__);
            }
        }
        if (is_null($unidad) || (is_array($unidad) && empty($unidad))) {
            unset($this->unidad);
        } else {
            $this->unidad = $unidad;
        }
        return $this;
    }
    /**
     * Add item to unidad value
     * @throws \InvalidArgumentException
     * @param \StructType\Unidad $item
     * @return \ArrayType\ArrayOfUnidad
     */
    public function addToUnidad(\StructType\Unidad $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unidad) {
            throw new \InvalidArgumentException(sprintf('The unidad property can only contain items of \StructType\Unidad, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->unidad[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Unidad|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Unidad|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Unidad|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Unidad|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Unidad|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string unidad
     */
    public function getAttributeName()
    {
        return 'unidad';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfUnidad
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
