<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GrabarDespachoResponse StructType
 * @subpackage Structs
 */
class GrabarDespachoResponse extends AbstractStructBase
{
    /**
     * The respuesta
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $respuesta;
    /**
     * The remesa
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $remesa;
    /**
     * The mensaje
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mensaje;
    /**
     * Constructor method for GrabarDespachoResponse
     * @uses GrabarDespachoResponse::setRespuesta()
     * @uses GrabarDespachoResponse::setRemesa()
     * @uses GrabarDespachoResponse::setMensaje()
     * @param int $respuesta
     * @param string $remesa
     * @param string $mensaje
     */
    public function __construct($respuesta = null, $remesa = null, $mensaje = null)
    {
        $this
            ->setRespuesta($respuesta)
            ->setRemesa($remesa)
            ->setMensaje($mensaje);
    }
    /**
     * Get respuesta value
     * @return int
     */
    public function getRespuesta()
    {
        return $this->respuesta;
    }
    /**
     * Set respuesta value
     * @param int $respuesta
     * @return \StructType\GrabarDespachoResponse
     */
    public function setRespuesta($respuesta = null)
    {
        // validation for constraint: int
        if (!is_null($respuesta) && !is_numeric($respuesta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($respuesta)), __LINE__);
        }
        $this->respuesta = $respuesta;
        return $this;
    }
    /**
     * Get remesa value
     * @return string|null
     */
    public function getRemesa()
    {
        return $this->remesa;
    }
    /**
     * Set remesa value
     * @param string $remesa
     * @return \StructType\GrabarDespachoResponse
     */
    public function setRemesa($remesa = null)
    {
        // validation for constraint: string
        if (!is_null($remesa) && !is_string($remesa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remesa)), __LINE__);
        }
        $this->remesa = $remesa;
        return $this;
    }
    /**
     * Get mensaje value
     * @return string|null
     */
    public function getMensaje()
    {
        return $this->mensaje;
    }
    /**
     * Set mensaje value
     * @param string $mensaje
     * @return \StructType\GrabarDespachoResponse
     */
    public function setMensaje($mensaje = null)
    {
        // validation for constraint: string
        if (!is_null($mensaje) && !is_string($mensaje)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mensaje)), __LINE__);
        }
        $this->mensaje = $mensaje;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GrabarDespachoResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
