<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRemesa ArrayType
 * @subpackage Arrays
 */
class ArrayOfRemesa extends AbstractStructArrayBase
{
    /**
     * The Remesa
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Remesa[]
     */
    public $Remesa;
    /**
     * Constructor method for ArrayOfRemesa
     * @uses ArrayOfRemesa::setRemesa()
     * @param \StructType\Remesa[] $remesa
     */
    public function __construct(array $remesa = array())
    {
        $this
            ->setRemesa($remesa);
    }
    /**
     * Get Remesa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Remesa[]|null
     */
    public function getRemesa()
    {
        return isset($this->Remesa) ? $this->Remesa : null;
    }
    /**
     * Set Remesa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Remesa[] $remesa
     * @return \ArrayType\ArrayOfRemesa
     */
    public function setRemesa(array $remesa = array())
    {
        foreach ($remesa as $arrayOfRemesaRemesaItem) {
            // validation for constraint: itemType
            if (!$arrayOfRemesaRemesaItem instanceof \StructType\Remesa) {
                throw new \InvalidArgumentException(sprintf('The Remesa property can only contain items of \StructType\Remesa, "%s" given', is_object($arrayOfRemesaRemesaItem) ? get_class($arrayOfRemesaRemesaItem) : gettype($arrayOfRemesaRemesaItem)), __LINE__);
            }
        }
        if (is_null($remesa) || (is_array($remesa) && empty($remesa))) {
            unset($this->Remesa);
        } else {
            $this->Remesa = $remesa;
        }
        return $this;
    }
    /**
     * Add item to Remesa value
     * @throws \InvalidArgumentException
     * @param \StructType\Remesa $item
     * @return \ArrayType\ArrayOfRemesa
     */
    public function addToRemesa(\StructType\Remesa $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Remesa) {
            throw new \InvalidArgumentException(sprintf('The Remesa property can only contain items of \StructType\Remesa, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Remesa[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Remesa|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Remesa|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Remesa|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Remesa|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Remesa|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Remesa
     */
    public function getAttributeName()
    {
        return 'Remesa';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRemesa
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
