<?php

namespace NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadConsolidatedPDF Struct
 * @subpackage Structs
 */
class UploadConsolidatedPDF extends AbstractStructBase
{
    /**
     * The objSplitOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $objSplitOptions;
    /**
     * The splitPages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $splitPages;
    /**
     * The blnColour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $blnColour;
    /**
     * The blnDoubleSided
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $blnDoubleSided;
    /**
     * The blnSendLetters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $blnSendLetters;
    /**
     * The jobRunID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $jobRunID;
    /**
     * The strLoginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $strLoginToken;
    /**
     * The strDocumentName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $strDocumentName;
    /**
     * The DocumentData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentData;
    /**
     * The xmlResults
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \NineDotMedia\Viapost\Struct\XmlResults
     */
    public $xmlResults;
    /**
     * The strErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $strErrorMessage;
    /**
     * Constructor method for UploadConsolidatedPDF
     * @uses UploadConsolidatedPDF::setObjSplitOptions()
     * @uses UploadConsolidatedPDF::setSplitPages()
     * @uses UploadConsolidatedPDF::setBlnColour()
     * @uses UploadConsolidatedPDF::setBlnDoubleSided()
     * @uses UploadConsolidatedPDF::setBlnSendLetters()
     * @uses UploadConsolidatedPDF::setJobRunID()
     * @uses UploadConsolidatedPDF::setStrLoginToken()
     * @uses UploadConsolidatedPDF::setStrDocumentName()
     * @uses UploadConsolidatedPDF::setDocumentData()
     * @uses UploadConsolidatedPDF::setXmlResults()
     * @uses UploadConsolidatedPDF::setStrErrorMessage()
     * @param string $objSplitOptions
     * @param int $splitPages
     * @param bool $blnColour
     * @param bool $blnDoubleSided
     * @param bool $blnSendLetters
     * @param int $jobRunID
     * @param string $strLoginToken
     * @param string $strDocumentName
     * @param string $documentData
     * @param \NineDotMedia\Viapost\Struct\XmlResults $xmlResults
     * @param string $strErrorMessage
     */
    public function __construct($objSplitOptions = null, $splitPages = null, $blnColour = null, $blnDoubleSided = null, $blnSendLetters = null, $jobRunID = null, $strLoginToken = null, $strDocumentName = null, $documentData = null, \NineDotMedia\Viapost\Struct\XmlResults $xmlResults = null, $strErrorMessage = null)
    {
        $this
            ->setObjSplitOptions($objSplitOptions)
            ->setSplitPages($splitPages)
            ->setBlnColour($blnColour)
            ->setBlnDoubleSided($blnDoubleSided)
            ->setBlnSendLetters($blnSendLetters)
            ->setJobRunID($jobRunID)
            ->setStrLoginToken($strLoginToken)
            ->setStrDocumentName($strDocumentName)
            ->setDocumentData($documentData)
            ->setXmlResults($xmlResults)
            ->setStrErrorMessage($strErrorMessage);
    }
    /**
     * Get objSplitOptions value
     * @return string
     */
    public function getObjSplitOptions()
    {
        return $this->objSplitOptions;
    }
    /**
     * Set objSplitOptions value
     * @uses \NineDotMedia\Viapost\Enum\ConsolidatedPdfSplitOptions::valueIsValid()
     * @uses \NineDotMedia\Viapost\Enum\ConsolidatedPdfSplitOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $objSplitOptions
     * @return \NineDotMedia\Viapost\Struct\UploadConsolidatedPDF
     */
    public function setObjSplitOptions($objSplitOptions = null)
    {
        // validation for constraint: enumeration
        if (!\NineDotMedia\Viapost\Enum\ConsolidatedPdfSplitOptions::valueIsValid($objSplitOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \NineDotMedia\Viapost\Enum\ConsolidatedPdfSplitOptions', is_array($objSplitOptions) ? implode(', ', $objSplitOptions) : var_export($objSplitOptions, true), implode(', ', \NineDotMedia\Viapost\Enum\ConsolidatedPdfSplitOptions::getValidValues())), __LINE__);
        }
        $this->objSplitOptions = $objSplitOptions;
        return $this;
    }
    /**
     * Get splitPages value
     * @return int
     */
    public function getSplitPages()
    {
        return $this->splitPages;
    }
    /**
     * Set splitPages value
     * @param int $splitPages
     * @return \NineDotMedia\Viapost\Struct\UploadConsolidatedPDF
     */
    public function setSplitPages($splitPages = null)
    {
        // validation for constraint: int
        if (!is_null($splitPages) && !(is_int($splitPages) || ctype_digit($splitPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($splitPages, true), gettype($splitPages)), __LINE__);
        }
        $this->splitPages = $splitPages;
        return $this;
    }
    /**
     * Get blnColour value
     * @return bool
     */
    public function getBlnColour()
    {
        return $this->blnColour;
    }
    /**
     * Set blnColour value
     * @param bool $blnColour
     * @return \NineDotMedia\Viapost\Struct\UploadConsolidatedPDF
     */
    public function setBlnColour($blnColour = null)
    {
        // validation for constraint: boolean
        if (!is_null($blnColour) && !is_bool($blnColour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($blnColour, true), gettype($blnColour)), __LINE__);
        }
        $this->blnColour = $blnColour;
        return $this;
    }
    /**
     * Get blnDoubleSided value
     * @return bool
     */
    public function getBlnDoubleSided()
    {
        return $this->blnDoubleSided;
    }
    /**
     * Set blnDoubleSided value
     * @param bool $blnDoubleSided
     * @return \NineDotMedia\Viapost\Struct\UploadConsolidatedPDF
     */
    public function setBlnDoubleSided($blnDoubleSided = null)
    {
        // validation for constraint: boolean
        if (!is_null($blnDoubleSided) && !is_bool($blnDoubleSided)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($blnDoubleSided, true), gettype($blnDoubleSided)), __LINE__);
        }
        $this->blnDoubleSided = $blnDoubleSided;
        return $this;
    }
    /**
     * Get blnSendLetters value
     * @return bool
     */
    public function getBlnSendLetters()
    {
        return $this->blnSendLetters;
    }
    /**
     * Set blnSendLetters value
     * @param bool $blnSendLetters
     * @return \NineDotMedia\Viapost\Struct\UploadConsolidatedPDF
     */
    public function setBlnSendLetters($blnSendLetters = null)
    {
        // validation for constraint: boolean
        if (!is_null($blnSendLetters) && !is_bool($blnSendLetters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($blnSendLetters, true), gettype($blnSendLetters)), __LINE__);
        }
        $this->blnSendLetters = $blnSendLetters;
        return $this;
    }
    /**
     * Get jobRunID value
     * @return int
     */
    public function getJobRunID()
    {
        return $this->jobRunID;
    }
    /**
     * Set jobRunID value
     * @param int $jobRunID
     * @return \NineDotMedia\Viapost\Struct\UploadConsolidatedPDF
     */
    public function setJobRunID($jobRunID = null)
    {
        // validation for constraint: int
        if (!is_null($jobRunID) && !(is_int($jobRunID) || ctype_digit($jobRunID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jobRunID, true), gettype($jobRunID)), __LINE__);
        }
        $this->jobRunID = $jobRunID;
        return $this;
    }
    /**
     * Get strLoginToken value
     * @return string|null
     */
    public function getStrLoginToken()
    {
        return $this->strLoginToken;
    }
    /**
     * Set strLoginToken value
     * @param string $strLoginToken
     * @return \NineDotMedia\Viapost\Struct\UploadConsolidatedPDF
     */
    public function setStrLoginToken($strLoginToken = null)
    {
        // validation for constraint: string
        if (!is_null($strLoginToken) && !is_string($strLoginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strLoginToken, true), gettype($strLoginToken)), __LINE__);
        }
        $this->strLoginToken = $strLoginToken;
        return $this;
    }
    /**
     * Get strDocumentName value
     * @return string|null
     */
    public function getStrDocumentName()
    {
        return $this->strDocumentName;
    }
    /**
     * Set strDocumentName value
     * @param string $strDocumentName
     * @return \NineDotMedia\Viapost\Struct\UploadConsolidatedPDF
     */
    public function setStrDocumentName($strDocumentName = null)
    {
        // validation for constraint: string
        if (!is_null($strDocumentName) && !is_string($strDocumentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strDocumentName, true), gettype($strDocumentName)), __LINE__);
        }
        $this->strDocumentName = $strDocumentName;
        return $this;
    }
    /**
     * Get DocumentData value
     * @return string|null
     */
    public function getDocumentData()
    {
        return $this->DocumentData;
    }
    /**
     * Set DocumentData value
     * @param string $documentData
     * @return \NineDotMedia\Viapost\Struct\UploadConsolidatedPDF
     */
    public function setDocumentData($documentData = null)
    {
        // validation for constraint: string
        if (!is_null($documentData) && !is_string($documentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentData, true), gettype($documentData)), __LINE__);
        }
        $this->DocumentData = $documentData;
        return $this;
    }
    /**
     * Get xmlResults value
     * @return \NineDotMedia\Viapost\Struct\XmlResults|null
     */
    public function getXmlResults()
    {
        return $this->xmlResults;
    }
    /**
     * Set xmlResults value
     * @param \NineDotMedia\Viapost\Struct\XmlResults $xmlResults
     * @return \NineDotMedia\Viapost\Struct\UploadConsolidatedPDF
     */
    public function setXmlResults(\NineDotMedia\Viapost\Struct\XmlResults $xmlResults = null)
    {
        $this->xmlResults = $xmlResults;
        return $this;
    }
    /**
     * Get strErrorMessage value
     * @return string|null
     */
    public function getStrErrorMessage()
    {
        return $this->strErrorMessage;
    }
    /**
     * Set strErrorMessage value
     * @param string $strErrorMessage
     * @return \NineDotMedia\Viapost\Struct\UploadConsolidatedPDF
     */
    public function setStrErrorMessage($strErrorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($strErrorMessage) && !is_string($strErrorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strErrorMessage, true), gettype($strErrorMessage)), __LINE__);
        }
        $this->strErrorMessage = $strErrorMessage;
        return $this;
    }
}
