<?php

namespace NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservedArea Struct
 * @subpackage Structs
 */
class ReservedArea extends AbstractStructBase
{
    /**
     * The Area
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \NineDotMedia\Viapost\Struct\RectangleF
     */
    public $Area;
    /**
     * The PageNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageNumber;
    /**
     * The OddPages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OddPages;
    /**
     * The EvenPages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EvenPages;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for ReservedArea
     * @uses ReservedArea::setArea()
     * @uses ReservedArea::setPageNumber()
     * @uses ReservedArea::setOddPages()
     * @uses ReservedArea::setEvenPages()
     * @uses ReservedArea::setDescription()
     * @param \NineDotMedia\Viapost\Struct\RectangleF $area
     * @param int $pageNumber
     * @param bool $oddPages
     * @param bool $evenPages
     * @param string $description
     */
    public function __construct(\NineDotMedia\Viapost\Struct\RectangleF $area = null, $pageNumber = null, $oddPages = null, $evenPages = null, $description = null)
    {
        $this
            ->setArea($area)
            ->setPageNumber($pageNumber)
            ->setOddPages($oddPages)
            ->setEvenPages($evenPages)
            ->setDescription($description);
    }
    /**
     * Get Area value
     * @return \NineDotMedia\Viapost\Struct\RectangleF
     */
    public function getArea()
    {
        return $this->Area;
    }
    /**
     * Set Area value
     * @param \NineDotMedia\Viapost\Struct\RectangleF $area
     * @return \NineDotMedia\Viapost\Struct\ReservedArea
     */
    public function setArea(\NineDotMedia\Viapost\Struct\RectangleF $area = null)
    {
        $this->Area = $area;
        return $this;
    }
    /**
     * Get PageNumber value
     * @return int
     */
    public function getPageNumber()
    {
        return $this->PageNumber;
    }
    /**
     * Set PageNumber value
     * @param int $pageNumber
     * @return \NineDotMedia\Viapost\Struct\ReservedArea
     */
    public function setPageNumber($pageNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pageNumber) && !(is_int($pageNumber) || ctype_digit($pageNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageNumber, true), gettype($pageNumber)), __LINE__);
        }
        $this->PageNumber = $pageNumber;
        return $this;
    }
    /**
     * Get OddPages value
     * @return bool
     */
    public function getOddPages()
    {
        return $this->OddPages;
    }
    /**
     * Set OddPages value
     * @param bool $oddPages
     * @return \NineDotMedia\Viapost\Struct\ReservedArea
     */
    public function setOddPages($oddPages = null)
    {
        // validation for constraint: boolean
        if (!is_null($oddPages) && !is_bool($oddPages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($oddPages, true), gettype($oddPages)), __LINE__);
        }
        $this->OddPages = $oddPages;
        return $this;
    }
    /**
     * Get EvenPages value
     * @return bool
     */
    public function getEvenPages()
    {
        return $this->EvenPages;
    }
    /**
     * Set EvenPages value
     * @param bool $evenPages
     * @return \NineDotMedia\Viapost\Struct\ReservedArea
     */
    public function setEvenPages($evenPages = null)
    {
        // validation for constraint: boolean
        if (!is_null($evenPages) && !is_bool($evenPages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($evenPages, true), gettype($evenPages)), __LINE__);
        }
        $this->EvenPages = $evenPages;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \NineDotMedia\Viapost\Struct\ReservedArea
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
