<?php

namespace NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreviewLibraryAttachment Struct
 * @subpackage Structs
 */
class PreviewLibraryAttachment extends AbstractStructBase
{
    /**
     * The attachmentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $attachmentId;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $format;
    /**
     * The pageNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pageNumber;
    /**
     * The attachmentData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $attachmentData;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for PreviewLibraryAttachment
     * @uses PreviewLibraryAttachment::setAttachmentId()
     * @uses PreviewLibraryAttachment::setLoginToken()
     * @uses PreviewLibraryAttachment::setFormat()
     * @uses PreviewLibraryAttachment::setPageNumber()
     * @uses PreviewLibraryAttachment::setAttachmentData()
     * @uses PreviewLibraryAttachment::setReturnMessage()
     * @param int $attachmentId
     * @param string $loginToken
     * @param string $format
     * @param string $pageNumber
     * @param string $attachmentData
     * @param string $returnMessage
     */
    public function __construct($attachmentId = null, $loginToken = null, $format = null, $pageNumber = null, $attachmentData = null, $returnMessage = null)
    {
        $this
            ->setAttachmentId($attachmentId)
            ->setLoginToken($loginToken)
            ->setFormat($format)
            ->setPageNumber($pageNumber)
            ->setAttachmentData($attachmentData)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get attachmentId value
     * @return int
     */
    public function getAttachmentId()
    {
        return $this->attachmentId;
    }
    /**
     * Set attachmentId value
     * @param int $attachmentId
     * @return \NineDotMedia\Viapost\Struct\PreviewLibraryAttachment
     */
    public function setAttachmentId($attachmentId = null)
    {
        // validation for constraint: int
        if (!is_null($attachmentId) && !(is_int($attachmentId) || ctype_digit($attachmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($attachmentId, true), gettype($attachmentId)), __LINE__);
        }
        $this->attachmentId = $attachmentId;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \NineDotMedia\Viapost\Struct\PreviewLibraryAttachment
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param string $format
     * @return \NineDotMedia\Viapost\Struct\PreviewLibraryAttachment
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get pageNumber value
     * @return string|null
     */
    public function getPageNumber()
    {
        return $this->pageNumber;
    }
    /**
     * Set pageNumber value
     * @param string $pageNumber
     * @return \NineDotMedia\Viapost\Struct\PreviewLibraryAttachment
     */
    public function setPageNumber($pageNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pageNumber) && !is_string($pageNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pageNumber, true), gettype($pageNumber)), __LINE__);
        }
        $this->pageNumber = $pageNumber;
        return $this;
    }
    /**
     * Get attachmentData value
     * @return string|null
     */
    public function getAttachmentData()
    {
        return $this->attachmentData;
    }
    /**
     * Set attachmentData value
     * @param string $attachmentData
     * @return \NineDotMedia\Viapost\Struct\PreviewLibraryAttachment
     */
    public function setAttachmentData($attachmentData = null)
    {
        // validation for constraint: string
        if (!is_null($attachmentData) && !is_string($attachmentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachmentData, true), gettype($attachmentData)), __LINE__);
        }
        $this->attachmentData = $attachmentData;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \NineDotMedia\Viapost\Struct\PreviewLibraryAttachment
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
