<?php

namespace NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLibraryPostcards Struct
 * @subpackage Structs
 */
class GetLibraryPostcards extends AbstractStructBase
{
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The searchDocumentName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $searchDocumentName;
    /**
     * The postcards
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \NineDotMedia\Viapost\Array\ArrayOfAnyType
     */
    public $postcards;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for GetLibraryPostcards
     * @uses GetLibraryPostcards::setLoginToken()
     * @uses GetLibraryPostcards::setSearchDocumentName()
     * @uses GetLibraryPostcards::setPostcards()
     * @uses GetLibraryPostcards::setReturnMessage()
     * @param string $loginToken
     * @param string $searchDocumentName
     * @param \NineDotMedia\Viapost\Array\ArrayOfAnyType $postcards
     * @param string $returnMessage
     */
    public function __construct($loginToken = null, $searchDocumentName = null, \NineDotMedia\Viapost\Array\ArrayOfAnyType $postcards = null, $returnMessage = null)
    {
        $this
            ->setLoginToken($loginToken)
            ->setSearchDocumentName($searchDocumentName)
            ->setPostcards($postcards)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \NineDotMedia\Viapost\Struct\GetLibraryPostcards
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get searchDocumentName value
     * @return string|null
     */
    public function getSearchDocumentName()
    {
        return $this->searchDocumentName;
    }
    /**
     * Set searchDocumentName value
     * @param string $searchDocumentName
     * @return \NineDotMedia\Viapost\Struct\GetLibraryPostcards
     */
    public function setSearchDocumentName($searchDocumentName = null)
    {
        // validation for constraint: string
        if (!is_null($searchDocumentName) && !is_string($searchDocumentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchDocumentName, true), gettype($searchDocumentName)), __LINE__);
        }
        $this->searchDocumentName = $searchDocumentName;
        return $this;
    }
    /**
     * Get postcards value
     * @return \NineDotMedia\Viapost\Array\ArrayOfAnyType|null
     */
    public function getPostcards()
    {
        return $this->postcards;
    }
    /**
     * Set postcards value
     * @param \NineDotMedia\Viapost\Array\ArrayOfAnyType $postcards
     * @return \NineDotMedia\Viapost\Struct\GetLibraryPostcards
     */
    public function setPostcards(\NineDotMedia\Viapost\Array\ArrayOfAnyType $postcards = null)
    {
        $this->postcards = $postcards;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \NineDotMedia\Viapost\Struct\GetLibraryPostcards
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
