<?php

namespace NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLatestVersionDetails Struct
 * @subpackage Structs
 */
class GetLatestVersionDetails extends AbstractStructBase
{
    /**
     * The product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $product;
    /**
     * The platform
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $platform;
    /**
     * The required
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $required;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The brand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $brand;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $version;
    /**
     * The downloadUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $downloadUrl;
    /**
     * The ReleaseDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReleaseDate;
    /**
     * The helpUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $helpUrl;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * Constructor method for GetLatestVersionDetails
     * @uses GetLatestVersionDetails::setProduct()
     * @uses GetLatestVersionDetails::setPlatform()
     * @uses GetLatestVersionDetails::setRequired()
     * @uses GetLatestVersionDetails::setLoginToken()
     * @uses GetLatestVersionDetails::setBrand()
     * @uses GetLatestVersionDetails::setVersion()
     * @uses GetLatestVersionDetails::setDownloadUrl()
     * @uses GetLatestVersionDetails::setReleaseDate()
     * @uses GetLatestVersionDetails::setHelpUrl()
     * @uses GetLatestVersionDetails::setMessage()
     * @param string $product
     * @param string $platform
     * @param bool $required
     * @param string $loginToken
     * @param string $brand
     * @param string $version
     * @param string $downloadUrl
     * @param string $releaseDate
     * @param string $helpUrl
     * @param string $message
     */
    public function __construct($product = null, $platform = null, $required = null, $loginToken = null, $brand = null, $version = null, $downloadUrl = null, $releaseDate = null, $helpUrl = null, $message = null)
    {
        $this
            ->setProduct($product)
            ->setPlatform($platform)
            ->setRequired($required)
            ->setLoginToken($loginToken)
            ->setBrand($brand)
            ->setVersion($version)
            ->setDownloadUrl($downloadUrl)
            ->setReleaseDate($releaseDate)
            ->setHelpUrl($helpUrl)
            ->setMessage($message);
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \NineDotMedia\Viapost\Enum\ProductType::valueIsValid()
     * @uses \NineDotMedia\Viapost\Enum\ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \NineDotMedia\Viapost\Struct\GetLatestVersionDetails
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\NineDotMedia\Viapost\Enum\ProductType::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \NineDotMedia\Viapost\Enum\ProductType', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \NineDotMedia\Viapost\Enum\ProductType::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get platform value
     * @return string
     */
    public function getPlatform()
    {
        return $this->platform;
    }
    /**
     * Set platform value
     * @uses \NineDotMedia\Viapost\Enum\Platform::valueIsValid()
     * @uses \NineDotMedia\Viapost\Enum\Platform::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $platform
     * @return \NineDotMedia\Viapost\Struct\GetLatestVersionDetails
     */
    public function setPlatform($platform = null)
    {
        // validation for constraint: enumeration
        if (!\NineDotMedia\Viapost\Enum\Platform::valueIsValid($platform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \NineDotMedia\Viapost\Enum\Platform', is_array($platform) ? implode(', ', $platform) : var_export($platform, true), implode(', ', \NineDotMedia\Viapost\Enum\Platform::getValidValues())), __LINE__);
        }
        $this->platform = $platform;
        return $this;
    }
    /**
     * Get required value
     * @return bool
     */
    public function getRequired()
    {
        return $this->required;
    }
    /**
     * Set required value
     * @param bool $required
     * @return \NineDotMedia\Viapost\Struct\GetLatestVersionDetails
     */
    public function setRequired($required = null)
    {
        // validation for constraint: boolean
        if (!is_null($required) && !is_bool($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($required, true), gettype($required)), __LINE__);
        }
        $this->required = $required;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \NineDotMedia\Viapost\Struct\GetLatestVersionDetails
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get brand value
     * @return string|null
     */
    public function getBrand()
    {
        return $this->brand;
    }
    /**
     * Set brand value
     * @param string $brand
     * @return \NineDotMedia\Viapost\Struct\GetLatestVersionDetails
     */
    public function setBrand($brand = null)
    {
        // validation for constraint: string
        if (!is_null($brand) && !is_string($brand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brand, true), gettype($brand)), __LINE__);
        }
        $this->brand = $brand;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \NineDotMedia\Viapost\Struct\GetLatestVersionDetails
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get downloadUrl value
     * @return string|null
     */
    public function getDownloadUrl()
    {
        return $this->downloadUrl;
    }
    /**
     * Set downloadUrl value
     * @param string $downloadUrl
     * @return \NineDotMedia\Viapost\Struct\GetLatestVersionDetails
     */
    public function setDownloadUrl($downloadUrl = null)
    {
        // validation for constraint: string
        if (!is_null($downloadUrl) && !is_string($downloadUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($downloadUrl, true), gettype($downloadUrl)), __LINE__);
        }
        $this->downloadUrl = $downloadUrl;
        return $this;
    }
    /**
     * Get ReleaseDate value
     * @return string|null
     */
    public function getReleaseDate()
    {
        return $this->ReleaseDate;
    }
    /**
     * Set ReleaseDate value
     * @param string $releaseDate
     * @return \NineDotMedia\Viapost\Struct\GetLatestVersionDetails
     */
    public function setReleaseDate($releaseDate = null)
    {
        // validation for constraint: string
        if (!is_null($releaseDate) && !is_string($releaseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($releaseDate, true), gettype($releaseDate)), __LINE__);
        }
        $this->ReleaseDate = $releaseDate;
        return $this;
    }
    /**
     * Get helpUrl value
     * @return string|null
     */
    public function getHelpUrl()
    {
        return $this->helpUrl;
    }
    /**
     * Set helpUrl value
     * @param string $helpUrl
     * @return \NineDotMedia\Viapost\Struct\GetLatestVersionDetails
     */
    public function setHelpUrl($helpUrl = null)
    {
        // validation for constraint: string
        if (!is_null($helpUrl) && !is_string($helpUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($helpUrl, true), gettype($helpUrl)), __LINE__);
        }
        $this->helpUrl = $helpUrl;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \NineDotMedia\Viapost\Struct\GetLatestVersionDetails
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
}
