<?php

namespace NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateLetterResponse Struct
 * @subpackage Structs
 */
class CreateLetterResponse extends AbstractStructBase
{
    /**
     * The CreateLetterResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CreateLetterResult;
    /**
     * The letterID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $letterID;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for CreateLetterResponse
     * @uses CreateLetterResponse::setCreateLetterResult()
     * @uses CreateLetterResponse::setLetterID()
     * @uses CreateLetterResponse::setReturnMessage()
     * @param bool $createLetterResult
     * @param int $letterID
     * @param string $returnMessage
     */
    public function __construct($createLetterResult = null, $letterID = null, $returnMessage = null)
    {
        $this
            ->setCreateLetterResult($createLetterResult)
            ->setLetterID($letterID)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get CreateLetterResult value
     * @return bool
     */
    public function getCreateLetterResult()
    {
        return $this->CreateLetterResult;
    }
    /**
     * Set CreateLetterResult value
     * @param bool $createLetterResult
     * @return \NineDotMedia\Viapost\Struct\CreateLetterResponse
     */
    public function setCreateLetterResult($createLetterResult = null)
    {
        // validation for constraint: boolean
        if (!is_null($createLetterResult) && !is_bool($createLetterResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($createLetterResult, true), gettype($createLetterResult)), __LINE__);
        }
        $this->CreateLetterResult = $createLetterResult;
        return $this;
    }
    /**
     * Get letterID value
     * @return int
     */
    public function getLetterID()
    {
        return $this->letterID;
    }
    /**
     * Set letterID value
     * @param int $letterID
     * @return \NineDotMedia\Viapost\Struct\CreateLetterResponse
     */
    public function setLetterID($letterID = null)
    {
        // validation for constraint: int
        if (!is_null($letterID) && !(is_int($letterID) || ctype_digit($letterID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($letterID, true), gettype($letterID)), __LINE__);
        }
        $this->letterID = $letterID;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \NineDotMedia\Viapost\Struct\CreateLetterResponse
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
