<?php

namespace NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignIn Struct
 * @subpackage Structs
 */
class SignIn extends AbstractStructBase
{
    /**
     * The sUserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sUserName;
    /**
     * The sPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sPassword;
    /**
     * The sLoginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLoginToken;
    /**
     * The sReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sReturnMessage;
    /**
     * Constructor method for SignIn
     * @uses SignIn::setSUserName()
     * @uses SignIn::setSPassword()
     * @uses SignIn::setSLoginToken()
     * @uses SignIn::setSReturnMessage()
     * @param string $sUserName
     * @param string $sPassword
     * @param string $sLoginToken
     * @param string $sReturnMessage
     */
    public function __construct($sUserName = null, $sPassword = null, $sLoginToken = null, $sReturnMessage = null)
    {
        $this
            ->setSUserName($sUserName)
            ->setSPassword($sPassword)
            ->setSLoginToken($sLoginToken)
            ->setSReturnMessage($sReturnMessage);
    }
    /**
     * Get sUserName value
     * @return string|null
     */
    public function getSUserName()
    {
        return $this->sUserName;
    }
    /**
     * Set sUserName value
     * @param string $sUserName
     * @return \NineDotMedia\Viapost\Struct\SignIn
     */
    public function setSUserName($sUserName = null)
    {
        // validation for constraint: string
        if (!is_null($sUserName) && !is_string($sUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUserName, true), gettype($sUserName)), __LINE__);
        }
        $this->sUserName = $sUserName;
        return $this;
    }
    /**
     * Get sPassword value
     * @return string|null
     */
    public function getSPassword()
    {
        return $this->sPassword;
    }
    /**
     * Set sPassword value
     * @param string $sPassword
     * @return \NineDotMedia\Viapost\Struct\SignIn
     */
    public function setSPassword($sPassword = null)
    {
        // validation for constraint: string
        if (!is_null($sPassword) && !is_string($sPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sPassword, true), gettype($sPassword)), __LINE__);
        }
        $this->sPassword = $sPassword;
        return $this;
    }
    /**
     * Get sLoginToken value
     * @return string|null
     */
    public function getSLoginToken()
    {
        return $this->sLoginToken;
    }
    /**
     * Set sLoginToken value
     * @param string $sLoginToken
     * @return \NineDotMedia\Viapost\Struct\SignIn
     */
    public function setSLoginToken($sLoginToken = null)
    {
        // validation for constraint: string
        if (!is_null($sLoginToken) && !is_string($sLoginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLoginToken, true), gettype($sLoginToken)), __LINE__);
        }
        $this->sLoginToken = $sLoginToken;
        return $this;
    }
    /**
     * Get sReturnMessage value
     * @return string|null
     */
    public function getSReturnMessage()
    {
        return $this->sReturnMessage;
    }
    /**
     * Set sReturnMessage value
     * @param string $sReturnMessage
     * @return \NineDotMedia\Viapost\Struct\SignIn
     */
    public function setSReturnMessage($sReturnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sReturnMessage) && !is_string($sReturnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sReturnMessage, true), gettype($sReturnMessage)), __LINE__);
        }
        $this->sReturnMessage = $sReturnMessage;
        return $this;
    }
}
