<?php

namespace NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreviewDocumentSingleAddress Struct
 * @subpackage Structs
 */
class PreviewDocumentSingleAddress extends AbstractStructBase
{
    /**
     * The documentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $documentType;
    /**
     * The documentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $documentID;
    /**
     * The colour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $colour;
    /**
     * The simplex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $simplex;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The organisation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $organisation;
    /**
     * The street1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $street1;
    /**
     * The street2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $street2;
    /**
     * The street3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $street3;
    /**
     * The posttown
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $posttown;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postcode;
    /**
     * The mergeFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \NineDotMedia\Viapost\Array\ArrayOfArrayOfString
     */
    public $mergeFields;
    /**
     * The documentData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $documentData;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for PreviewDocumentSingleAddress
     * @uses PreviewDocumentSingleAddress::setDocumentType()
     * @uses PreviewDocumentSingleAddress::setDocumentID()
     * @uses PreviewDocumentSingleAddress::setColour()
     * @uses PreviewDocumentSingleAddress::setSimplex()
     * @uses PreviewDocumentSingleAddress::setLoginToken()
     * @uses PreviewDocumentSingleAddress::setName()
     * @uses PreviewDocumentSingleAddress::setOrganisation()
     * @uses PreviewDocumentSingleAddress::setStreet1()
     * @uses PreviewDocumentSingleAddress::setStreet2()
     * @uses PreviewDocumentSingleAddress::setStreet3()
     * @uses PreviewDocumentSingleAddress::setPosttown()
     * @uses PreviewDocumentSingleAddress::setPostcode()
     * @uses PreviewDocumentSingleAddress::setMergeFields()
     * @uses PreviewDocumentSingleAddress::setDocumentData()
     * @uses PreviewDocumentSingleAddress::setReturnMessage()
     * @param string $documentType
     * @param int $documentID
     * @param bool $colour
     * @param bool $simplex
     * @param string $loginToken
     * @param string $name
     * @param string $organisation
     * @param string $street1
     * @param string $street2
     * @param string $street3
     * @param string $posttown
     * @param string $postcode
     * @param \NineDotMedia\Viapost\Array\ArrayOfArrayOfString $mergeFields
     * @param string $documentData
     * @param string $returnMessage
     */
    public function __construct($documentType = null, $documentID = null, $colour = null, $simplex = null, $loginToken = null, $name = null, $organisation = null, $street1 = null, $street2 = null, $street3 = null, $posttown = null, $postcode = null, \NineDotMedia\Viapost\Array\ArrayOfArrayOfString $mergeFields = null, $documentData = null, $returnMessage = null)
    {
        $this
            ->setDocumentType($documentType)
            ->setDocumentID($documentID)
            ->setColour($colour)
            ->setSimplex($simplex)
            ->setLoginToken($loginToken)
            ->setName($name)
            ->setOrganisation($organisation)
            ->setStreet1($street1)
            ->setStreet2($street2)
            ->setStreet3($street3)
            ->setPosttown($posttown)
            ->setPostcode($postcode)
            ->setMergeFields($mergeFields)
            ->setDocumentData($documentData)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get documentType value
     * @return string
     */
    public function getDocumentType()
    {
        return $this->documentType;
    }
    /**
     * Set documentType value
     * @uses \NineDotMedia\Viapost\Enum\DocumentType::valueIsValid()
     * @uses \NineDotMedia\Viapost\Enum\DocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentType
     * @return \NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddress
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: enumeration
        if (!\NineDotMedia\Viapost\Enum\DocumentType::valueIsValid($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \NineDotMedia\Viapost\Enum\DocumentType', is_array($documentType) ? implode(', ', $documentType) : var_export($documentType, true), implode(', ', \NineDotMedia\Viapost\Enum\DocumentType::getValidValues())), __LINE__);
        }
        $this->documentType = $documentType;
        return $this;
    }
    /**
     * Get documentID value
     * @return int
     */
    public function getDocumentID()
    {
        return $this->documentID;
    }
    /**
     * Set documentID value
     * @param int $documentID
     * @return \NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddress
     */
    public function setDocumentID($documentID = null)
    {
        // validation for constraint: int
        if (!is_null($documentID) && !(is_int($documentID) || ctype_digit($documentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentID, true), gettype($documentID)), __LINE__);
        }
        $this->documentID = $documentID;
        return $this;
    }
    /**
     * Get colour value
     * @return bool
     */
    public function getColour()
    {
        return $this->colour;
    }
    /**
     * Set colour value
     * @param bool $colour
     * @return \NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddress
     */
    public function setColour($colour = null)
    {
        // validation for constraint: boolean
        if (!is_null($colour) && !is_bool($colour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($colour, true), gettype($colour)), __LINE__);
        }
        $this->colour = $colour;
        return $this;
    }
    /**
     * Get simplex value
     * @return bool
     */
    public function getSimplex()
    {
        return $this->simplex;
    }
    /**
     * Set simplex value
     * @param bool $simplex
     * @return \NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddress
     */
    public function setSimplex($simplex = null)
    {
        // validation for constraint: boolean
        if (!is_null($simplex) && !is_bool($simplex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simplex, true), gettype($simplex)), __LINE__);
        }
        $this->simplex = $simplex;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddress
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddress
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get organisation value
     * @return string|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param string $organisation
     * @return \NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddress
     */
    public function setOrganisation($organisation = null)
    {
        // validation for constraint: string
        if (!is_null($organisation) && !is_string($organisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organisation, true), gettype($organisation)), __LINE__);
        }
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get street1 value
     * @return string|null
     */
    public function getStreet1()
    {
        return $this->street1;
    }
    /**
     * Set street1 value
     * @param string $street1
     * @return \NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddress
     */
    public function setStreet1($street1 = null)
    {
        // validation for constraint: string
        if (!is_null($street1) && !is_string($street1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street1, true), gettype($street1)), __LINE__);
        }
        $this->street1 = $street1;
        return $this;
    }
    /**
     * Get street2 value
     * @return string|null
     */
    public function getStreet2()
    {
        return $this->street2;
    }
    /**
     * Set street2 value
     * @param string $street2
     * @return \NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddress
     */
    public function setStreet2($street2 = null)
    {
        // validation for constraint: string
        if (!is_null($street2) && !is_string($street2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street2, true), gettype($street2)), __LINE__);
        }
        $this->street2 = $street2;
        return $this;
    }
    /**
     * Get street3 value
     * @return string|null
     */
    public function getStreet3()
    {
        return $this->street3;
    }
    /**
     * Set street3 value
     * @param string $street3
     * @return \NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddress
     */
    public function setStreet3($street3 = null)
    {
        // validation for constraint: string
        if (!is_null($street3) && !is_string($street3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street3, true), gettype($street3)), __LINE__);
        }
        $this->street3 = $street3;
        return $this;
    }
    /**
     * Get posttown value
     * @return string|null
     */
    public function getPosttown()
    {
        return $this->posttown;
    }
    /**
     * Set posttown value
     * @param string $posttown
     * @return \NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddress
     */
    public function setPosttown($posttown = null)
    {
        // validation for constraint: string
        if (!is_null($posttown) && !is_string($posttown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($posttown, true), gettype($posttown)), __LINE__);
        }
        $this->posttown = $posttown;
        return $this;
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddress
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get mergeFields value
     * @return \NineDotMedia\Viapost\Array\ArrayOfArrayOfString|null
     */
    public function getMergeFields()
    {
        return $this->mergeFields;
    }
    /**
     * Set mergeFields value
     * @param \NineDotMedia\Viapost\Array\ArrayOfArrayOfString $mergeFields
     * @return \NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddress
     */
    public function setMergeFields(\NineDotMedia\Viapost\Array\ArrayOfArrayOfString $mergeFields = null)
    {
        $this->mergeFields = $mergeFields;
        return $this;
    }
    /**
     * Get documentData value
     * @return string|null
     */
    public function getDocumentData()
    {
        return $this->documentData;
    }
    /**
     * Set documentData value
     * @param string $documentData
     * @return \NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddress
     */
    public function setDocumentData($documentData = null)
    {
        // validation for constraint: string
        if (!is_null($documentData) && !is_string($documentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentData, true), gettype($documentData)), __LINE__);
        }
        $this->documentData = $documentData;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddress
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
