<?php

namespace NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PointF Struct
 * @subpackage Structs
 */
class PointF extends AbstractStructBase
{
    /**
     * The X
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $X;
    /**
     * The Y
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Y;
    /**
     * Constructor method for PointF
     * @uses PointF::setX()
     * @uses PointF::setY()
     * @param float $x
     * @param float $y
     */
    public function __construct($x = null, $y = null)
    {
        $this
            ->setX($x)
            ->setY($y);
    }
    /**
     * Get X value
     * @return float
     */
    public function getX()
    {
        return $this->X;
    }
    /**
     * Set X value
     * @param float $x
     * @return \NineDotMedia\Viapost\Struct\PointF
     */
    public function setX($x = null)
    {
        // validation for constraint: float
        if (!is_null($x) && !(is_float($x) || is_numeric($x))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($x, true), gettype($x)), __LINE__);
        }
        $this->X = $x;
        return $this;
    }
    /**
     * Get Y value
     * @return float
     */
    public function getY()
    {
        return $this->Y;
    }
    /**
     * Set Y value
     * @param float $y
     * @return \NineDotMedia\Viapost\Struct\PointF
     */
    public function setY($y = null)
    {
        // validation for constraint: float
        if (!is_null($y) && !(is_float($y) || is_numeric($y))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($y, true), gettype($y)), __LINE__);
        }
        $this->Y = $y;
        return $this;
    }
}
