<?php

namespace NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Insert Struct
 * @subpackage Structs
 */
class Insert extends AbstractStructBase
{
    /**
     * The InsertId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InsertId;
    /**
     * The Cost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Cost;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for Insert
     * @uses Insert::setInsertId()
     * @uses Insert::setCost()
     * @uses Insert::setDescription()
     * @param int $insertId
     * @param float $cost
     * @param string $description
     */
    public function __construct($insertId = null, $cost = null, $description = null)
    {
        $this
            ->setInsertId($insertId)
            ->setCost($cost)
            ->setDescription($description);
    }
    /**
     * Get InsertId value
     * @return int
     */
    public function getInsertId()
    {
        return $this->InsertId;
    }
    /**
     * Set InsertId value
     * @param int $insertId
     * @return \NineDotMedia\Viapost\Struct\Insert
     */
    public function setInsertId($insertId = null)
    {
        // validation for constraint: int
        if (!is_null($insertId) && !(is_int($insertId) || ctype_digit($insertId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insertId, true), gettype($insertId)), __LINE__);
        }
        $this->InsertId = $insertId;
        return $this;
    }
    /**
     * Get Cost value
     * @return float
     */
    public function getCost()
    {
        return $this->Cost;
    }
    /**
     * Set Cost value
     * @param float $cost
     * @return \NineDotMedia\Viapost\Struct\Insert
     */
    public function setCost($cost = null)
    {
        // validation for constraint: float
        if (!is_null($cost) && !(is_float($cost) || is_numeric($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->Cost = $cost;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \NineDotMedia\Viapost\Struct\Insert
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
