<?php

namespace NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDocumentStickerArea Struct
 * @subpackage Structs
 */
class GetDocumentStickerArea extends AbstractStructBase
{
    /**
     * The documentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $documentType;
    /**
     * The area
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \NineDotMedia\Viapost\Struct\RectangleF
     */
    public $area;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for GetDocumentStickerArea
     * @uses GetDocumentStickerArea::setDocumentType()
     * @uses GetDocumentStickerArea::setArea()
     * @uses GetDocumentStickerArea::setReturnMessage()
     * @param string $documentType
     * @param \NineDotMedia\Viapost\Struct\RectangleF $area
     * @param string $returnMessage
     */
    public function __construct($documentType = null, \NineDotMedia\Viapost\Struct\RectangleF $area = null, $returnMessage = null)
    {
        $this
            ->setDocumentType($documentType)
            ->setArea($area)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get documentType value
     * @return string
     */
    public function getDocumentType()
    {
        return $this->documentType;
    }
    /**
     * Set documentType value
     * @uses \NineDotMedia\Viapost\Enum\DocumentType::valueIsValid()
     * @uses \NineDotMedia\Viapost\Enum\DocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentType
     * @return \NineDotMedia\Viapost\Struct\GetDocumentStickerArea
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: enumeration
        if (!\NineDotMedia\Viapost\Enum\DocumentType::valueIsValid($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \NineDotMedia\Viapost\Enum\DocumentType', is_array($documentType) ? implode(', ', $documentType) : var_export($documentType, true), implode(', ', \NineDotMedia\Viapost\Enum\DocumentType::getValidValues())), __LINE__);
        }
        $this->documentType = $documentType;
        return $this;
    }
    /**
     * Get area value
     * @return \NineDotMedia\Viapost\Struct\RectangleF
     */
    public function getArea()
    {
        return $this->area;
    }
    /**
     * Set area value
     * @param \NineDotMedia\Viapost\Struct\RectangleF $area
     * @return \NineDotMedia\Viapost\Struct\GetDocumentStickerArea
     */
    public function setArea(\NineDotMedia\Viapost\Struct\RectangleF $area = null)
    {
        $this->area = $area;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \NineDotMedia\Viapost\Struct\GetDocumentStickerArea
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
