<?php

namespace NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeletePriceBand Struct
 * @subpackage Structs
 */
class DeletePriceBand extends AbstractStructBase
{
    /**
     * The iPriceBandID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $iPriceBandID;
    /**
     * The sAffiliateGUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAffiliateGUID;
    /**
     * The sReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sReturnMessage;
    /**
     * Constructor method for DeletePriceBand
     * @uses DeletePriceBand::setIPriceBandID()
     * @uses DeletePriceBand::setSAffiliateGUID()
     * @uses DeletePriceBand::setSReturnMessage()
     * @param int $iPriceBandID
     * @param string $sAffiliateGUID
     * @param string $sReturnMessage
     */
    public function __construct($iPriceBandID = null, $sAffiliateGUID = null, $sReturnMessage = null)
    {
        $this
            ->setIPriceBandID($iPriceBandID)
            ->setSAffiliateGUID($sAffiliateGUID)
            ->setSReturnMessage($sReturnMessage);
    }
    /**
     * Get iPriceBandID value
     * @return int
     */
    public function getIPriceBandID()
    {
        return $this->iPriceBandID;
    }
    /**
     * Set iPriceBandID value
     * @param int $iPriceBandID
     * @return \NineDotMedia\Viapost\Struct\DeletePriceBand
     */
    public function setIPriceBandID($iPriceBandID = null)
    {
        // validation for constraint: int
        if (!is_null($iPriceBandID) && !(is_int($iPriceBandID) || ctype_digit($iPriceBandID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iPriceBandID, true), gettype($iPriceBandID)), __LINE__);
        }
        $this->iPriceBandID = $iPriceBandID;
        return $this;
    }
    /**
     * Get sAffiliateGUID value
     * @return string|null
     */
    public function getSAffiliateGUID()
    {
        return $this->sAffiliateGUID;
    }
    /**
     * Set sAffiliateGUID value
     * @param string $sAffiliateGUID
     * @return \NineDotMedia\Viapost\Struct\DeletePriceBand
     */
    public function setSAffiliateGUID($sAffiliateGUID = null)
    {
        // validation for constraint: string
        if (!is_null($sAffiliateGUID) && !is_string($sAffiliateGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAffiliateGUID, true), gettype($sAffiliateGUID)), __LINE__);
        }
        $this->sAffiliateGUID = $sAffiliateGUID;
        return $this;
    }
    /**
     * Get sReturnMessage value
     * @return string|null
     */
    public function getSReturnMessage()
    {
        return $this->sReturnMessage;
    }
    /**
     * Set sReturnMessage value
     * @param string $sReturnMessage
     * @return \NineDotMedia\Viapost\Struct\DeletePriceBand
     */
    public function setSReturnMessage($sReturnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sReturnMessage) && !is_string($sReturnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sReturnMessage, true), gettype($sReturnMessage)), __LINE__);
        }
        $this->sReturnMessage = $sReturnMessage;
        return $this;
    }
}
