<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \NineDotMedia\Viapost\ClassMap::get(),
);
/**
 * Samples for Service ServiceType
 */
$service = new \NineDotMedia\Viapost\Service\Service($options);
/**
 * Sample call for GetSystemID operation/method
 */
if ($service->GetSystemID(new \NineDotMedia\Viapost\Struct\GetSystemID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateLetterFromXPS operation/method
 */
if ($service->CreateLetterFromXPS(new \NineDotMedia\Viapost\Struct\CreateLetterFromXPS()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDocumentPageCountRange operation/method
 */
if ($service->GetDocumentPageCountRange(new \NineDotMedia\Viapost\Struct\GetDocumentPageCountRange()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendDriverMailingConfirmation operation/method
 */
if ($service->SendDriverMailingConfirmation(new \NineDotMedia\Viapost\Struct\SendDriverMailingConfirmation()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryInserts operation/method
 */
if ($service->GetLibraryInserts(new \NineDotMedia\Viapost\Struct\GetLibraryInserts()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetCostCentres operation/method
 */
if ($service->GetCostCentres(new \NineDotMedia\Viapost\Struct\GetCostCentres()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GenerateMappingWithDefaultNameAndMergeFields operation/method
 */
if ($service->GenerateMappingWithDefaultNameAndMergeFields(new \NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultNameAndMergeFields()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GenerateMappingWithID operation/method
 */
if ($service->GenerateMappingWithID(new \NineDotMedia\Viapost\Struct\GenerateMappingWithID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GenerateMappingWithDefaultNameWithID operation/method
 */
if ($service->GenerateMappingWithDefaultNameWithID(new \NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultNameWithID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GenerateMappingWithDefaultNameAndMergeFieldsWithID
 * operation/method
 */
if ($service->GenerateMappingWithDefaultNameAndMergeFieldsWithID(new \NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultNameAndMergeFieldsWithID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAttachment operation/method
 */
if ($service->CreateAttachment(new \NineDotMedia\Viapost\Struct\CreateAttachment()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateLetterhead operation/method
 */
if ($service->CreateLetterhead(new \NineDotMedia\Viapost\Struct\CreateLetterhead()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateLetter operation/method
 */
if ($service->CreateLetter(new \NineDotMedia\Viapost\Struct\CreateLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateMailPack operation/method
 */
if ($service->CreateMailPack(new \NineDotMedia\Viapost\Struct\CreateMailPack()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteMailPack operation/method
 */
if ($service->DeleteMailPack(new \NineDotMedia\Viapost\Struct\DeleteMailPack()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendMailPack operation/method
 */
if ($service->SendMailPack(new \NineDotMedia\Viapost\Struct\SendMailPack()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendMailPackToFindNearest operation/method
 */
if ($service->SendMailPackToFindNearest(new \NineDotMedia\Viapost\Struct\SendMailPackToFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendMailPack operation/method
 */
if ($service->CreateAndSendMailPack(new \NineDotMedia\Viapost\Struct\CreateAndSendMailPack()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendMailPackToSingleAddress2 operation/method
 */
if ($service->SendMailPackToSingleAddress2(new \NineDotMedia\Viapost\Struct\SendMailPackToSingleAddress2()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendMailPackToSingleAddress operation/method
 */
if ($service->SendMailPackToSingleAddress(new \NineDotMedia\Viapost\Struct\SendMailPackToSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendMailPackToSingleAddress operation/method
 */
if ($service->CreateAndSendMailPackToSingleAddress(new \NineDotMedia\Viapost\Struct\CreateAndSendMailPackToSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendSimpleMailing operation/method
 */
if ($service->SendSimpleMailing(new \NineDotMedia\Viapost\Struct\SendSimpleMailing()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendSimpleMailingToFindNearest operation/method
 */
if ($service->SendSimpleMailingToFindNearest(new \NineDotMedia\Viapost\Struct\SendSimpleMailingToFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendSimpleMailingToFindNearest operation/method
 */
if ($service->CreateAndSendSimpleMailingToFindNearest(new \NineDotMedia\Viapost\Struct\CreateAndSendSimpleMailingToFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendSimpleMailingToSingleAddress operation/method
 */
if ($service->SendSimpleMailingToSingleAddress(new \NineDotMedia\Viapost\Struct\SendSimpleMailingToSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendSimpleMailing operation/method
 */
if ($service->CreateAndSendSimpleMailing(new \NineDotMedia\Viapost\Struct\CreateAndSendSimpleMailing()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendSimpleMailingToSingleAddress operation/method
 */
if ($service->CreateAndSendSimpleMailingToSingleAddress(new \NineDotMedia\Viapost\Struct\CreateAndSendSimpleMailingToSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendMailPackToFindNearest operation/method
 */
if ($service->CreateAndSendMailPackToFindNearest(new \NineDotMedia\Viapost\Struct\CreateAndSendMailPackToFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddExcludedAddress operation/method
 */
if ($service->AddExcludedAddress(new \NineDotMedia\Viapost\Struct\AddExcludedAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetExcludedAddresses operation/method
 */
if ($service->GetExcludedAddresses(new \NineDotMedia\Viapost\Struct\GetExcludedAddresses()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteExcludedAddressByID operation/method
 */
if ($service->DeleteExcludedAddressByID(new \NineDotMedia\Viapost\Struct\DeleteExcludedAddressByID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for FindNearestQueryAddress operation/method
 */
if ($service->FindNearestQueryAddress(new \NineDotMedia\Viapost\Struct\FindNearestQueryAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for FindNearestExecuteSearch operation/method
 */
if ($service->FindNearestExecuteSearch(new \NineDotMedia\Viapost\Struct\FindNearestExecuteSearch()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UpdateLetter operation/method
 */
if ($service->UpdateLetter(new \NineDotMedia\Viapost\Struct\UpdateLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UpdateMailPackLetter operation/method
 */
if ($service->UpdateMailPackLetter(new \NineDotMedia\Viapost\Struct\UpdateMailPackLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UpdateMailPackTemplate operation/method
 */
if ($service->UpdateMailPackTemplate(new \NineDotMedia\Viapost\Struct\UpdateMailPackTemplate()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMailPacks operation/method
 */
if ($service->GetMailPacks(new \NineDotMedia\Viapost\Struct\GetMailPacks()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryMailPacks operation/method
 */
if ($service->GetLibraryMailPacks(new \NineDotMedia\Viapost\Struct\GetLibraryMailPacks()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreatePostcard operation/method
 */
if ($service->CreatePostcard(new \NineDotMedia\Viapost\Struct\CreatePostcard()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryPostcards operation/method
 */
if ($service->GetLibraryPostcards(new \NineDotMedia\Viapost\Struct\GetLibraryPostcards()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewLibraryPostcard operation/method
 */
if ($service->PreviewLibraryPostcard(new \NineDotMedia\Viapost\Struct\PreviewLibraryPostcard()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendPostcardToSingleAddress operation/method
 */
if ($service->SendPostcardToSingleAddress(new \NineDotMedia\Viapost\Struct\SendPostcardToSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendPostcard operation/method
 */
if ($service->SendPostcard(new \NineDotMedia\Viapost\Struct\SendPostcard()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendPostcardToFindNearest operation/method
 */
if ($service->SendPostcardToFindNearest(new \NineDotMedia\Viapost\Struct\SendPostcardToFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendPostcardToSingleAddress operation/method
 */
if ($service->CreateAndSendPostcardToSingleAddress(new \NineDotMedia\Viapost\Struct\CreateAndSendPostcardToSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendPostcard operation/method
 */
if ($service->CreateAndSendPostcard(new \NineDotMedia\Viapost\Struct\CreateAndSendPostcard()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAndSendPostcardToFindNearest operation/method
 */
if ($service->CreateAndSendPostcardToFindNearest(new \NineDotMedia\Viapost\Struct\CreateAndSendPostcardToFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateCostOfSingleAddressMailing operation/method
 */
if ($service->CalculateCostOfSingleAddressMailing(new \NineDotMedia\Viapost\Struct\CalculateCostOfSingleAddressMailing()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateCostOfMailing operation/method
 */
if ($service->CalculateCostOfMailing(new \NineDotMedia\Viapost\Struct\CalculateCostOfMailing()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateCostOfFindNearestMailing operation/method
 */
if ($service->CalculateCostOfFindNearestMailing(new \NineDotMedia\Viapost\Struct\CalculateCostOfFindNearestMailing()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryLetterheads operation/method
 */
if ($service->GetLibraryLetterheads(new \NineDotMedia\Viapost\Struct\GetLibraryLetterheads()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryAttachments operation/method
 */
if ($service->GetLibraryAttachments(new \NineDotMedia\Viapost\Struct\GetLibraryAttachments()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewLibraryLetterhead operation/method
 */
if ($service->PreviewLibraryLetterhead(new \NineDotMedia\Viapost\Struct\PreviewLibraryLetterhead()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewLibraryAttachment operation/method
 */
if ($service->PreviewLibraryAttachment(new \NineDotMedia\Viapost\Struct\PreviewLibraryAttachment()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewDocumentSingleAddress operation/method
 */
if ($service->PreviewDocumentSingleAddress(new \NineDotMedia\Viapost\Struct\PreviewDocumentSingleAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewDocumentMailingList operation/method
 */
if ($service->PreviewDocumentMailingList(new \NineDotMedia\Viapost\Struct\PreviewDocumentMailingList()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewDocumentFindNearest operation/method
 */
if ($service->PreviewDocumentFindNearest(new \NineDotMedia\Viapost\Struct\PreviewDocumentFindNearest()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryMappings operation/method
 */
if ($service->GetLibraryMappings(new \NineDotMedia\Viapost\Struct\GetLibraryMappings()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDataListUrl operation/method
 */
if ($service->GetDataListUrl(new \NineDotMedia\Viapost\Struct\GetDataListUrl()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DownloadDataList operation/method
 */
if ($service->DownloadDataList(new \NineDotMedia\Viapost\Struct\DownloadDataList()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDataLists operation/method
 */
if ($service->GetDataLists(new \NineDotMedia\Viapost\Struct\GetDataLists()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateCostOfDataList operation/method
 */
if ($service->CalculateCostOfDataList(new \NineDotMedia\Viapost\Struct\CalculateCostOfDataList()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetUserVariables operation/method
 */
if ($service->GetUserVariables(new \NineDotMedia\Viapost\Struct\GetUserVariables()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDocumentation operation/method
 */
if ($service->GetDocumentation(new \NineDotMedia\Viapost\Struct\GetDocumentation()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMailHistoryJobs operation/method
 */
if ($service->GetMailHistoryJobs(new \NineDotMedia\Viapost\Struct\GetMailHistoryJobs()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMailHistoryDocumentsByJobId operation/method
 */
if ($service->GetMailHistoryDocumentsByJobId(new \NineDotMedia\Viapost\Struct\GetMailHistoryDocumentsByJobId()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for RetryLetter operation/method
 */
if ($service->RetryLetter(new \NineDotMedia\Viapost\Struct\RetryLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetAddressesForPostcode operation/method
 */
if ($service->GetAddressesForPostcode(new \NineDotMedia\Viapost\Struct\GetAddressesForPostcode()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDocumentStickerArea operation/method
 */
if ($service->GetDocumentStickerArea(new \NineDotMedia\Viapost\Struct\GetDocumentStickerArea()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetDocumentReservedAreas operation/method
 */
if ($service->GetDocumentReservedAreas(new \NineDotMedia\Viapost\Struct\GetDocumentReservedAreas()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateCostOfNewMailing operation/method
 */
if ($service->CalculateCostOfNewMailing(new \NineDotMedia\Viapost\Struct\CalculateCostOfNewMailing()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for IsFirstClassAvailable operation/method
 */
if ($service->IsFirstClassAvailable(new \NineDotMedia\Viapost\Struct\IsFirstClassAvailable()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetUserDetails operation/method
 */
if ($service->GetUserDetails(new \NineDotMedia\Viapost\Struct\GetUserDetails()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for IsValidLoginToken operation/method
 */
if ($service->IsValidLoginToken(new \NineDotMedia\Viapost\Struct\IsValidLoginToken()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ChangePassword operation/method
 */
if ($service->ChangePassword(new \NineDotMedia\Viapost\Struct\ChangePassword()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLatestVersionDetails operation/method
 */
if ($service->GetLatestVersionDetails(new \NineDotMedia\Viapost\Struct\GetLatestVersionDetails()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetAccountUrl operation/method
 */
if ($service->GetAccountUrl(new \NineDotMedia\Viapost\Struct\GetAccountUrl()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetPortalUrl operation/method
 */
if ($service->GetPortalUrl(new \NineDotMedia\Viapost\Struct\GetPortalUrl()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewLetter operation/method
 */
if ($service->PreviewLetter(new \NineDotMedia\Viapost\Struct\PreviewLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewLibraryLetter operation/method
 */
if ($service->PreviewLibraryLetter(new \NineDotMedia\Viapost\Struct\PreviewLibraryLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for PreviewMailPack operation/method
 */
if ($service->PreviewMailPack(new \NineDotMedia\Viapost\Struct\PreviewMailPack()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SignIn operation/method
 */
if ($service->SignIn(new \NineDotMedia\Viapost\Struct\SignIn()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UploadDocument operation/method
 */
if ($service->UploadDocument(new \NineDotMedia\Viapost\Struct\UploadDocument()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SearchAddress operation/method
 */
if ($service->SearchAddress(new \NineDotMedia\Viapost\Struct\SearchAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateJobRunRecord operation/method
 */
if ($service->CreateJobRunRecord(new \NineDotMedia\Viapost\Struct\CreateJobRunRecord()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendLetterWithStructuredAddress operation/method
 */
if ($service->SendLetterWithStructuredAddress(new \NineDotMedia\Viapost\Struct\SendLetterWithStructuredAddress()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendLetterWithStructuredAddressAndExceptions operation/method
 */
if ($service->SendLetterWithStructuredAddressAndExceptions(new \NineDotMedia\Viapost\Struct\SendLetterWithStructuredAddressAndExceptions()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SendLetter operation/method
 */
if ($service->SendLetter(new \NineDotMedia\Viapost\Struct\SendLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetBalance operation/method
 */
if ($service->GetBalance(new \NineDotMedia\Viapost\Struct\GetBalance()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetAvailableFunds operation/method
 */
if ($service->GetAvailableFunds(new \NineDotMedia\Viapost\Struct\GetAvailableFunds()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLetterByID operation/method
 */
if ($service->GetLetterByID(new \NineDotMedia\Viapost\Struct\GetLetterByID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLetters operation/method
 */
if ($service->GetLetters(new \NineDotMedia\Viapost\Struct\GetLetters()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLibraryLetters operation/method
 */
if ($service->GetLibraryLetters(new \NineDotMedia\Viapost\Struct\GetLibraryLetters()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMailingLists operation/method
 */
if ($service->GetMailingLists(new \NineDotMedia\Viapost\Struct\GetMailingLists()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMailingListByID operation/method
 */
if ($service->GetMailingListByID(new \NineDotMedia\Viapost\Struct\GetMailingListByID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteMailingList operation/method
 */
if ($service->DeleteMailingList(new \NineDotMedia\Viapost\Struct\DeleteMailingList()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteMapping operation/method
 */
if ($service->DeleteMapping(new \NineDotMedia\Viapost\Struct\DeleteMapping()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteUserVariable operation/method
 */
if ($service->DeleteUserVariable(new \NineDotMedia\Viapost\Struct\DeleteUserVariable()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteLetterhead operation/method
 */
if ($service->DeleteLetterhead(new \NineDotMedia\Viapost\Struct\DeleteLetterhead()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteLetter operation/method
 */
if ($service->DeleteLetter(new \NineDotMedia\Viapost\Struct\DeleteLetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteAttachment operation/method
 */
if ($service->DeleteAttachment(new \NineDotMedia\Viapost\Struct\DeleteAttachment()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeletePostcard operation/method
 */
if ($service->DeletePostcard(new \NineDotMedia\Viapost\Struct\DeletePostcard()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UploadMailingList operation/method
 */
if ($service->UploadMailingList(new \NineDotMedia\Viapost\Struct\UploadMailingList()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UploadMailingListWithMapping operation/method
 */
if ($service->UploadMailingListWithMapping(new \NineDotMedia\Viapost\Struct\UploadMailingListWithMapping()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UploadMailingListWithMappingAndShare operation/method
 */
if ($service->UploadMailingListWithMappingAndShare(new \NineDotMedia\Viapost\Struct\UploadMailingListWithMappingAndShare()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for UploadConsolidatedPDF operation/method
 */
if ($service->UploadConsolidatedPDF(new \NineDotMedia\Viapost\Struct\UploadConsolidatedPDF()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for MailMerge operation/method
 */
if ($service->MailMerge(new \NineDotMedia\Viapost\Struct\MailMerge()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for MailMergeWithExceptionsAndConfirmationEmails operation/method
 */
if ($service->MailMergeWithExceptionsAndConfirmationEmails(new \NineDotMedia\Viapost\Struct\MailMergeWithExceptionsAndConfirmationEmails()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for MailMergeWithExceptions operation/method
 */
if ($service->MailMergeWithExceptions(new \NineDotMedia\Viapost\Struct\MailMergeWithExceptions()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAccount operation/method
 */
if ($service->CreateAccount(new \NineDotMedia\Viapost\Struct\CreateAccount()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreateAccountNonUK operation/method
 */
if ($service->CreateAccountNonUK(new \NineDotMedia\Viapost\Struct\CreateAccountNonUK()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddUserToAccount operation/method
 */
if ($service->AddUserToAccount(new \NineDotMedia\Viapost\Struct\AddUserToAccount()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddUserToAccountPermissions operation/method
 */
if ($service->AddUserToAccountPermissions(new \NineDotMedia\Viapost\Struct\AddUserToAccountPermissions()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddUserToAccountNonUK operation/method
 */
if ($service->AddUserToAccountNonUK(new \NineDotMedia\Viapost\Struct\AddUserToAccountNonUK()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AddUserToAccountNonUKPermissions operation/method
 */
if ($service->AddUserToAccountNonUKPermissions(new \NineDotMedia\Viapost\Struct\AddUserToAccountNonUKPermissions()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateLetterCostComplexBatchWithExceptions operation/method
 */
if ($service->CalculateLetterCostComplexBatchWithExceptions(new \NineDotMedia\Viapost\Struct\CalculateLetterCostComplexBatchWithExceptions()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateLetterCostSimpleBatch operation/method
 */
if ($service->CalculateLetterCostSimpleBatch(new \NineDotMedia\Viapost\Struct\CalculateLetterCostSimpleBatch()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateLetterCostSimpleBatchWithExceptions operation/method
 */
if ($service->CalculateLetterCostSimpleBatchWithExceptions(new \NineDotMedia\Viapost\Struct\CalculateLetterCostSimpleBatchWithExceptions()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateLetterCostComplexBatch operation/method
 */
if ($service->CalculateLetterCostComplexBatch(new \NineDotMedia\Viapost\Struct\CalculateLetterCostComplexBatch()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateMailMergeCost operation/method
 */
if ($service->CalculateMailMergeCost(new \NineDotMedia\Viapost\Struct\CalculateMailMergeCost()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateEstimatedDeliveryDate operation/method
 */
if ($service->CalculateEstimatedDeliveryDate(new \NineDotMedia\Viapost\Struct\CalculateEstimatedDeliveryDate()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateEstimatedDeliveryDateNow operation/method
 */
if ($service->CalculateEstimatedDeliveryDateNow(new \NineDotMedia\Viapost\Struct\CalculateEstimatedDeliveryDateNow()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CalculateSendDateForDeliveryDate operation/method
 */
if ($service->CalculateSendDateForDeliveryDate(new \NineDotMedia\Viapost\Struct\CalculateSendDateForDeliveryDate()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLetterStatusByLetterID operation/method
 */
if ($service->GetLetterStatusByLetterID(new \NineDotMedia\Viapost\Struct\GetLetterStatusByLetterID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetLetterStatusByCustomerAPILetter operation/method
 */
if ($service->GetLetterStatusByCustomerAPILetter(new \NineDotMedia\Viapost\Struct\GetLetterStatusByCustomerAPILetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteLetterByLetterID operation/method
 */
if ($service->DeleteLetterByLetterID(new \NineDotMedia\Viapost\Struct\DeleteLetterByLetterID()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeleteLetterByCustomerAPILetter operation/method
 */
if ($service->DeleteLetterByCustomerAPILetter(new \NineDotMedia\Viapost\Struct\DeleteLetterByCustomerAPILetter()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CreatePriceBand operation/method
 */
if ($service->CreatePriceBand(new \NineDotMedia\Viapost\Struct\CreatePriceBand()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for AssignPriceBand operation/method
 */
if ($service->AssignPriceBand(new \NineDotMedia\Viapost\Struct\AssignPriceBand()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetPriceBands operation/method
 */
if ($service->GetPriceBands(new \NineDotMedia\Viapost\Struct\GetPriceBands()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeletePriceBand operation/method
 */
if ($service->DeletePriceBand(new \NineDotMedia\Viapost\Struct\DeletePriceBand()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetCountries operation/method
 */
if ($service->GetCountries(new \NineDotMedia\Viapost\Struct\GetCountries()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DisableUser operation/method
 */
if ($service->DisableUser(new \NineDotMedia\Viapost\Struct\DisableUser()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetMessage operation/method
 */
if ($service->GetMessage(new \NineDotMedia\Viapost\Struct\GetMessage()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GenerateMapping operation/method
 */
if ($service->GenerateMapping(new \NineDotMedia\Viapost\Struct\GenerateMapping()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GenerateMappingWithDefaultName operation/method
 */
if ($service->GenerateMappingWithDefaultName(new \NineDotMedia\Viapost\Struct\GenerateMappingWithDefaultName()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
