<?php

namespace NineDotMedia\Viapost\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreviewMailPack Struct
 * @subpackage Structs
 */
class PreviewMailPack extends AbstractStructBase
{
    /**
     * The jobId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $jobId;
    /**
     * The LoginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginToken;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \NineDotMedia\Viapost\Struct\PostalAddress
     */
    public $Address;
    /**
     * The letterData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $letterData;
    /**
     * The ReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnMessage;
    /**
     * Constructor method for PreviewMailPack
     * @uses PreviewMailPack::setJobId()
     * @uses PreviewMailPack::setLoginToken()
     * @uses PreviewMailPack::setAddress()
     * @uses PreviewMailPack::setLetterData()
     * @uses PreviewMailPack::setReturnMessage()
     * @param int $jobId
     * @param string $loginToken
     * @param \NineDotMedia\Viapost\Struct\PostalAddress $address
     * @param string $letterData
     * @param string $returnMessage
     */
    public function __construct($jobId = null, $loginToken = null, \NineDotMedia\Viapost\Struct\PostalAddress $address = null, $letterData = null, $returnMessage = null)
    {
        $this
            ->setJobId($jobId)
            ->setLoginToken($loginToken)
            ->setAddress($address)
            ->setLetterData($letterData)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get jobId value
     * @return int
     */
    public function getJobId()
    {
        return $this->jobId;
    }
    /**
     * Set jobId value
     * @param int $jobId
     * @return \NineDotMedia\Viapost\Struct\PreviewMailPack
     */
    public function setJobId($jobId = null)
    {
        // validation for constraint: int
        if (!is_null($jobId) && !(is_int($jobId) || ctype_digit($jobId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jobId, true), gettype($jobId)), __LINE__);
        }
        $this->jobId = $jobId;
        return $this;
    }
    /**
     * Get LoginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->LoginToken;
    }
    /**
     * Set LoginToken value
     * @param string $loginToken
     * @return \NineDotMedia\Viapost\Struct\PreviewMailPack
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->LoginToken = $loginToken;
        return $this;
    }
    /**
     * Get Address value
     * @return \NineDotMedia\Viapost\Struct\PostalAddress|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \NineDotMedia\Viapost\Struct\PostalAddress $address
     * @return \NineDotMedia\Viapost\Struct\PreviewMailPack
     */
    public function setAddress(\NineDotMedia\Viapost\Struct\PostalAddress $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get letterData value
     * @return string|null
     */
    public function getLetterData()
    {
        return $this->letterData;
    }
    /**
     * Set letterData value
     * @param string $letterData
     * @return \NineDotMedia\Viapost\Struct\PreviewMailPack
     */
    public function setLetterData($letterData = null)
    {
        // validation for constraint: string
        if (!is_null($letterData) && !is_string($letterData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($letterData, true), gettype($letterData)), __LINE__);
        }
        $this->letterData = $letterData;
        return $this;
    }
    /**
     * Get ReturnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->ReturnMessage;
    }
    /**
     * Set ReturnMessage value
     * @param string $returnMessage
     * @return \NineDotMedia\Viapost\Struct\PreviewMailPack
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->ReturnMessage = $returnMessage;
        return $this;
    }
}
