<?php

namespace NineDotMedia\viapost-php\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadDocumentResponse Struct
 * @subpackage Structs
 */
class UploadDocumentResponse extends AbstractStructBase
{
    /**
     * The UploadDocumentResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UploadDocumentResult;
    /**
     * The LetterID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LetterID;
    /**
     * The sReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sReturnMessage;
    /**
     * Constructor method for UploadDocumentResponse
     * @uses UploadDocumentResponse::setUploadDocumentResult()
     * @uses UploadDocumentResponse::setLetterID()
     * @uses UploadDocumentResponse::setSReturnMessage()
     * @param bool $uploadDocumentResult
     * @param int $letterID
     * @param string $sReturnMessage
     */
    public function __construct($uploadDocumentResult = null, $letterID = null, $sReturnMessage = null)
    {
        $this
            ->setUploadDocumentResult($uploadDocumentResult)
            ->setLetterID($letterID)
            ->setSReturnMessage($sReturnMessage);
    }
    /**
     * Get UploadDocumentResult value
     * @return bool
     */
    public function getUploadDocumentResult()
    {
        return $this->UploadDocumentResult;
    }
    /**
     * Set UploadDocumentResult value
     * @param bool $uploadDocumentResult
     * @return \NineDotMedia\viapost-php\Struct\UploadDocumentResponse
     */
    public function setUploadDocumentResult($uploadDocumentResult = null)
    {
        // validation for constraint: boolean
        if (!is_null($uploadDocumentResult) && !is_bool($uploadDocumentResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($uploadDocumentResult, true), gettype($uploadDocumentResult)), __LINE__);
        }
        $this->UploadDocumentResult = $uploadDocumentResult;
        return $this;
    }
    /**
     * Get LetterID value
     * @return int
     */
    public function getLetterID()
    {
        return $this->LetterID;
    }
    /**
     * Set LetterID value
     * @param int $letterID
     * @return \NineDotMedia\viapost-php\Struct\UploadDocumentResponse
     */
    public function setLetterID($letterID = null)
    {
        // validation for constraint: int
        if (!is_null($letterID) && !(is_int($letterID) || ctype_digit($letterID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($letterID, true), gettype($letterID)), __LINE__);
        }
        $this->LetterID = $letterID;
        return $this;
    }
    /**
     * Get sReturnMessage value
     * @return string|null
     */
    public function getSReturnMessage()
    {
        return $this->sReturnMessage;
    }
    /**
     * Set sReturnMessage value
     * @param string $sReturnMessage
     * @return \NineDotMedia\viapost-php\Struct\UploadDocumentResponse
     */
    public function setSReturnMessage($sReturnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sReturnMessage) && !is_string($sReturnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sReturnMessage, true), gettype($sReturnMessage)), __LINE__);
        }
        $this->sReturnMessage = $sReturnMessage;
        return $this;
    }
}
