<?php

namespace NineDotMedia\viapost-php\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendPostcardToFindNearest Struct
 * @subpackage Structs
 */
class SendPostcardToFindNearest extends AbstractStructBase
{
    /**
     * The postcardID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $postcardID;
    /**
     * The numberOfAddressesToSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfAddressesToSearch;
    /**
     * The radiusOfAreaToSearchInMetres
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $radiusOfAreaToSearchInMetres;
    /**
     * The includeThisAddressInResults
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $includeThisAddressInResults;
    /**
     * The onlyAddressesInThisStreet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $onlyAddressesInThisStreet;
    /**
     * The addressTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $addressTypes;
    /**
     * The sendNow
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $sendNow;
    /**
     * The dateToSend
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dateToSend;
    /**
     * The emailNotification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $emailNotification;
    /**
     * The costOfMailing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $costOfMailing;
    /**
     * The numberOfPages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfPages;
    /**
     * The numberOfSheets
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfSheets;
    /**
     * The numberOfAddressesSentTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numberOfAddressesSentTo;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The addresseeTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $addresseeTitle;
    /**
     * The houseNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $houseNumber;
    /**
     * The houseName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $houseName;
    /**
     * The organisation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $organisation;
    /**
     * The postCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postCode;
    /**
     * The firstClassStr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstClassStr;
    /**
     * The costCentreStr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $costCentreStr;
    /**
     * The affiliateGUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $affiliateGUID;
    /**
     * The mailingNameOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mailingNameOverride;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for SendPostcardToFindNearest
     * @uses SendPostcardToFindNearest::setPostcardID()
     * @uses SendPostcardToFindNearest::setNumberOfAddressesToSearch()
     * @uses SendPostcardToFindNearest::setRadiusOfAreaToSearchInMetres()
     * @uses SendPostcardToFindNearest::setIncludeThisAddressInResults()
     * @uses SendPostcardToFindNearest::setOnlyAddressesInThisStreet()
     * @uses SendPostcardToFindNearest::setAddressTypes()
     * @uses SendPostcardToFindNearest::setSendNow()
     * @uses SendPostcardToFindNearest::setDateToSend()
     * @uses SendPostcardToFindNearest::setEmailNotification()
     * @uses SendPostcardToFindNearest::setCostOfMailing()
     * @uses SendPostcardToFindNearest::setNumberOfPages()
     * @uses SendPostcardToFindNearest::setNumberOfSheets()
     * @uses SendPostcardToFindNearest::setNumberOfAddressesSentTo()
     * @uses SendPostcardToFindNearest::setLoginToken()
     * @uses SendPostcardToFindNearest::setAddresseeTitle()
     * @uses SendPostcardToFindNearest::setHouseNumber()
     * @uses SendPostcardToFindNearest::setHouseName()
     * @uses SendPostcardToFindNearest::setOrganisation()
     * @uses SendPostcardToFindNearest::setPostCode()
     * @uses SendPostcardToFindNearest::setFirstClassStr()
     * @uses SendPostcardToFindNearest::setCostCentreStr()
     * @uses SendPostcardToFindNearest::setAffiliateGUID()
     * @uses SendPostcardToFindNearest::setMailingNameOverride()
     * @uses SendPostcardToFindNearest::setReturnMessage()
     * @param int $postcardID
     * @param int $numberOfAddressesToSearch
     * @param int $radiusOfAreaToSearchInMetres
     * @param bool $includeThisAddressInResults
     * @param bool $onlyAddressesInThisStreet
     * @param string $addressTypes
     * @param bool $sendNow
     * @param string $dateToSend
     * @param bool $emailNotification
     * @param float $costOfMailing
     * @param int $numberOfPages
     * @param int $numberOfSheets
     * @param int $numberOfAddressesSentTo
     * @param string $loginToken
     * @param string $addresseeTitle
     * @param string $houseNumber
     * @param string $houseName
     * @param string $organisation
     * @param string $postCode
     * @param string $firstClassStr
     * @param string $costCentreStr
     * @param string $affiliateGUID
     * @param string $mailingNameOverride
     * @param string $returnMessage
     */
    public function __construct($postcardID = null, $numberOfAddressesToSearch = null, $radiusOfAreaToSearchInMetres = null, $includeThisAddressInResults = null, $onlyAddressesInThisStreet = null, $addressTypes = null, $sendNow = null, $dateToSend = null, $emailNotification = null, $costOfMailing = null, $numberOfPages = null, $numberOfSheets = null, $numberOfAddressesSentTo = null, $loginToken = null, $addresseeTitle = null, $houseNumber = null, $houseName = null, $organisation = null, $postCode = null, $firstClassStr = null, $costCentreStr = null, $affiliateGUID = null, $mailingNameOverride = null, $returnMessage = null)
    {
        $this
            ->setPostcardID($postcardID)
            ->setNumberOfAddressesToSearch($numberOfAddressesToSearch)
            ->setRadiusOfAreaToSearchInMetres($radiusOfAreaToSearchInMetres)
            ->setIncludeThisAddressInResults($includeThisAddressInResults)
            ->setOnlyAddressesInThisStreet($onlyAddressesInThisStreet)
            ->setAddressTypes($addressTypes)
            ->setSendNow($sendNow)
            ->setDateToSend($dateToSend)
            ->setEmailNotification($emailNotification)
            ->setCostOfMailing($costOfMailing)
            ->setNumberOfPages($numberOfPages)
            ->setNumberOfSheets($numberOfSheets)
            ->setNumberOfAddressesSentTo($numberOfAddressesSentTo)
            ->setLoginToken($loginToken)
            ->setAddresseeTitle($addresseeTitle)
            ->setHouseNumber($houseNumber)
            ->setHouseName($houseName)
            ->setOrganisation($organisation)
            ->setPostCode($postCode)
            ->setFirstClassStr($firstClassStr)
            ->setCostCentreStr($costCentreStr)
            ->setAffiliateGUID($affiliateGUID)
            ->setMailingNameOverride($mailingNameOverride)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get postcardID value
     * @return int
     */
    public function getPostcardID()
    {
        return $this->postcardID;
    }
    /**
     * Set postcardID value
     * @param int $postcardID
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setPostcardID($postcardID = null)
    {
        // validation for constraint: int
        if (!is_null($postcardID) && !(is_int($postcardID) || ctype_digit($postcardID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($postcardID, true), gettype($postcardID)), __LINE__);
        }
        $this->postcardID = $postcardID;
        return $this;
    }
    /**
     * Get numberOfAddressesToSearch value
     * @return int
     */
    public function getNumberOfAddressesToSearch()
    {
        return $this->numberOfAddressesToSearch;
    }
    /**
     * Set numberOfAddressesToSearch value
     * @param int $numberOfAddressesToSearch
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setNumberOfAddressesToSearch($numberOfAddressesToSearch = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfAddressesToSearch) && !(is_int($numberOfAddressesToSearch) || ctype_digit($numberOfAddressesToSearch))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfAddressesToSearch, true), gettype($numberOfAddressesToSearch)), __LINE__);
        }
        $this->numberOfAddressesToSearch = $numberOfAddressesToSearch;
        return $this;
    }
    /**
     * Get radiusOfAreaToSearchInMetres value
     * @return int
     */
    public function getRadiusOfAreaToSearchInMetres()
    {
        return $this->radiusOfAreaToSearchInMetres;
    }
    /**
     * Set radiusOfAreaToSearchInMetres value
     * @param int $radiusOfAreaToSearchInMetres
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setRadiusOfAreaToSearchInMetres($radiusOfAreaToSearchInMetres = null)
    {
        // validation for constraint: int
        if (!is_null($radiusOfAreaToSearchInMetres) && !(is_int($radiusOfAreaToSearchInMetres) || ctype_digit($radiusOfAreaToSearchInMetres))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($radiusOfAreaToSearchInMetres, true), gettype($radiusOfAreaToSearchInMetres)), __LINE__);
        }
        $this->radiusOfAreaToSearchInMetres = $radiusOfAreaToSearchInMetres;
        return $this;
    }
    /**
     * Get includeThisAddressInResults value
     * @return bool
     */
    public function getIncludeThisAddressInResults()
    {
        return $this->includeThisAddressInResults;
    }
    /**
     * Set includeThisAddressInResults value
     * @param bool $includeThisAddressInResults
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setIncludeThisAddressInResults($includeThisAddressInResults = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeThisAddressInResults) && !is_bool($includeThisAddressInResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeThisAddressInResults, true), gettype($includeThisAddressInResults)), __LINE__);
        }
        $this->includeThisAddressInResults = $includeThisAddressInResults;
        return $this;
    }
    /**
     * Get onlyAddressesInThisStreet value
     * @return bool
     */
    public function getOnlyAddressesInThisStreet()
    {
        return $this->onlyAddressesInThisStreet;
    }
    /**
     * Set onlyAddressesInThisStreet value
     * @param bool $onlyAddressesInThisStreet
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setOnlyAddressesInThisStreet($onlyAddressesInThisStreet = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyAddressesInThisStreet) && !is_bool($onlyAddressesInThisStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyAddressesInThisStreet, true), gettype($onlyAddressesInThisStreet)), __LINE__);
        }
        $this->onlyAddressesInThisStreet = $onlyAddressesInThisStreet;
        return $this;
    }
    /**
     * Get addressTypes value
     * @return string
     */
    public function getAddressTypes()
    {
        return $this->addressTypes;
    }
    /**
     * Set addressTypes value
     * @uses \NineDotMedia\viapost-php\Enum\FindNearestAddressTypes::valueIsValid()
     * @uses \NineDotMedia\viapost-php\Enum\FindNearestAddressTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addressTypes
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setAddressTypes($addressTypes = null)
    {
        // validation for constraint: enumeration
        if (!\NineDotMedia\viapost-php\Enum\FindNearestAddressTypes::valueIsValid($addressTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \NineDotMedia\viapost-php\Enum\FindNearestAddressTypes', is_array($addressTypes) ? implode(', ', $addressTypes) : var_export($addressTypes, true), implode(', ', \NineDotMedia\viapost-php\Enum\FindNearestAddressTypes::getValidValues())), __LINE__);
        }
        $this->addressTypes = $addressTypes;
        return $this;
    }
    /**
     * Get sendNow value
     * @return bool
     */
    public function getSendNow()
    {
        return $this->sendNow;
    }
    /**
     * Set sendNow value
     * @param bool $sendNow
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setSendNow($sendNow = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendNow) && !is_bool($sendNow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendNow, true), gettype($sendNow)), __LINE__);
        }
        $this->sendNow = $sendNow;
        return $this;
    }
    /**
     * Get dateToSend value
     * @return string
     */
    public function getDateToSend()
    {
        return $this->dateToSend;
    }
    /**
     * Set dateToSend value
     * @param string $dateToSend
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setDateToSend($dateToSend = null)
    {
        // validation for constraint: string
        if (!is_null($dateToSend) && !is_string($dateToSend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateToSend, true), gettype($dateToSend)), __LINE__);
        }
        $this->dateToSend = $dateToSend;
        return $this;
    }
    /**
     * Get emailNotification value
     * @return bool
     */
    public function getEmailNotification()
    {
        return $this->emailNotification;
    }
    /**
     * Set emailNotification value
     * @param bool $emailNotification
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setEmailNotification($emailNotification = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailNotification) && !is_bool($emailNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emailNotification, true), gettype($emailNotification)), __LINE__);
        }
        $this->emailNotification = $emailNotification;
        return $this;
    }
    /**
     * Get costOfMailing value
     * @return float
     */
    public function getCostOfMailing()
    {
        return $this->costOfMailing;
    }
    /**
     * Set costOfMailing value
     * @param float $costOfMailing
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setCostOfMailing($costOfMailing = null)
    {
        // validation for constraint: float
        if (!is_null($costOfMailing) && !(is_float($costOfMailing) || is_numeric($costOfMailing))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costOfMailing, true), gettype($costOfMailing)), __LINE__);
        }
        $this->costOfMailing = $costOfMailing;
        return $this;
    }
    /**
     * Get numberOfPages value
     * @return int
     */
    public function getNumberOfPages()
    {
        return $this->numberOfPages;
    }
    /**
     * Set numberOfPages value
     * @param int $numberOfPages
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setNumberOfPages($numberOfPages = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPages) && !(is_int($numberOfPages) || ctype_digit($numberOfPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPages, true), gettype($numberOfPages)), __LINE__);
        }
        $this->numberOfPages = $numberOfPages;
        return $this;
    }
    /**
     * Get numberOfSheets value
     * @return int
     */
    public function getNumberOfSheets()
    {
        return $this->numberOfSheets;
    }
    /**
     * Set numberOfSheets value
     * @param int $numberOfSheets
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setNumberOfSheets($numberOfSheets = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfSheets) && !(is_int($numberOfSheets) || ctype_digit($numberOfSheets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfSheets, true), gettype($numberOfSheets)), __LINE__);
        }
        $this->numberOfSheets = $numberOfSheets;
        return $this;
    }
    /**
     * Get numberOfAddressesSentTo value
     * @return int
     */
    public function getNumberOfAddressesSentTo()
    {
        return $this->numberOfAddressesSentTo;
    }
    /**
     * Set numberOfAddressesSentTo value
     * @param int $numberOfAddressesSentTo
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setNumberOfAddressesSentTo($numberOfAddressesSentTo = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfAddressesSentTo) && !(is_int($numberOfAddressesSentTo) || ctype_digit($numberOfAddressesSentTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfAddressesSentTo, true), gettype($numberOfAddressesSentTo)), __LINE__);
        }
        $this->numberOfAddressesSentTo = $numberOfAddressesSentTo;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get addresseeTitle value
     * @return string|null
     */
    public function getAddresseeTitle()
    {
        return $this->addresseeTitle;
    }
    /**
     * Set addresseeTitle value
     * @param string $addresseeTitle
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setAddresseeTitle($addresseeTitle = null)
    {
        // validation for constraint: string
        if (!is_null($addresseeTitle) && !is_string($addresseeTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addresseeTitle, true), gettype($addresseeTitle)), __LINE__);
        }
        $this->addresseeTitle = $addresseeTitle;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNumber, true), gettype($houseNumber)), __LINE__);
        }
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get houseName value
     * @return string|null
     */
    public function getHouseName()
    {
        return $this->houseName;
    }
    /**
     * Set houseName value
     * @param string $houseName
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setHouseName($houseName = null)
    {
        // validation for constraint: string
        if (!is_null($houseName) && !is_string($houseName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseName, true), gettype($houseName)), __LINE__);
        }
        $this->houseName = $houseName;
        return $this;
    }
    /**
     * Get organisation value
     * @return string|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param string $organisation
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setOrganisation($organisation = null)
    {
        // validation for constraint: string
        if (!is_null($organisation) && !is_string($organisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organisation, true), gettype($organisation)), __LINE__);
        }
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get postCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->postCode;
    }
    /**
     * Set postCode value
     * @param string $postCode
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postCode, true), gettype($postCode)), __LINE__);
        }
        $this->postCode = $postCode;
        return $this;
    }
    /**
     * Get firstClassStr value
     * @return string|null
     */
    public function getFirstClassStr()
    {
        return $this->firstClassStr;
    }
    /**
     * Set firstClassStr value
     * @param string $firstClassStr
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setFirstClassStr($firstClassStr = null)
    {
        // validation for constraint: string
        if (!is_null($firstClassStr) && !is_string($firstClassStr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstClassStr, true), gettype($firstClassStr)), __LINE__);
        }
        $this->firstClassStr = $firstClassStr;
        return $this;
    }
    /**
     * Get costCentreStr value
     * @return string|null
     */
    public function getCostCentreStr()
    {
        return $this->costCentreStr;
    }
    /**
     * Set costCentreStr value
     * @param string $costCentreStr
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setCostCentreStr($costCentreStr = null)
    {
        // validation for constraint: string
        if (!is_null($costCentreStr) && !is_string($costCentreStr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costCentreStr, true), gettype($costCentreStr)), __LINE__);
        }
        $this->costCentreStr = $costCentreStr;
        return $this;
    }
    /**
     * Get affiliateGUID value
     * @return string|null
     */
    public function getAffiliateGUID()
    {
        return $this->affiliateGUID;
    }
    /**
     * Set affiliateGUID value
     * @param string $affiliateGUID
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setAffiliateGUID($affiliateGUID = null)
    {
        // validation for constraint: string
        if (!is_null($affiliateGUID) && !is_string($affiliateGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($affiliateGUID, true), gettype($affiliateGUID)), __LINE__);
        }
        $this->affiliateGUID = $affiliateGUID;
        return $this;
    }
    /**
     * Get mailingNameOverride value
     * @return string|null
     */
    public function getMailingNameOverride()
    {
        return $this->mailingNameOverride;
    }
    /**
     * Set mailingNameOverride value
     * @param string $mailingNameOverride
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setMailingNameOverride($mailingNameOverride = null)
    {
        // validation for constraint: string
        if (!is_null($mailingNameOverride) && !is_string($mailingNameOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailingNameOverride, true), gettype($mailingNameOverride)), __LINE__);
        }
        $this->mailingNameOverride = $mailingNameOverride;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \NineDotMedia\viapost-php\Struct\SendPostcardToFindNearest
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
