<?php

namespace NineDotMedia\viapost-php\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreviewLibraryLetter Struct
 * @subpackage Structs
 */
class PreviewLibraryLetter extends AbstractStructBase
{
    /**
     * The letterId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $letterId;
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $format;
    /**
     * The pageNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pageNumber;
    /**
     * The letterData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $letterData;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for PreviewLibraryLetter
     * @uses PreviewLibraryLetter::setLetterId()
     * @uses PreviewLibraryLetter::setLoginToken()
     * @uses PreviewLibraryLetter::setFormat()
     * @uses PreviewLibraryLetter::setPageNumber()
     * @uses PreviewLibraryLetter::setLetterData()
     * @uses PreviewLibraryLetter::setReturnMessage()
     * @param int $letterId
     * @param string $loginToken
     * @param string $format
     * @param string $pageNumber
     * @param string $letterData
     * @param string $returnMessage
     */
    public function __construct($letterId = null, $loginToken = null, $format = null, $pageNumber = null, $letterData = null, $returnMessage = null)
    {
        $this
            ->setLetterId($letterId)
            ->setLoginToken($loginToken)
            ->setFormat($format)
            ->setPageNumber($pageNumber)
            ->setLetterData($letterData)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get letterId value
     * @return int
     */
    public function getLetterId()
    {
        return $this->letterId;
    }
    /**
     * Set letterId value
     * @param int $letterId
     * @return \NineDotMedia\viapost-php\Struct\PreviewLibraryLetter
     */
    public function setLetterId($letterId = null)
    {
        // validation for constraint: int
        if (!is_null($letterId) && !(is_int($letterId) || ctype_digit($letterId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($letterId, true), gettype($letterId)), __LINE__);
        }
        $this->letterId = $letterId;
        return $this;
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \NineDotMedia\viapost-php\Struct\PreviewLibraryLetter
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param string $format
     * @return \NineDotMedia\viapost-php\Struct\PreviewLibraryLetter
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get pageNumber value
     * @return string|null
     */
    public function getPageNumber()
    {
        return $this->pageNumber;
    }
    /**
     * Set pageNumber value
     * @param string $pageNumber
     * @return \NineDotMedia\viapost-php\Struct\PreviewLibraryLetter
     */
    public function setPageNumber($pageNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pageNumber) && !is_string($pageNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pageNumber, true), gettype($pageNumber)), __LINE__);
        }
        $this->pageNumber = $pageNumber;
        return $this;
    }
    /**
     * Get letterData value
     * @return string|null
     */
    public function getLetterData()
    {
        return $this->letterData;
    }
    /**
     * Set letterData value
     * @param string $letterData
     * @return \NineDotMedia\viapost-php\Struct\PreviewLibraryLetter
     */
    public function setLetterData($letterData = null)
    {
        // validation for constraint: string
        if (!is_null($letterData) && !is_string($letterData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($letterData, true), gettype($letterData)), __LINE__);
        }
        $this->letterData = $letterData;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \NineDotMedia\viapost-php\Struct\PreviewLibraryLetter
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
