<?php

namespace NineDotMedia\viapost-php\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MailMerge Struct
 * @subpackage Structs
 */
class MailMerge extends AbstractStructBase
{
    /**
     * The sLoginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLoginToken;
    /**
     * The myCustomerAPILetter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \NineDotMedia\viapost-php\Struct\CustomerAPILetter
     */
    public $myCustomerAPILetter;
    /**
     * The myCustomerAPIMailingList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \NineDotMedia\viapost-php\Struct\CustomerAPIMailingList
     */
    public $myCustomerAPIMailingList;
    /**
     * The sReturnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sReturnMessage;
    /**
     * Constructor method for MailMerge
     * @uses MailMerge::setSLoginToken()
     * @uses MailMerge::setMyCustomerAPILetter()
     * @uses MailMerge::setMyCustomerAPIMailingList()
     * @uses MailMerge::setSReturnMessage()
     * @param string $sLoginToken
     * @param \NineDotMedia\viapost-php\Struct\CustomerAPILetter $myCustomerAPILetter
     * @param \NineDotMedia\viapost-php\Struct\CustomerAPIMailingList $myCustomerAPIMailingList
     * @param string $sReturnMessage
     */
    public function __construct($sLoginToken = null, \NineDotMedia\viapost-php\Struct\CustomerAPILetter $myCustomerAPILetter = null, \NineDotMedia\viapost-php\Struct\CustomerAPIMailingList $myCustomerAPIMailingList = null, $sReturnMessage = null)
    {
        $this
            ->setSLoginToken($sLoginToken)
            ->setMyCustomerAPILetter($myCustomerAPILetter)
            ->setMyCustomerAPIMailingList($myCustomerAPIMailingList)
            ->setSReturnMessage($sReturnMessage);
    }
    /**
     * Get sLoginToken value
     * @return string|null
     */
    public function getSLoginToken()
    {
        return $this->sLoginToken;
    }
    /**
     * Set sLoginToken value
     * @param string $sLoginToken
     * @return \NineDotMedia\viapost-php\Struct\MailMerge
     */
    public function setSLoginToken($sLoginToken = null)
    {
        // validation for constraint: string
        if (!is_null($sLoginToken) && !is_string($sLoginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLoginToken, true), gettype($sLoginToken)), __LINE__);
        }
        $this->sLoginToken = $sLoginToken;
        return $this;
    }
    /**
     * Get myCustomerAPILetter value
     * @return \NineDotMedia\viapost-php\Struct\CustomerAPILetter|null
     */
    public function getMyCustomerAPILetter()
    {
        return $this->myCustomerAPILetter;
    }
    /**
     * Set myCustomerAPILetter value
     * @param \NineDotMedia\viapost-php\Struct\CustomerAPILetter $myCustomerAPILetter
     * @return \NineDotMedia\viapost-php\Struct\MailMerge
     */
    public function setMyCustomerAPILetter(\NineDotMedia\viapost-php\Struct\CustomerAPILetter $myCustomerAPILetter = null)
    {
        $this->myCustomerAPILetter = $myCustomerAPILetter;
        return $this;
    }
    /**
     * Get myCustomerAPIMailingList value
     * @return \NineDotMedia\viapost-php\Struct\CustomerAPIMailingList|null
     */
    public function getMyCustomerAPIMailingList()
    {
        return $this->myCustomerAPIMailingList;
    }
    /**
     * Set myCustomerAPIMailingList value
     * @param \NineDotMedia\viapost-php\Struct\CustomerAPIMailingList $myCustomerAPIMailingList
     * @return \NineDotMedia\viapost-php\Struct\MailMerge
     */
    public function setMyCustomerAPIMailingList(\NineDotMedia\viapost-php\Struct\CustomerAPIMailingList $myCustomerAPIMailingList = null)
    {
        $this->myCustomerAPIMailingList = $myCustomerAPIMailingList;
        return $this;
    }
    /**
     * Get sReturnMessage value
     * @return string|null
     */
    public function getSReturnMessage()
    {
        return $this->sReturnMessage;
    }
    /**
     * Set sReturnMessage value
     * @param string $sReturnMessage
     * @return \NineDotMedia\viapost-php\Struct\MailMerge
     */
    public function setSReturnMessage($sReturnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sReturnMessage) && !is_string($sReturnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sReturnMessage, true), gettype($sReturnMessage)), __LINE__);
        }
        $this->sReturnMessage = $sReturnMessage;
        return $this;
    }
}
