<?php

namespace NineDotMedia\viapost-php\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDataLists Struct
 * @subpackage Structs
 */
class GetDataLists extends AbstractStructBase
{
    /**
     * The loginToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginToken;
    /**
     * The urlType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urlType;
    /**
     * The dataLists
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \NineDotMedia\viapost-php\Array\ArrayOfAnyType
     */
    public $dataLists;
    /**
     * The returnMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnMessage;
    /**
     * Constructor method for GetDataLists
     * @uses GetDataLists::setLoginToken()
     * @uses GetDataLists::setUrlType()
     * @uses GetDataLists::setDataLists()
     * @uses GetDataLists::setReturnMessage()
     * @param string $loginToken
     * @param string $urlType
     * @param \NineDotMedia\viapost-php\Array\ArrayOfAnyType $dataLists
     * @param string $returnMessage
     */
    public function __construct($loginToken = null, $urlType = null, \NineDotMedia\viapost-php\Array\ArrayOfAnyType $dataLists = null, $returnMessage = null)
    {
        $this
            ->setLoginToken($loginToken)
            ->setUrlType($urlType)
            ->setDataLists($dataLists)
            ->setReturnMessage($returnMessage);
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \NineDotMedia\viapost-php\Struct\GetDataLists
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginToken, true), gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get urlType value
     * @return string|null
     */
    public function getUrlType()
    {
        return $this->urlType;
    }
    /**
     * Set urlType value
     * @param string $urlType
     * @return \NineDotMedia\viapost-php\Struct\GetDataLists
     */
    public function setUrlType($urlType = null)
    {
        // validation for constraint: string
        if (!is_null($urlType) && !is_string($urlType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlType, true), gettype($urlType)), __LINE__);
        }
        $this->urlType = $urlType;
        return $this;
    }
    /**
     * Get dataLists value
     * @return \NineDotMedia\viapost-php\Array\ArrayOfAnyType|null
     */
    public function getDataLists()
    {
        return $this->dataLists;
    }
    /**
     * Set dataLists value
     * @param \NineDotMedia\viapost-php\Array\ArrayOfAnyType $dataLists
     * @return \NineDotMedia\viapost-php\Struct\GetDataLists
     */
    public function setDataLists(\NineDotMedia\viapost-php\Array\ArrayOfAnyType $dataLists = null)
    {
        $this->dataLists = $dataLists;
        return $this;
    }
    /**
     * Get returnMessage value
     * @return string|null
     */
    public function getReturnMessage()
    {
        return $this->returnMessage;
    }
    /**
     * Set returnMessage value
     * @param string $returnMessage
     * @return \NineDotMedia\viapost-php\Struct\GetDataLists
     */
    public function setReturnMessage($returnMessage = null)
    {
        // validation for constraint: string
        if (!is_null($returnMessage) && !is_string($returnMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnMessage, true), gettype($returnMessage)), __LINE__);
        }
        $this->returnMessage = $returnMessage;
        return $this;
    }
}
